/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.Arrays;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.common.ui.EGFCommonUIPlugin;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TargetPlatformPackageDialog
extends ElementListSelectionDialog {
    public TargetPlatformPackageDialog(Shell parent, boolean multi) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof IPlatformGenModel)) {
                    return element == null ? "" : element.toString();
                }
                return ((IPlatformGenModel)element).getURI().toString();
            }

            public Image getImage(Object element) {
                return EGFCommonUIPlugin.getDefault().getImage("elcl16/EPackage.gif");
            }
        });
        this.setMultipleSelection(multi);
        this.setMessage(CoreUIMessages._UI_SelectRegisteredPackageURI);
        this.setFilter("*");
        this.setTitle(CoreUIMessages._UI_RegisteredPackageSelection_label);
    }

    protected void updateElements() {
        Object[] elements = EGFCorePlugin.getPlatformGenModels();
        Arrays.sort(elements);
        this.setListElements(elements);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.updateElements();
        return result;
    }

    public IPlatformGenModel[] getSelectedPlatformGenModels() {
        Object[] objects = this.getResult();
        if (objects != null) {
            return (IPlatformGenModel[])CollectionHelper.toArray(Arrays.asList(objects), IPlatformGenModel.class);
        }
        return null;
    }
}

