/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.config.IComparisonConfiguration;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.diffmerge.defer.diffdeferdata.DeferredComparison;
import org.polarsys.capella.diffmerge.defer.diffdeferdata.DiffdeferdataPackage;
import org.polarsys.capella.diffmerge.defer.ui.DeferredComparisonSourceScope;
import org.polarsys.capella.diffmerge.defer.ui.messages.Messages;
import org.polarsys.capella.diffmerge.defer.ui.views.PendingChangesViewUtil;

public class DeferredComparisonLoader
implements Runnable,
IDisposable {
    protected final URI dComparisonURI;
    protected final DeferredComparisonUsage usage;
    protected Session resultingSession;
    protected EditingDomain resultingEditingDomain;
    protected boolean isDedicatedResourceSet;
    protected DeferredComparison resultingDComparison;
    protected IComparisonConfiguration<EObject> resultingConfiguration;
    protected EMFDiffNode resultingDiffNode;
    protected URI resultingSessionURI;

    public DeferredComparisonLoader(URI dComparisonURI, DeferredComparisonUsage usage) {
        this.dComparisonURI = dComparisonURI;
        this.usage = usage;
        this.resultingSession = null;
        this.resultingEditingDomain = null;
        this.resultingDComparison = null;
        this.resultingDiffNode = null;
        this.isDedicatedResourceSet = true;
    }

    protected void applyOn(IComparisonConfiguration<EObject> config, EComparison comparison) {
        comparison.setLastMatchPolicy(config.getMatchPolicy());
        comparison.setLastDiffPolicy(config.getDiffPolicy());
        comparison.setLastMergePolicy(config.getMergePolicy());
    }

    public void dispose() {
        final MiscUtil.ExtendedUnloader unloader = MiscUtil.ExtendedUnloader.getDefault();
        final HashSet unloaded = new HashSet();
        EditingDomain domain = this.resultingEditingDomain;
        MiscUtil.execute((EditingDomain)domain, (String)Messages.DeferredComparisonLoader_CommandDisposalName, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (DeferredComparisonLoader.this.resultingDComparison != null) {
                    DeferredComparisonLoader.this.resultingDComparison.dispose();
                    Resource dcResource = DeferredComparisonLoader.this.resultingDComparison.eResource();
                    if (dcResource != null) {
                        ResourceSet rs = dcResource.getResourceSet();
                        if (rs != null && DeferredComparisonLoader.this.isDedicatedResourceSet) {
                            unloaded.addAll(rs.getResources());
                            unloader.unloadResources((Iterable)unloaded);
                        } else {
                            unloaded.add(dcResource);
                            unloader.unloadResource(dcResource);
                        }
                    }
                    DeferredComparisonLoader.this.resultingDComparison = null;
                }
                if (DeferredComparisonLoader.this.resultingDiffNode != null) {
                    DeferredComparisonLoader.this.resultingDiffNode.dispose();
                    DeferredComparisonLoader.this.resultingDiffNode = null;
                }
                DeferredComparisonLoader.this.resultingSession = null;
                if (DeferredComparisonLoader.this.isDedicatedResourceSet && DeferredComparisonLoader.this.resultingEditingDomain instanceof TransactionalEditingDomain) {
                    ((TransactionalEditingDomain)DeferredComparisonLoader.this.resultingEditingDomain).dispose();
                }
                DeferredComparisonLoader.this.resultingEditingDomain = null;
            }
        }, (boolean)false);
        unloader.disconnectResources(domain, unloaded);
    }

    protected IComparisonMethodFactory<EObject> getComparisonMethodFactory(String factoryID) {
        IComparisonMethodFactory result = null;
        if (factoryID != null) {
            ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
            result = manager.getComparisonMethodFactory(factoryID);
        }
        return result;
    }

    protected EMFDiffNode getDiffNode(EComparison comparison, EditingDomain domain, boolean readOnly) {
        EMFDiffNode node = new EMFDiffNode((GComparison)comparison, domain, false, !readOnly, Role.REFERENCE);
        node.setReferenceRole(Role.TARGET);
        node.setDrivingRole(Role.TARGET);
        node.addUserProperty(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE, (Object)Boolean.FALSE);
        node.addUserProperty(DefaultUserProperties.P_SUPPORT_UNDO_REDO_OPTIONAL, (Object)Boolean.FALSE);
        node.addUserProperty(PendingChangesViewUtil.P_DEFERRED_LOADER, (Object)this);
        return node;
    }

    protected EditingDomain getEditingDomain(IEditableTreeDataScope<?> scope) {
        EditingDomain result = null;
        if (scope instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)scope).getEditingDomain();
        }
        if (result == null && scope instanceof IPersistentModelScope) {
            Resource resource = ((IPersistentModelScope)scope).getHoldingResource();
            ResourceSet rs = resource == null ? null : resource.getResourceSet();
            result = AdapterFactoryEditingDomain.getEditingDomainFor((Object)rs);
        }
        return result;
    }

    protected ResourceSet getResourceSet(EditingDomain domain) {
        ResourceSet result = null;
        result = domain != null ? domain.getResourceSet() : this.getDefaultResourceSet();
        return result;
    }

    public IComparisonConfiguration<EObject> getResultingConfiguration() {
        return this.resultingConfiguration;
    }

    public DeferredComparison getResultingDeferredComparison() {
        return this.resultingDComparison;
    }

    public EMFDiffNode getResultingDiffNode() {
        return this.resultingDiffNode;
    }

    public EditingDomain getResultingEditingDomain() {
        return this.resultingEditingDomain;
    }

    public Resource getResultingResource() {
        Resource result = null;
        DeferredComparison dComparison = this.getResultingDeferredComparison();
        if (dComparison != null) {
            result = dComparison.eResource();
        }
        return result;
    }

    public Session getResultingSession() {
        return this.resultingSession;
    }

    protected IComparisonConfiguration<EObject> getConfiguration(DeferredComparison dComparison) {
        IComparisonConfiguration result = null;
        String cmFactoryID = dComparison.getComparisonMethodFactoryID();
        IComparisonMethodFactory<EObject> cmFactory = this.getComparisonMethodFactory(cmFactoryID);
        if (cmFactory != null) {
            result = cmFactory.createComparisonConfiguration();
        }
        return result;
    }

    protected ResourceSet getDefaultResourceSet() {
        return new ResourceSetImpl();
    }

    protected DeferredComparison getDeferredComparison(Resource comparisonResource) {
        DeferredComparison result = null;
        if (comparisonResource != null && comparisonResource.isLoaded()) {
            Iterator it = comparisonResource.getContents().iterator();
            while (result == null && it.hasNext()) {
                EObject root = (EObject)it.next();
                if (!(root instanceof DeferredComparison)) continue;
                result = (DeferredComparison)root;
            }
        }
        return result;
    }

    protected DeferredComparison getDeferredComparison(URI dComparisonResourceURI, EditingDomain domain) {
        ResourceSet dComparisonRS = this.getResourceSet(domain);
        Resource dComparisonResource = dComparisonRS.getResource(dComparisonResourceURI, true);
        DeferredComparison dComparison = this.getDeferredComparison(dComparisonResource);
        return dComparison;
    }

    protected Session getSession(URI uri, boolean forceOpen) {
        SessionManager manager = SessionManager.INSTANCE;
        Session result = manager.getExistingSession(uri);
        if (result != null) {
            this.isDedicatedResourceSet = false;
        } else if (forceOpen) {
            result = manager.openSession(uri, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        return result;
    }

    protected IEditableModelScope getSourceScope(DeferredComparison dComparison) {
        DeferredComparisonSourceScope result = new DeferredComparisonSourceScope(dComparison);
        return result;
    }

    protected IEditableTreeDataScope<EObject> getTargetScope(URI targetScopeDefURI, EditingDomain domain, boolean readOnly) {
        IEditableTreeDataScope result = null;
        ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
        List targetScopeFactories = manager.getApplicableModelScopeFactories((Object)targetScopeDefURI);
        if (!targetScopeFactories.isEmpty()) {
            IModelScopeDefinitionFactory selectedTargetScopeFactory = (IModelScopeDefinitionFactory)targetScopeFactories.get(0);
            IModelScopeDefinition targetScopeDef = selectedTargetScopeFactory.createScopeDefinition((Object)targetScopeDefURI, null, !readOnly);
            result = targetScopeDef.createScope((Object)domain);
        }
        return result;
    }

    protected URI getTargetScopeDefinitionURI(URI dComparisonResourceURI) {
        String stringURI = null;
        ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl();
        try {
            InputStream stream = converter.createInputStream(dComparisonResourceURI);
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String ATT_NAME = DiffdeferdataPackage.eINSTANCE.getDeferredComparison_TargetScopeDefinitionURI().getName();
                int position = -1;
                String nextLine = null;
                while (position == -1 && (nextLine = reader.readLine()) != null) {
                    position = nextLine.indexOf(ATT_NAME);
                }
                if (position != -1 && nextLine != null) {
                    int start = position + ATT_NAME.length() + 2;
                    int end = nextLine.indexOf("\"", start);
                    stringURI = nextLine.substring(start, end);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringURI == null ? null : URI.createURI(stringURI);
    }

    public URI getResultingSessionURI() {
        if (this.resultingSessionURI == null) {
            this.resultingSessionURI = this.getTargetScopeDefinitionURI(this.getURI());
        }
        return this.resultingSessionURI;
    }

    public URI getURI() {
        return this.dComparisonURI;
    }

    public boolean isReadOnly() {
        return this.usage == DeferredComparisonUsage.READ_ONLY || (this.usage == DeferredComparisonUsage.WRITE_IN_EXISTING_SESSION || this.usage == DeferredComparisonUsage.WRITE_IN_SESSION) && this.resultingSession == null;
    }

    public boolean isSuccessful() {
        return this.getResultingDiffNode() != null;
    }

    @Override
    public void run() {
        URI targetScopeDefinitionURI = this.getTargetScopeDefinitionURI(this.dComparisonURI);
        if (targetScopeDefinitionURI != null) {
            boolean targetScopeReadOnly;
            TransactionalEditingDomain knownDomain;
            IEditableTreeDataScope<EObject> targetScope;
            if (!PendingChangesViewUtil.getFile(targetScopeDefinitionURI).exists()) {
                String relativeURI = PendingChangesViewUtil.getRelativeURI(targetScopeDefinitionURI);
                String targetFile = relativeURI != null ? relativeURI : targetScopeDefinitionURI.toString();
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.DeferredComparisonLoader_Error, (String)NLS.bind((String)Messages.DeferredComparisonLoader_ErrorMsg, (Object)targetFile));
                return;
            }
            this.resultingSession = this.getSession(targetScopeDefinitionURI, this.usage == DeferredComparisonUsage.WRITE_IN_SESSION);
            if (this.resultingSession == null && MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.DeferredComparisonLoader_OpenSessionTitle, (String)Messages.DeferredComparisonLoader_OpenSessionQuestion)) {
                this.doOpenSession(targetScopeDefinitionURI);
                this.doOpenActivityExplorer();
            }
            if ((targetScope = this.getTargetScope(targetScopeDefinitionURI, (EditingDomain)(knownDomain = this.resultingSession == null ? null : this.resultingSession.getTransactionalEditingDomain()), targetScopeReadOnly = this.isReadOnly())) != null) {
                this.resultingEditingDomain = this.getEditingDomain(targetScope);
                this.resultingDComparison = this.getDeferredComparison(this.dComparisonURI, this.resultingEditingDomain);
                if (this.resultingDComparison != null) {
                    ResourceSet rs;
                    Resource dcResource = this.getResultingResource();
                    ResourceSet resourceSet = rs = dcResource == null ? null : dcResource.getResourceSet();
                    if (rs != null) {
                        rs.getResources().remove((Object)dcResource);
                        new ResourceSetImpl().getResources().add((Object)dcResource);
                    }
                    EComparison comparison = this.resultingDComparison.getActualComparison();
                    comparison.setTargetScope(targetScope);
                    IEditableModelScope sourceScope = this.getSourceScope(this.resultingDComparison);
                    comparison.setReferenceScope((IEditableTreeDataScope)sourceScope);
                    this.resultingConfiguration = this.getConfiguration(this.resultingDComparison);
                    if (this.resultingConfiguration != null) {
                        this.applyOn(this.resultingConfiguration, comparison);
                        this.resultingDiffNode = this.getDiffNode(comparison, this.resultingEditingDomain, targetScopeReadOnly);
                        this.resultingDComparison.setTransientData((EObject)this.resultingDiffNode.getUIComparison());
                    }
                    if (rs != null) {
                        rs.getResources().add((Object)dcResource);
                    }
                }
            }
        }
    }

    private void doOpenSession(final URI targetScopeDefinitionURI) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                DeferredComparisonLoader.this.resultingSession = SessionManager.INSTANCE.getSession(targetScopeDefinitionURI, monitor);
                if (DeferredComparisonLoader.this.resultingSession != null) {
                    DeferredComparisonLoader.this.resultingSession.open(monitor);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.resultingSession = this.getSession(targetScopeDefinitionURI, false);
    }

    protected void doOpenActivityExplorer() {
        if (this.resultingSession != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (DeferredComparisonLoader.this.resultingSession.isOpen()) {
                            activePage.openEditor((IEditorInput)new ActivityExplorerEditorInput(DeferredComparisonLoader.this.resultingSession, (EObject)SessionHelper.getCapellaProject((Session)DeferredComparisonLoader.this.resultingSession)), "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor", true, 3);
                        }
                    }
                    catch (PartInitException exception) {
                        exception.printStackTrace();
                    }
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static enum DeferredComparisonUsage {
        READ_ONLY,
        WRITE_IN_EXISTING_SESSION,
        WRITE_IN_SESSION,
        WRITE_ALWAYS;

    }
}

