/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public class CyberActorTransitionTest
extends CyberTopDownTransitionTestCase {
    private static final String OPERATIONAL_ENTITY = "89336d07-e5d3-4846-9ed1-0ac0189462b9";
    ThreatSourceUse threatUse;
    TrustBoundaryStorage trustBoundaryStorage;
    Entity usedActor;
    Entity operationalActor;

    @Override
    protected void init() {
        super.init();
        this.usedActor = OaFactory.eINSTANCE.createEntity();
        this.threatUse = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        this.trustBoundaryStorage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
        this.operationalActor = (Entity)((Entity)this.getObject(OPERATIONAL_ENTITY)).getSubEntities().get(0);
        this.trustBoundaryStorage.setThreatSource(true);
        this.trustBoundaryStorage.setThreatSourceProfile(3);
        this.threatUse.setUsed((Component)this.usedActor);
        this.operationalActor.getOwnedExtensions().add((Object)this.threatUse);
        this.operationalActor.getOwnedExtensions().add((Object)this.trustBoundaryStorage);
    }

    @Override
    public void doTest() {
        this.performOE2ActorTransition(this.getObjects(new String[]{this.operationalActor.getId()}));
        SystemComponent systemActor = (SystemComponent)this.mustBeTransitionedDirecltyContainedBy(this.operationalActor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.saArch, (boolean)false));
        ThreatSourceUse systemThreatUse = (ThreatSourceUse)this.mustBeTransitionedDirecltyContainedBy(this.threatUse.getId(), (EObject)systemActor);
        TrustBoundaryStorage transitionedTrustBoundStorage = (TrustBoundaryStorage)this.mustBeTransitionedDirecltyContainedBy(this.trustBoundaryStorage.getId(), (EObject)systemActor);
        this.checkTrustBoundaryStorageProperlyTransitioned(transitionedTrustBoundStorage);
        this.performActorTransition(this.getObjects(new String[]{systemActor.getId()}));
        LogicalComponent logicalActor = (LogicalComponent)this.mustBeTransitionedDirecltyContainedBy(systemActor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.laArch, (boolean)false));
        ThreatSourceUse logicalThreatUse = (ThreatSourceUse)this.mustBeTransitionedDirecltyContainedBy(systemThreatUse.getId(), (EObject)logicalActor);
        transitionedTrustBoundStorage = (TrustBoundaryStorage)this.mustBeTransitionedDirecltyContainedBy(transitionedTrustBoundStorage.getId(), (EObject)logicalActor);
        this.checkTrustBoundaryStorageProperlyTransitioned(transitionedTrustBoundStorage);
        this.performActorTransition(this.getObjects(new String[]{logicalActor.getId()}));
        PhysicalComponent physicalActor = (PhysicalComponent)this.mustBeTransitionedDirecltyContainedBy(logicalActor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.paArch, (boolean)false));
        this.mustBeTransitionedDirecltyContainedBy(logicalThreatUse.getId(), (EObject)physicalActor);
        this.mustBeTransitionedDirecltyContainedBy(transitionedTrustBoundStorage.getId(), (EObject)physicalActor);
        this.checkTrustBoundaryStorageProperlyTransitioned(transitionedTrustBoundStorage);
    }

    private void checkTrustBoundaryStorageProperlyTransitioned(TrustBoundaryStorage transitionedTrustBoundStorage) {
        CyberActorTransitionTest.assertEquals((int)this.trustBoundaryStorage.getThreatSourceProfile(), (int)transitionedTrustBoundStorage.getThreatSourceProfile());
        CyberActorTransitionTest.assertEquals((boolean)this.trustBoundaryStorage.isThreatSource(), (boolean)transitionedTrustBoundStorage.isThreatSource());
        CyberActorTransitionTest.assertEquals((boolean)this.trustBoundaryStorage.isTrusted(), (boolean)transitionedTrustBoundStorage.isTrusted());
        CyberActorTransitionTest.assertEquals((String)this.trustBoundaryStorage.getDescription(), (String)transitionedTrustBoundStorage.getDescription());
    }
}

