/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.provider.CybersecurityEditPlugin;
import org.polarsys.capella.cybersecurity.ui.properties.fields.EnumerationLiterealValueRadioGroup;
import org.polarsys.capella.cybersecurity.ui.properties.fields.IntegerValueRadioGroup;
import org.polarsys.capella.cybersecurity.ui.properties.sections.Messages;

public class ThreatSection
extends AbstractSection {
    EnumerationLiterealValueRadioGroup threatKindGroup;
    TextValueGroup rationaleGroup;
    IntegerValueRadioGroup levelGroup;

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest instanceof Threat;
    }

    protected void createContents(Composite rootParentComposite, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(rootParentComposite, aTabbedPropertySheetPage);
        this.threatKindGroup = null;
        this.levelGroup = null;
        this.rationaleGroup = null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        this.loadData(newEObject);
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        if (this.threatKindGroup == null || this.levelGroup == null || this.rationaleGroup == null) {
            this.createThreatKindGroup(capellaElement);
            this.levelGroup = new IntegerValueRadioGroup(this.rootParentComposite, Messages.ThreatSection_0, this.getWidgetFactory(), 1, 5);
            this.rationaleGroup = new TextAreaValueGroup(this.rootParentComposite, Messages.ActorCybersecuritySection_1, this.getWidgetFactory());
        }
        this.threatKindGroup.loadData(capellaElement, (EStructuralFeature)CybersecurityPackage.Literals.THREAT__KIND);
        this.levelGroup.loadData(capellaElement, (EStructuralFeature)CybersecurityPackage.Literals.THREAT__LEVEL);
        this.rationaleGroup.loadData(capellaElement, (EStructuralFeature)CybersecurityPackage.Literals.THREAT__RATIONALE);
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.add((AbstractSemanticField)this.threatKindGroup);
        fields.add((AbstractSemanticField)this.levelGroup);
        fields.add((AbstractSemanticField)this.rationaleGroup);
        return fields;
    }

    protected void createThreatKindGroup(EObject capellaElement) {
        EObject element = capellaElement;
        Session session = SessionManager.INSTANCE.getSession(element);
        Project project = SessionHelper.getCapellaProject((Session)session);
        this.threatKindGroup = new EnumerationLiterealValueRadioGroup(this.rootParentComposite, CybersecurityEditPlugin.INSTANCE.getString("_UI_Threat_threatKind_feature"), CybersecurityQueries.getThreatKindPropertyType((Project)project), this.getWidgetFactory(), 3){

            @Override
            public void loadData(EObject capellaElement, EStructuralFeature feature) {
                super.loadData(capellaElement, feature);
                Object value = this.semanticElement.eGet(this.semanticFeature);
                for (Button button : this.getSemanticFields()) {
                    if (button == null) continue;
                    button.setSelection(value != null ? value.equals(button.getData()) : false);
                }
            }
        };
    }
}

