/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public abstract class ScenarioTransitionTest
extends CyberTopDownTransitionTestCase {
    Scenario interfaceScenario;
    Scenario exchangeScenario;
    Scenario functionScenario;
    Threat threat;
    CybersecurityPkg currentPkg;
    CybersecurityPkg nextPkg;

    @Override
    protected void init() {
        super.init();
        this.threat = CybersecurityFactory.eINSTANCE.createThreat();
        this.currentPkg = this.getCurrentPackage();
        this.nextPkg = this.getNextPkg();
        this.currentPkg.getOwnedThreats().add((Object)this.threat);
        this.initScenarios();
    }

    protected abstract CybersecurityPkg getCurrentPackage();

    protected abstract CybersecurityPkg getNextPkg();

    protected void initScenarios() {
        this.interfaceScenario = this.createScenario(ScenarioKind.INTERFACE);
        this.exchangeScenario = this.createScenario(ScenarioKind.DATA_FLOW);
        this.functionScenario = this.createScenario(ScenarioKind.FUNCTIONAL);
        EList threatScenarios = this.threat.getOwnedScenarios();
        threatScenarios.add((Object)this.interfaceScenario);
        threatScenarios.add((Object)this.exchangeScenario);
        threatScenarios.add((Object)this.functionScenario);
    }

    protected Scenario createScenario(ScenarioKind kind) {
        Scenario scenario = InteractionFactory.eINSTANCE.createScenario();
        scenario.setKind(kind);
        return scenario;
    }

    @Override
    protected void doTest() {
        this.performIStoISTransition(this.getObjects(new String[]{this.interfaceScenario.getId()}));
        EObject threat2 = this.mustBeTransitioned(this.threat.getId(), (EObject)this.nextPkg);
        this.mustBeTransitioned(this.interfaceScenario.getId(), threat2);
        this.performEStoISTransition(this.getObjects(new String[]{this.exchangeScenario.getId()}));
        this.mustBeTransitioned(this.exchangeScenario.getId(), (EObject)this.threat);
        this.performEStoESTransition(this.getObjects(new String[]{this.exchangeScenario.getId()}));
        this.mustBeMultiTransitioned(this.exchangeScenario.getId(), 2);
        this.performESFtoESBTransition(this.getObjects(new String[]{this.exchangeScenario.getId()}));
        this.mustBeMultiTransitioned(this.exchangeScenario.getId(), 3);
        this.performFStoFSTransition(this.getObjects(new String[]{this.functionScenario.getId()}));
        this.mustBeTransitioned(this.functionScenario.getId(), threat2);
        this.performFStoESTransition(this.getObjects(new String[]{this.functionScenario.getId()}));
        this.mustBeMultiTransitioned(this.functionScenario.getId(), 2);
    }
}

