/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import java.util.List;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class WtpClasspathUpdater {
    private static final String DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.dependency";
    private static final String NON_DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.nondependency";

    WtpClasspathUpdater() {
    }

    public static void update(IJavaProject javaProject, OmniEclipseProject project, SubMonitor progress) throws JavaModelException {
        List dependencies = project.getExternalDependencies();
        String deploymentPath = WtpClasspathUpdater.getDeploymentPath(dependencies);
        if (deploymentPath != null) {
            WtpClasspathUpdater.updateDeploymentPath(javaProject, deploymentPath, progress);
        } else if (WtpClasspathUpdater.hasNonDeploymentAttributes(dependencies)) {
            WtpClasspathUpdater.markAsNonDeployed(javaProject, progress);
        }
    }

    private static String getDeploymentPath(List<OmniExternalDependency> dependencies) {
        String deploymentPath = null;
        for (OmniExternalDependency dependency : dependencies) {
            for (OmniClasspathAttribute attribute : dependency.getClasspathAttributes()) {
                if (!attribute.getName().equals(DEPLOYMENT_ATTRIBUTE)) continue;
                if (deploymentPath != null && !deploymentPath.equals(attribute.getValue())) {
                    throw new IllegalStateException("WTP currently does not support mixed deployment paths.");
                }
                deploymentPath = attribute.getValue();
            }
        }
        return deploymentPath;
    }

    private static boolean hasNonDeploymentAttributes(List<OmniExternalDependency> dependencies) {
        for (OmniExternalDependency dependency : dependencies) {
            for (OmniClasspathAttribute attribute : dependency.getClasspathAttributes()) {
                if (!attribute.getName().equals(NON_DEPLOYMENT_ATTRIBUTE)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateDeploymentPath(IJavaProject javaProject, String deploymentPath, SubMonitor progress) throws JavaModelException {
        GradleClasspathContainer.updateAttributes(javaProject, new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)DEPLOYMENT_ATTRIBUTE, (String)deploymentPath)}, progress);
    }

    private static void markAsNonDeployed(IJavaProject javaProject, SubMonitor progress) throws JavaModelException {
        GradleClasspathContainer.updateAttributes(javaProject, new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)NON_DEPLOYMENT_ATTRIBUTE, (String)"")}, progress);
    }
}

