/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;

public class ToolPaletteDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "toolPalette";
    public static final String TOOLPART_ID = "ToolPartID";
    public static final String TOOLPART_OPTIONAL = "ToolPartOptional";
    public static final String DEFAULT_PALETTE_ID = "org.bpmn2.modeler.toolpalette.default.categories";
    String profileId;
    List<CategoryDescriptor> categories = new ArrayList<CategoryDescriptor>();

    public ToolPaletteDescriptor() {
    }

    public ToolPaletteDescriptor(IConfigurationElement e) {
        super(e);
        this.profileId = e.getAttribute("profile");
        IConfigurationElement[] iConfigurationElementArray = e.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            if (c.getName().equals("category")) {
                String cid = c.getAttribute("id");
                String name = c.getAttribute("name");
                String description = c.getAttribute("description");
                String icon = c.getAttribute("icon");
                CategoryDescriptor category = this.addCategory(cid, name, description, icon);
                cid = c.getAttribute("before");
                if (cid != null) {
                    category.setBefore(cid);
                }
                if ((cid = c.getAttribute("after")) != null) {
                    category.setAfter(cid);
                }
                if ((cid = c.getAttribute("fromPalette")) != null) {
                    category.setFromPalette(cid);
                }
                IConfigurationElement[] iConfigurationElementArray2 = c.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement t = iConfigurationElementArray2[n4];
                    if (t.getName().equals("tool")) {
                        String tid = t.getAttribute("id");
                        name = t.getAttribute("name");
                        description = t.getAttribute("description");
                        icon = t.getAttribute("icon");
                        String object = t.getAttribute("object");
                        ToolDescriptor tool = null;
                        if (object != null && !object.isEmpty()) {
                            tool = category.addTool(tid, name, description, icon, object);
                        } else {
                            tool = category.addTool(tid, name, description, icon);
                            IConfigurationElement[] iConfigurationElementArray3 = t.getChildren();
                            int n5 = iConfigurationElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement tc = iConfigurationElementArray3[n6];
                                if ("object".equals(tc.getName())) {
                                    String id = tc.getAttribute("id");
                                    String type = tc.getAttribute("type");
                                    String optional = tc.getAttribute("optional");
                                    ToolPart tp = tool.parseToolObjectString(type);
                                    if (id != null && !id.isEmpty()) {
                                        tp.getProperties().put(TOOLPART_ID, id);
                                    }
                                    if ("true".equals(optional)) {
                                        tp.getProperties().put(TOOLPART_OPTIONAL, optional);
                                    }
                                }
                                ++n6;
                            }
                        }
                        tid = c.getAttribute("fromPalette");
                        if (tid != null) {
                            tool.setFromPalette(cid);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    protected CategoryDescriptor addCategory(String id, String name, String description, String icon) {
        CategoryDescriptor category = null;
        for (CategoryDescriptor cd : this.categories) {
            if (!cd.getId().equals(id)) continue;
            category = cd;
            break;
        }
        if (category == null) {
            category = new CategoryDescriptor(this, id, name, description, icon);
            this.categories.add(category);
        }
        return category;
    }

    public void sortCategories() {
        ArrayList<CategoryDescriptor> sorted = new ArrayList<CategoryDescriptor>();
        sorted.addAll(this.categories);
        boolean changed = false;
        block0: for (CategoryDescriptor movedCategory : this.categories) {
            String after;
            String before = movedCategory.getBefore();
            if (before != null) {
                for (CategoryDescriptor cd : sorted) {
                    if (!cd.getId().equals(before)) continue;
                    sorted.remove(movedCategory);
                    int i = sorted.indexOf(cd);
                    sorted.add(i, movedCategory);
                    changed = true;
                    break;
                }
            }
            if ((after = movedCategory.getAfter()) == null) continue;
            for (CategoryDescriptor cd : sorted) {
                if (!cd.getId().equals(after)) continue;
                sorted.remove(movedCategory);
                int i = sorted.indexOf(cd);
                if (i + 1 < sorted.size()) {
                    sorted.add(i + 1, movedCategory);
                } else {
                    sorted.add(movedCategory);
                }
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.categories.clear();
            this.categories.addAll(sorted);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<String> getProfileIds() {
        String[] a = this.profileId.split(" ");
        ArrayList<String> profiles = new ArrayList<String>();
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            profiles.add(p.trim());
            ++n2;
        }
        return profiles;
    }

    public List<CategoryDescriptor> getCategories() {
        return this.categories;
    }

    public static class CategoryDescriptor {
        private ToolPaletteDescriptor parent;
        private String id;
        private String before;
        private String after;
        private String name;
        private String description;
        private String icon;
        private String fromPalette;
        private List<ToolDescriptor> tools = new ArrayList<ToolDescriptor>();

        public CategoryDescriptor(ToolPaletteDescriptor parent, String id, String name, String description, String icon) {
            this.parent = parent;
            this.id = id;
            this.name = name;
            this.description = description;
            this.icon = icon;
        }

        public ToolDescriptor addTool(String id, String name, String description, String icon, String object) {
            ToolDescriptor tool = new ToolDescriptor(this, id, name, description, icon, object);
            this.tools.add(tool);
            return tool;
        }

        public ToolDescriptor addTool(String id, String name, String description, String icon) {
            ToolDescriptor tool = new ToolDescriptor(this, id, name, description, icon);
            this.tools.add(tool);
            return tool;
        }

        public List<ToolDescriptor> getTools() {
            return this.tools;
        }

        public String getId() {
            return this.id;
        }

        public void setBefore(String before) {
            this.before = before;
        }

        public String getBefore() {
            return this.before;
        }

        public void setAfter(String after) {
            this.after = after;
        }

        public String getAfter() {
            return this.after;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getFromPalette() {
            return this.fromPalette;
        }

        public void setFromPalette(String fromPalette) {
            this.fromPalette = fromPalette;
        }

        public ToolPaletteDescriptor getParent() {
            return this.parent;
        }
    }

    public static class ToolDescriptor {
        private CategoryDescriptor parent;
        private String id;
        private String name;
        private String description;
        private String icon;
        private String fromPalette;
        private List<ToolPart> toolParts = new ArrayList<ToolPart>(){

            @Override
            public boolean add(ToolPart tp) {
                return super.add(tp);
            }
        };

        public ToolDescriptor(CategoryDescriptor parent, String id, String name, String description, String icon) {
            this.parent = parent;
            this.id = id;
            this.name = name;
            this.description = description;
            this.icon = icon;
        }

        public ToolDescriptor(CategoryDescriptor parent, String id, String name, String description, String icon, String object) {
            this(parent, id, name, description, icon);
            this.parseToolObjectString(object);
        }

        public ToolPart parseToolObjectString(String object) {
            List currentParts = this.toolParts;
            ToolPart toolPart = null;
            String toolPartName = "";
            Stack<List> stack = new Stack<List>();
            ToolPart result = null;
            char[] chars = object.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c == '+') {
                    stack.push(currentParts);
                    if (!"".equals(toolPartName)) {
                        toolPart = new ToolPart(this, toolPartName);
                        currentParts.add(toolPart);
                    }
                    currentParts = toolPart.children;
                    if (result == null) {
                        result = toolPart;
                    }
                    toolPartName = "";
                } else if (c == '-') {
                    if (!"".equals(toolPartName)) {
                        currentParts.add(new ToolPart(this, toolPartName));
                    }
                    currentParts = (List)stack.pop();
                    toolPartName = "";
                } else if (c == ',') {
                    if (!"".equals(toolPartName)) {
                        toolPart = new ToolPart(this, toolPartName);
                        currentParts.add(toolPart);
                        if (result == null) {
                            result = toolPart;
                        }
                        toolPartName = "";
                    }
                } else if (c == '[') {
                    toolPart = new ToolPart(this, toolPartName);
                    currentParts.add(toolPart);
                    if (result == null) {
                        result = toolPart;
                    }
                    toolPartName = "";
                    ++i;
                    do {
                        String prop = "";
                        while (i < chars.length) {
                            if ((c = chars[i++]) == '\\') {
                                c = chars[i++];
                            } else if (c == '=') break;
                            prop = String.valueOf(prop) + c;
                        }
                        String value = "";
                        boolean quote = false;
                        while (i < chars.length) {
                            if ((c = chars[i++]) == '\'') {
                                quote = !quote;
                                continue;
                            }
                            if (c == '\\') {
                                c = chars[i++];
                            } else if (!quote && (c == ',' || c == ']')) break;
                            value = String.valueOf(value) + c;
                        }
                        toolPart.putProperty(prop, value);
                    } while (i < chars.length && c != ']');
                    if (c == ']') {
                        --i;
                    }
                } else if ("".equals(toolPartName)) {
                    if (Character.isJavaIdentifierStart(c)) {
                        toolPartName = String.valueOf(toolPartName) + c;
                    }
                } else if (Character.isJavaIdentifierPart(c)) {
                    toolPartName = String.valueOf(toolPartName) + c;
                }
                if (i == chars.length - 1 && !toolPartName.isEmpty()) {
                    toolPart = new ToolPart(this, toolPartName);
                    currentParts.add(toolPart);
                    if (result == null) {
                        result = toolPart;
                    }
                }
                ++i;
            }
            return result;
        }

        public ToolDescriptor(CategoryDescriptor parent, String name, String description, String icon) {
            this.parent = parent;
            this.name = name;
            this.description = description;
            this.icon = icon;
        }

        public List<ToolPart> getToolParts() {
            return this.toolParts;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getFromPalette() {
            return this.fromPalette;
        }

        public void setFromPalette(String fromPalette) {
            this.fromPalette = fromPalette;
        }

        public CategoryDescriptor getParent() {
            return this.parent;
        }
    }

    public static class ToolPart {
        private ToolDescriptor parent;
        private String name;
        private List<ToolPart> children = new ArrayList<ToolPart>();
        private Hashtable<String, String> properties = null;

        public ToolPart(ToolDescriptor parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<ToolPart> getChildren() {
            return this.children;
        }

        public void putProperty(String name, String value) {
            this.getProperties().put(name, value);
        }

        public Hashtable<String, String> getProperties() {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            return this.properties;
        }

        public String getProperty(String name) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(name);
        }

        public boolean hasProperties() {
            return this.properties != null && this.properties.size() > 0;
        }

        public ToolDescriptor getParent() {
            return this.parent;
        }
    }
}

