/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.examples.customtask;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.CustomConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.examples.customtask.MyModel.MyModelFactory;
import org.eclipse.bpmn2.modeler.examples.customtask.MyModel.MyModelPackage;
import org.eclipse.bpmn2.modeler.examples.customtask.MyModel.TemporalDependency;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class CustomTemporalDependencyFeatureContainer
extends CustomConnectionFeatureContainer {
    public static String TEMPORAL_DEPENDENCY_ID = "org.eclipse.bpmn2.modeler.examples.customtask.temporalDependency";

    public CustomTemporalDependencyFeatureContainer() {
        this.setId(TEMPORAL_DEPENDENCY_ID);
    }

    public String getId(EObject object) {
        if (object instanceof TemporalDependency) {
            return TEMPORAL_DEPENDENCY_ID;
        }
        return null;
    }

    protected IFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        return new TemporalDependencyFeatureContainer();
    }

    public class AddTemporalDependencyFeature
    extends AbstractAddFlowFeature<TemporalDependency> {
        public AddTemporalDependencyFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Polyline createConnectionLine(Connection connection) {
            IPeService peService = Graphiti.getPeService();
            IGaService gaService = Graphiti.getGaService();
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineStyle(LineStyle.SOLID);
            connectionLine.setLineWidth(Integer.valueOf(2));
            int w = 5;
            int l = 15;
            ConnectionDecorator decorator = peService.createConnectionDecorator(connection, false, 1.0, true);
            int[] nArray = new int[8];
            nArray[0] = -l;
            nArray[1] = w;
            nArray[4] = -l;
            nArray[5] = -w;
            nArray[6] = -l;
            nArray[7] = w;
            Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)decorator, nArray);
            StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)be);
            return connectionLine;
        }

        public Class<? extends BaseElement> getBusinessObjectType() {
            return TemporalDependency.class;
        }
    }

    public class CreateTemporalDependencyFeature
    extends AbstractCreateFlowFeature<TemporalDependency, BoundaryEvent, BoundaryEvent> {
        public CreateTemporalDependencyFeature(IFeatureProvider fp) {
            super(fp);
        }

        public TemporalDependency createBusinessObject(ICreateConnectionContext context) {
            TemporalDependency businessObject = MyModelFactory.eINSTANCE.createTemporalDependency();
            BoundaryEvent source = (BoundaryEvent)this.getSourceBo(context);
            BoundaryEvent target = (BoundaryEvent)this.getTargetBo(context);
            businessObject.setSourceRef(source);
            businessObject.setTargetRef(target);
            EObject container = source.eContainer();
            while (container != null) {
                if (container instanceof FlowElementsContainer) {
                    ((FlowElementsContainer)container).getFlowElements().add(businessObject);
                    break;
                }
                container = container.eContainer();
            }
            this.putBusinessObject(context, (BaseElement)businessObject);
            this.changesDone = true;
            return businessObject;
        }

        public EClass getBusinessObjectClass() {
            return MyModelPackage.eINSTANCE.getTemporalDependency();
        }

        protected String getStencilImageId() {
            return null;
        }

        protected Class<BoundaryEvent> getSourceClass() {
            return BoundaryEvent.class;
        }

        protected Class<BoundaryEvent> getTargetClass() {
            return BoundaryEvent.class;
        }
    }

    public class TemporalDependencyFeatureContainer
    extends BaseElementConnectionFeatureContainer {
        public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
            return new CreateTemporalDependencyFeature(fp);
        }

        public IAddFeature getAddFeature(IFeatureProvider fp) {
            return new AddTemporalDependencyFeature(fp);
        }
    }
}

