/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class ShowPropertiesFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;

    public ShowPropertiesFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.ShowPropertiesFeature_Name;
    }

    public String getDescription() {
        return Messages.ShowPropertiesFeature_Title;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
        if (pes.length == 1) {
            return Bpmn2Preferences.getInstance(businessObject).hasPopupConfigDialog(businessObject);
        }
        return false;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        DiagramEditor editor = (DiagramEditor)this.getDiagramBehavior().getDiagramContainer();
        editor.setPictogramElementForSelection(pes[0]);
        this.getDiagramBehavior().refresh();
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
        ObjectEditingDialog dialog = new ObjectEditingDialog(editor, businessObject);
        this.changesDone = dialog.open() == 0 ? dialog.hasDoneChanges() : false;
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    public String getImageId() {
        return "org.eclipse.bpmn2.modeler.icons.properties.16";
    }
}

