/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.indent;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.SQLHeuristicScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.SQLIndenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class SQLAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private boolean _closeBeginEnd;
    private String _partitioning;
    private Map _autoCompletionMap = new HashMap();

    public SQLAutoIndentStrategy(String partitioning) {
        this._partitioning = partitioning;
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(d);
        SQLIndenter indenter = new SQLIndenter(d, scanner);
        int previousToken = scanner.previousToken(c.offset - 1, -2);
        StringBuffer indent = null;
        StringBuffer beginIndentaion = new StringBuffer();
        if (this.isSupportedAutoCompletionToken(previousToken)) {
            indent = indenter.computeIndentation(c.offset);
            beginIndentaion.append(indenter.getReferenceIndentation(c.offset));
        } else {
            indent = indenter.getReferenceIndentation(c.offset);
        }
        if (indent == null) {
            indent = new StringBuffer();
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this._partitioning, (int)start, (boolean)true);
            if ("sql_multiline_comment".equals(region.getType())) {
                start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            c.caretOffset = c.offset + buf.length();
            c.shiftsCaret = false;
            if (this.isSupportedAutoCompletionToken(previousToken) && !this.isClosed(d, c.offset, previousToken) && this.getTokenCount(start, c.offset, scanner, previousToken) > 0) {
                buf.append(SQLAutoIndentStrategy.getLineDelimiter(d));
                buf.append(beginIndentaion);
                buf.append(this.getAutoCompletionTrail(previousToken));
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException badLocationException) {}
        return System.getProperty("line.separator");
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        }
    }

    private boolean closeBeginEnd() {
        return this._closeBeginEnd;
    }

    private void clearCachedValues() {
        this._autoCompletionMap.clear();
        IPreferenceStore preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
        this._closeBeginEnd = preferenceStore.getBoolean("SQLEditor.closeBeginEndStatement");
        if (this._closeBeginEnd) {
            this._autoCompletionMap.put(new Integer(1000), "end ");
            this._autoCompletionMap.put(new Integer(1001), "END ");
        }
    }

    private boolean isSupportedAutoCompletionToken(int token) {
        return this._autoCompletionMap.containsKey(new Integer(token));
    }

    private String getAutoCompletionTrail(int token) {
        return (String)this._autoCompletionMap.get(new Integer(token));
    }

    private int getTokenCount(int startOffset, int endOffset, SQLHeuristicScanner scanner, int token) {
        int tokenCount = 0;
        while (startOffset < endOffset) {
            int nextToken = scanner.nextToken(startOffset, endOffset);
            int position = scanner.getPosition();
            if (nextToken != -1 && scanner.isSameToken(nextToken, token)) {
                ++tokenCount;
            }
            startOffset = position;
        }
        return tokenCount;
    }

    private boolean isClosed(IDocument document, int offset, int token) {
        if (token == 1001 || token == 1000) {
            return SQLAutoIndentStrategy.getBlockBalance(document, offset) <= 0;
        }
        return false;
    }

    private static int getBlockBalance(IDocument document, int offset) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset;
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(document);
        do {
            begin = scanner.findOpeningPeer(begin, 1001, 1003);
            end = scanner.findClosingPeer(end, 1001, 1003);
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }
}

