/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.debug.internal.core.vm.ReportVMClient;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.AbstractScriptVMRunner;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportLaunchHelper;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportStandardAppLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class StandardScriptVMRunner
extends AbstractScriptVMRunner {
    protected static final String JAVA_JVM_VERSION = "JAVA_JVM_VERSION";
    protected ReportStandardAppLaunchDelegate delegate;

    public StandardScriptVMRunner(IVMInstall vmInstance, ReportStandardAppLaunchDelegate delegate) {
        super(vmInstance);
        this.delegate = delegate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        debugType = this.delegate.getDebugType();
        debugJava = (debugType & 1) != 0;
        v0 = debugScript = (debugType & 2) != 0;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("Launching VM...", 4);
        subMonitor.subTask("Constructing command line... ");
        program = this.constructProgramString(config);
        arguments = new ArrayList<String>();
        arguments.add(program);
        port = -1;
        if (debugJava) {
            version = this.getJavaVersion();
            if (version < 1.5) {
                arguments.add("-Xdebug");
                arguments.add("-Xnoagent");
            }
            port = StandardScriptVMRunner.findFreePort();
            if (version < 1.4) {
                arguments.add("-Djava.compiler=NONE");
            }
            if (version < 1.5) {
                arguments.add("-Xrunjdwp:transport=dt_socket,suspend=y,address=localhost:" + port);
            } else {
                arguments.add("-agentlib:jdwp=transport=dt_socket,suspend=y,address=localhost:" + port);
            }
        }
        allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        this.delegate.helper.addParameterArgs(arguments);
        this.delegate.helper.addDataLimitArgs(arguments);
        this.delegate.helper.addEngineHomeArgs(arguments);
        this.delegate.helper.addResourceFolder(arguments);
        this.delegate.helper.addFileNameArgs(arguments);
        this.delegate.helper.addTempFolder(arguments);
        this.delegate.helper.addTypeArgs(arguments);
        this.delegate.helper.addPortArgs(arguments);
        this.delegate.helper.addUserClassPath(arguments, launch.getLaunchConfiguration());
        arguments.add(config.getClassToLaunch());
        programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        envp = this.prependJREPath(config.getEnvironment());
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        if (debugJava) {
            subMonitor.subTask("Creating debug process...");
            connector = this.getConnector();
            if (connector == null) {
                this.abort("Couldn't find an appropriate debug connector", null, 119);
            }
            map = connector.defaultArguments();
            this.specifyArguments(map, port);
            p = null;
            try {
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    connector.startListening(map);
                    workingDir = this.getWorkingDir(config);
                    p = this.exec(cmdLine, workingDir, envp);
                    if (p == null) {
                        return;
                    }
                    if (monitor.isCanceled()) {
                        p.destroy();
                        return;
                    }
                    process = this.newProcess(launch, p, cmdLine[0], this.getDefaultProcessMap());
                    process.setAttribute(IProcess.ATTR_CMDLINE, StandardScriptVMRunner.renderCommandLine(cmdLine));
                    subMonitor.worked(1);
                    subMonitor.subTask("Establishing debug connection...");
                    retry = false;
                    while (true) {
                        try {
                            runnable = new ConnectRunnable(connector, map);
                            connectThread = new Thread((Runnable)runnable, "Listening Connector");
                            connectThread.setDaemon(true);
                            connectThread.start();
                            while (connectThread.isAlive()) {
                                if (!monitor.isCanceled()) ** break block46
                                try {
                                    connector.stopListening(map);
                                }
                                catch (IOException var24_33) {
                                    // empty catch block
                                }
                                p.destroy();
                                return;
                            }
                        }
                        catch (InterruptedIOException e) {
                            this.checkErrorMessage(process);
                            status = new Status(4, "org.eclipse.birt.report.script.debug.launching", 117, "", (Throwable)e);
                            handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                            retry = false;
                            if (handler == null) {
                                throw new CoreException((IStatus)status);
                            }
                            result = handler.handleStatus((IStatus)status, (Object)this);
                            if (!(result instanceof Boolean)) continue;
                            retry = (Boolean)result;
                            if (retry) continue;
                            break;
                        }
                        {
                            try {
                                p.exitValue();
                                try {
                                    connector.stopListening(map);
                                }
                                catch (IOException var24_34) {
                                    // empty catch block
                                }
                                this.checkErrorMessage(process);
                            }
                            catch (IllegalThreadStateException var24_35) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException var24_36) {
                                // empty catch block
                            }
                            continue;
                        }
                        ex = runnable.getException();
                        if (ex instanceof IllegalConnectorArgumentsException) {
                            throw (IllegalConnectorArgumentsException)ex;
                        }
                        if (ex instanceof InterruptedIOException) {
                            throw (InterruptedIOException)ex;
                        }
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        vm = runnable.getVirtualMachine();
                        if (vm != null) {
                            this.createDebugTarget(config, launch, port, process, vm);
                            subMonitor.worked(1);
                            if (debugScript) {
                                subMonitor.subTask("Starting virtual machine...");
                                scriptvm = new ReportVMClient();
                                target = new ScriptDebugTarget(launch, scriptvm, null, process, this.delegate.helper.listenPort, this.delegate.getTempFolder(), monitor);
                                target.setFileName(this.delegate.getFileName());
                                subMonitor.worked(1);
                            }
                            subMonitor.done();
                            ReportLaunchHelper.handleProcessTermination(launch, process, this.delegate.getFileName(), this.delegate.getTempFolder());
                        }
                        return;
                    }
                }
                finally {
                    connector.stopListening(map);
                }
            }
            catch (IllegalConnectorArgumentsException | IOException e) {
                this.abort("Couldn't connect to VM", e, 120);
            }
            if (p != null) {
                p.destroy();
            }
        } else {
            subMonitor.subTask("Creating debug process...");
            workingDir = this.getWorkingDir(config);
            p = this.exec(cmdLine, workingDir, envp);
            if (p == null) {
                return;
            }
            if (monitor.isCanceled()) {
                p.destroy();
                return;
            }
            process = this.newProcess(launch, p, cmdLine[0], this.getDefaultProcessMap());
            process.setAttribute(IProcess.ATTR_CMDLINE, StandardScriptVMRunner.renderCommandLine(cmdLine));
            if (debugScript) {
                subMonitor.worked(1);
                subMonitor.subTask("Starting virtual machine...");
                vm = new ReportVMClient();
                target = new ScriptDebugTarget(launch, vm, null, process, this.delegate.helper.listenPort, this.delegate.getTempFolder(), monitor);
                target.setFileName(this.delegate.getFileName());
            }
            subMonitor.worked(1);
            subMonitor.done();
            ReportLaunchHelper.handleProcessTermination(launch, process, this.delegate.getFileName(), this.delegate.getTempFolder());
        }
    }

    private double getJavaVersion() {
        String version = null;
        if (this.fVMInstance instanceof IVMInstall2) {
            version = ((IVMInstall2)this.fVMInstance).getJavaVersion();
        } else {
            LibraryInfo libInfo = LaunchingPlugin.getLibraryInfo((String)this.fVMInstance.getInstallLocation().getAbsolutePath());
            if (libInfo == null) {
                return 0.0;
            }
            version = libInfo.getVersion();
        }
        int index = version.indexOf(".");
        int nextIndex = version.indexOf(".", index + 1);
        try {
            if (index > 0 && nextIndex > index) {
                return Double.parseDouble(version.substring(0, nextIndex));
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private ListeningConnector getConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    private void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    private void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    private IDebugTarget createDebugTarget(VMRunnerConfiguration config, ILaunch launch, int port, IProcess process, VirtualMachine vm) {
        String debugName = "Report Running at localhost:" + port;
        return JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)debugName, (IProcess)process, (boolean)true, (boolean)false, (boolean)config.isResumeOnStartup());
    }

    protected String[] prependJREPath(String[] env) {
        IVMInstall2 vm;
        String javaVersion;
        if ("macosx".equals(Platform.getOS()) && this.fVMInstance instanceof IVMInstall2 && (javaVersion = (vm = (IVMInstall2)this.fVMInstance).getJavaVersion()) != null) {
            if (env == null) {
                Map map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
                if (map.containsKey(JAVA_JVM_VERSION)) {
                    String[] env2 = new String[map.size()];
                    Iterator iterator = map.entrySet().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        env2[i] = JAVA_JVM_VERSION.equals(key) ? String.valueOf(key) + "=" + javaVersion : String.valueOf(key) + "=" + (String)entry.getValue();
                        ++i;
                    }
                    env = env2;
                }
            } else {
                int i = 0;
                while (i < env.length) {
                    String string = env[i];
                    if (string.startsWith(JAVA_JVM_VERSION)) {
                        env[i] = "JAVA_JVM_VERSION=" + javaVersion;
                        break;
                    }
                    ++i;
                }
            }
        }
        return env;
    }

    static class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        @Override
        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IllegalConnectorArgumentsException | IOException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

