/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import java.math.BigDecimal;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class BooleanCalculator
implements ICalculator {
    @Override
    public Number add(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return this.convertToNumber((Boolean)b);
        }
        if (b == null) {
            return this.convertToNumber((Boolean)a);
        }
        return this.convertToNumber((Boolean)a != false || (Boolean)b != false);
    }

    @Override
    public Number divide(Object dividend, Object divisor) throws DataException {
        if (dividend == null) {
            return null;
        }
        if (divisor == null) {
            return this.convertToNumber((Boolean)dividend);
        }
        if (divisor == Boolean.FALSE) {
            return null;
        }
        return this.convertToNumber((Boolean)dividend != false && (Boolean)divisor != false);
    }

    @Override
    public Number multiply(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return this.convertToNumber((Boolean)b);
        }
        if (b == null) {
            return this.convertToNumber((Boolean)a);
        }
        return this.convertToNumber((Boolean)a != false && (Boolean)b != false);
    }

    @Override
    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        try {
            return this.divide(dividend, divisor);
        }
        catch (ArithmeticException e) {
            return ifZero;
        }
    }

    @Override
    public Number subtract(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return this.convertToNumber((Boolean)b);
        }
        if (b == null) {
            return this.convertToNumber((Boolean)a);
        }
        return this.convertToNumber((Boolean)a ^ (Boolean)b);
    }

    @Override
    public Object getTypedObject(Object obj) throws DataException {
        try {
            return DataTypeUtil.toBoolean((Object)obj);
        }
        catch (BirtException e) {
            throw DataException.wrap((BirtException)e);
        }
    }

    private Number convertToNumber(Boolean a) {
        return a == Boolean.TRUE ? BigDecimal.ONE : BigDecimal.ZERO;
    }
}

