/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.IComponentContainer;
import org.eclipse.app4mc.amalthea.model.IInterfaceContainer;
import org.eclipse.app4mc.amalthea.model.edit.comp.container.CompDefinitionContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.comp.container.CompInterfaceContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.comp.container.CompStructureContainerIP;
import org.eclipse.app4mc.amalthea.model.provider.ComponentsModelItemProvider;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedComponentsModelIP
extends ComponentsModelItemProvider {
    private static final Set<EStructuralFeature> SPECIAL_FEATURES = Set.of(AmaltheaPackage.eINSTANCE.getIComponentContainer_Components(), AmaltheaPackage.eINSTANCE.getIInterfaceContainer_Interfaces(), AmaltheaPackage.eINSTANCE.getComponentsModel_Structures());
    private static final Set<Integer> SPECIAL_FEATURE_IDS = SPECIAL_FEATURES.stream().mapToInt(EStructuralFeature::getFeatureID).boxed().collect(Collectors.toCollection(HashSet::new));
    protected CompDefinitionContainerIP compDefinitionCIP;
    protected CompInterfaceContainerIP compInterfaceCIP;
    protected CompStructureContainerIP compStructureCIP;

    public ExtendedComponentsModelIP(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public CompDefinitionContainerIP getCompDefinitionContainerIP(ComponentsModel compModel) {
        if (this.compDefinitionCIP == null) {
            this.compDefinitionCIP = new CompDefinitionContainerIP(this.adapterFactory, (IComponentContainer)compModel);
        }
        return this.compDefinitionCIP;
    }

    public CompInterfaceContainerIP getCompInterfaceContainerIP(ComponentsModel compModel) {
        if (this.compInterfaceCIP == null) {
            this.compInterfaceCIP = new CompInterfaceContainerIP(this.adapterFactory, (IInterfaceContainer)compModel);
        }
        return this.compInterfaceCIP;
    }

    public CompStructureContainerIP getCompStructureContainerIP(ComponentsModel compModel) {
        if (this.compStructureCIP == null) {
            this.compStructureCIP = new CompStructureContainerIP(this.adapterFactory, compModel);
        }
        return this.compStructureCIP;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        for (EStructuralFeature feature : super.getChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, feature)) continue;
            return feature;
        }
        return null;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        HashSet result = new HashSet(super.getChildrenFeatures(object));
        result.removeAll(SPECIAL_FEATURES);
        return result;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<TransientItemProvider> children = new ArrayList<TransientItemProvider>(super.getChildren(object));
        ComponentsModel compModel = (ComponentsModel)object;
        if (!compModel.getStructures().isEmpty()) {
            children.add(0, this.getCompStructureContainerIP(compModel));
        }
        if (!compModel.getInterfaces().isEmpty()) {
            children.add(0, this.getCompInterfaceContainerIP(compModel));
        }
        if (!compModel.getComponents().isEmpty()) {
            children.add(0, this.getCompDefinitionContainerIP(compModel));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, EStructuralFeature feature) {
        final int featureID = feature.getFeatureID();
        if (!SPECIAL_FEATURE_IDS.contains(featureID)) {
            return command;
        }
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<TransientItemProvider> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    if (featureID == 1) {
                        affected = Collections.singleton(ExtendedComponentsModelIP.this.getCompDefinitionContainerIP((ComponentsModel)owner));
                    } else if (featureID == 2) {
                        affected = Collections.singleton(ExtendedComponentsModelIP.this.getCompInterfaceContainerIP((ComponentsModel)owner));
                    } else if (featureID == 3) {
                        affected = Collections.singleton(ExtendedComponentsModelIP.this.getCompStructureContainerIP((ComponentsModel)owner));
                    }
                }
                return affected;
            }
        };
    }

    public void dispose() {
        if (this.compDefinitionCIP != null) {
            this.compDefinitionCIP.dispose();
        }
        if (this.compInterfaceCIP != null) {
            this.compInterfaceCIP.dispose();
        }
        if (this.compStructureCIP != null) {
            this.compStructureCIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        int featureID = notification.getFeatureID(ComponentsModel.class);
        if (SPECIAL_FEATURE_IDS.contains(featureID)) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
        } else {
            super.notifyChanged(notification);
        }
    }
}

