/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.edit.hw.container.HwDefinitionContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.hw.container.HwDomainContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.hw.container.HwFeatureContainerIP;
import org.eclipse.app4mc.amalthea.model.provider.HWModelItemProvider;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedHWModelIP
extends HWModelItemProvider {
    private static final Set<EStructuralFeature> SPECIAL_FEATURES = new HashSet<EReference>(Arrays.asList(AmaltheaPackage.eINSTANCE.getHWModel_FeatureCategories(), AmaltheaPackage.eINSTANCE.getHWModel_Definitions(), AmaltheaPackage.eINSTANCE.getHWModel_Domains()));
    private static final Set<Integer> SPECIAL_FEATURE_IDS = SPECIAL_FEATURES.stream().mapToInt(EStructuralFeature::getFeatureID).boxed().collect(Collectors.toCollection(HashSet::new));
    protected HwFeatureContainerIP hwFeatureCIP;
    protected HwDefinitionContainerIP hwDefinitionCIP;
    protected HwDomainContainerIP hwDomainCIP;

    public ExtendedHWModelIP(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public HwFeatureContainerIP getHwFeaturesContainerIP(HWModel hwModel) {
        if (this.hwFeatureCIP == null) {
            this.hwFeatureCIP = new HwFeatureContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwFeatureCIP;
    }

    public HwDefinitionContainerIP getHwDefinitionsContainerIP(HWModel hwModel) {
        if (this.hwDefinitionCIP == null) {
            this.hwDefinitionCIP = new HwDefinitionContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwDefinitionCIP;
    }

    public HwDomainContainerIP getHwDomainsContainerIP(HWModel hwModel) {
        if (this.hwDomainCIP == null) {
            this.hwDomainCIP = new HwDomainContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwDomainCIP;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        for (EStructuralFeature feature : super.getChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, feature)) continue;
            return feature;
        }
        return null;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        HashSet result = new HashSet(super.getChildrenFeatures(object));
        result.removeAll(SPECIAL_FEATURES);
        return result;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<TransientItemProvider> children = new ArrayList<TransientItemProvider>(super.getChildren(object));
        HWModel hwModel = (HWModel)object;
        if (!hwModel.getFeatureCategories().isEmpty()) {
            children.add(0, this.getHwFeaturesContainerIP(hwModel));
        }
        if (!hwModel.getDomains().isEmpty()) {
            children.add(0, this.getHwDomainsContainerIP(hwModel));
        }
        if (!hwModel.getDefinitions().isEmpty()) {
            children.add(0, this.getHwDefinitionsContainerIP(hwModel));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, EStructuralFeature feature) {
        final int featureID = feature.getFeatureID();
        if (!SPECIAL_FEATURE_IDS.contains(featureID)) {
            return command;
        }
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<TransientItemProvider> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    if (featureID == 2) {
                        affected = Collections.singleton(ExtendedHWModelIP.this.getHwFeaturesContainerIP((HWModel)owner));
                    } else if (featureID == 1) {
                        affected = Collections.singleton(ExtendedHWModelIP.this.getHwDefinitionsContainerIP((HWModel)owner));
                    } else if (featureID == 4) {
                        affected = Collections.singleton(ExtendedHWModelIP.this.getHwDomainsContainerIP((HWModel)owner));
                    }
                }
                return affected;
            }
        };
    }

    public void dispose() {
        if (this.hwFeatureCIP != null) {
            this.hwFeatureCIP.dispose();
        }
        if (this.hwDefinitionCIP != null) {
            this.hwDefinitionCIP.dispose();
        }
        if (this.hwDomainCIP != null) {
            this.hwDomainCIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        int featureID = notification.getFeatureID(HWModel.class);
        if (SPECIAL_FEATURE_IDS.contains(featureID)) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
        } else {
            super.notifyChanged(notification);
        }
    }
}

