/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.software;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ModeCondition;
import org.eclipse.app4mc.amalthea.model.ModeConditionDisjunction;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.ModeValueCondition;
import org.eclipse.app4mc.amalthea.model.RelationalOperator;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Software-ModeConditionDisjunctionAlwaysTrue")
public class TASoftwareModeConditionDisjunctionAlwaysTrue
extends AmaltheaValidation {
    private static final String ALWAYS_EVALUATES_TO_TRUE = " always evaluates to TRUE, which might not be intended here.";

    public EClassifier getEClassifier() {
        return ePackage.getModeConditionDisjunction();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof ModeConditionDisjunction) {
            ModeConditionDisjunction mcd = (ModeConditionDisjunction)eObject;
            List oredEMCs = mcd.getEntries().stream().filter(ModeValueCondition.class::isInstance).map(ModeValueCondition.class::cast).filter(mc -> mc.eIsSet((EStructuralFeature)ePackage.getModeValue_Value()) && mc.eIsSet((EStructuralFeature)ePackage.getModeValue_Label()) && mc.getLabel().isEnum() && mc.getLiteral() != null).distinct().collect(Collectors.toList());
            oredEMCs.stream().collect(Collectors.groupingBy(ModeValue::getLabel)).forEach((ml, mcs) -> {
                HashSet allLiterals = new HashSet(((EnumMode)ml.getMode()).getLiterals());
                Set allEQLiterals = mcs.stream().filter(mc -> mc.getRelation() == RelationalOperator.EQUAL).map(ModeValue::getLiteral).collect(Collectors.toSet());
                INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)mcd, INamed.class);
                if (allLiterals.equals(allEQLiterals)) {
                    this.addIssue(results, (EObject)mcd, (EStructuralFeature)ePackage.getModeConditionDisjunction_Entries(), "Disjoining all possible mode literals in " + this.objectInfo((EObject)namedContainer) + ALWAYS_EVALUATES_TO_TRUE);
                }
                mcs.stream().collect(Collectors.groupingBy(ModeValue::getLiteral)).forEach((lit, litMCs) -> {
                    List usedRelations = litMCs.stream().map(ModeCondition::getRelation).distinct().collect(Collectors.toList());
                    if (usedRelations.contains(RelationalOperator.EQUAL) && usedRelations.contains(RelationalOperator.NOT_EQUAL)) {
                        this.addIssue(results, (EObject)mcd, (EStructuralFeature)ePackage.getModeConditionDisjunction_Entries(), "Disjoining mode conditions on the same " + this.objectInfo((EObject)lit) + " with relations " + usedRelations + " in " + this.objectInfo((EObject)namedContainer) + ALWAYS_EVALUATES_TO_TRUE);
                    }
                });
            });
        }
    }
}

