/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.core.IProfileConfiguration;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ProfileManager.class})
public class ProfileManager {
    private final HashMap<Class<? extends IProfile>, CachedProfile> profileMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void bindProfileConfiguration(IProfileConfiguration config) {
        HashMap<Class<? extends IProfile>, CachedProfile> hashMap = this.profileMap;
        synchronized (hashMap) {
            Class<?> profileClass = config.getClass();
            this.profileMap.put(profileClass, this.getCachedProfile(profileClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindProfileConfiguration(IProfileConfiguration config) {
        HashMap<Class<? extends IProfile>, CachedProfile> hashMap = this.profileMap;
        synchronized (hashMap) {
            this.profileMap.remove(config.getClass());
        }
    }

    public Map<Class<? extends IProfile>, CachedProfile> getRegisteredValidationProfiles() {
        return Collections.unmodifiableMap(this.profileMap);
    }

    protected void loadProfile(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            return;
        }
        this.profileMap.put(profileClass, new CachedProfile(profileClass));
    }

    public CachedProfile getCachedProfile(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            return null;
        }
        if (!this.profileMap.containsKey(profileClass)) {
            this.loadProfile(profileClass);
        }
        return this.profileMap.get(profileClass);
    }

    public void dumpProfile(Class<? extends IProfile> profileClass, PrintStream out) {
        if (out == null) {
            return;
        }
        CachedProfile profile = this.getCachedProfile(profileClass);
        this.dumpProfile(profile, 0, out);
    }

    private void dumpProfile(CachedProfile profile, int indentLevel, PrintStream stream) {
        if (profile == null) {
            return;
        }
        char[] charArray = new char[indentLevel * 4];
        Arrays.fill(charArray, ' ');
        String indent = new String(charArray);
        stream.println(String.valueOf(indent) + "PROFILE " + profile.getProfileClass().getSimpleName());
        stream.println(String.valueOf(indent) + " - name: " + profile.getName());
        if (!profile.getDescription().isEmpty()) {
            stream.println(String.valueOf(indent) + " - description: " + profile.getDescription());
        }
        if (!profile.getCachedValidations().isEmpty()) {
            stream.println(String.valueOf(indent) + " - validations:");
        }
        for (CachedValidator cachedValidator : profile.getCachedValidations().values()) {
            stream.println(String.valueOf(indent) + "    " + cachedValidator.getValidationID() + "(" + (Object)((Object)cachedValidator.getSeverity()) + " - " + cachedValidator.getTargetClass().getSimpleName() + ")");
            String[] stringArray = cachedValidator.getValidationChecks();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String check = stringArray[n2];
                stream.println(String.valueOf(indent) + "        * " + check);
                ++n2;
            }
        }
        if (!profile.getCachedProfiles().isEmpty()) {
            stream.println(String.valueOf(indent) + " - profiles:");
        }
        for (CachedProfile cachedProfile : profile.getCachedProfiles().values()) {
            this.dumpProfile(cachedProfile, 1, stream);
        }
    }
}

