/**
 ********************************************************************************
 * Copyright (c) 2013, 2020 Robert Bosch GmbH and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.sphinx.ui.editors;

import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedBasicTransactionalFormEditor;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.messages.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ResourceLocator;

public class ShowTypesAction extends Action {

	private final ExtendedBasicTransactionalFormEditor editor;

	public ShowTypesAction(final ExtendedBasicTransactionalFormEditor editor) {
		super(Messages.ShowTypesAction_title, AS_CHECK_BOX);
		this.editor = editor;
		setChecked(true);
		if(this.editor!=null) {
			this.editor.setShowTypesOfElements(isChecked());
		}
//		setChecked(editor.isShowTypesOfElements());
		setImageDescriptor(ResourceLocator.imageDescriptorFromBundle(SphinxSupportPlugin.getPluginId(),
				"/icons/full/obj16/showtypes.png").orElse(null)); //$NON-NLS-1$
		setToolTipText(Messages.ShowTypesAction_tooltip);
		
	}

	/**
	 * @see org.eclipse.jface.action.Action#run()
	 */
	@Override
	public void run() {
		this.editor.setShowTypesOfElements(isChecked());
		this.editor.getViewer().refresh();
	}

}
