/**
 * *******************************************************************************
 *  Copyright (c) 2015-2020 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * *
 * *******************************************************************************
 * Copyright (c) 2015-2020 Robert Bosch GmbH and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * *******************************************************************************
 * <!-- end-model-doc -->
 * @see org.eclipse.app4mc.amalthea.model.AmaltheaFactory
 * @model kind="package"
 * @generated
 */
public interface AmaltheaPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "model";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://app4mc.eclipse.org/amalthea/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "am";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AmaltheaPackage eINSTANCE = org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IAnnotatable <em>IAnnotatable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IAnnotatable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIAnnotatable()
	 * @generated
	 */
	int IANNOTATABLE = 5;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE__CUSTOM_PROPERTIES = 0;

	/**
	 * The number of structural features of the '<em>IAnnotatable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IAnnotatable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BaseObjectImpl <em>Base Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BaseObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBaseObject()
	 * @generated
	 */
	int BASE_OBJECT = 2;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT__CUSTOM_PROPERTIES = IANNOTATABLE__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT_FEATURE_COUNT = IANNOTATABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT_OPERATION_COUNT = IANNOTATABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AmaltheaImpl <em>Amalthea</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAmalthea()
	 * @generated
	 */
	int AMALTHEA = 0;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__VERSION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Common Elements</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__COMMON_ELEMENTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sw Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__SW_MODEL = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Hw Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__HW_MODEL = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Os Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__OS_MODEL = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stimuli Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__STIMULI_MODEL = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Event Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__EVENT_MODEL = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Constraints Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CONSTRAINTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Property Constraints Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__PROPERTY_CONSTRAINTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mapping Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__MAPPING_MODEL = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Components Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__COMPONENTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Config Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CONFIG_MODEL = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Amalthea</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Amalthea</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CommonElementsImpl <em>Common Elements</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CommonElementsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCommonElements()
	 * @generated
	 */
	int COMMON_ELEMENTS = 1;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__TAGS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Namespaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__NAMESPACES = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Core Classifiers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__CORE_CLASSIFIERS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Memory Classifiers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__MEMORY_CLASSIFIERS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Common Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Common Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.INamed <em>INamed</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.INamed
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getINamed()
	 * @generated
	 */
	int INAMED = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED__NAME = 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED__QUALIFIED_NAME = 1;

	/**
	 * The number of structural features of the '<em>INamed</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_NAMED_CONTAINER = 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_NAME_PREFIX = 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_QUALIFIED_NAME_SEGMENTS = 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_DEFAULT_NAME_SEPARATOR = 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_NAMESPACE = 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED___GET_NAME_PREFIX_SEGMENTS = 5;

	/**
	 * The number of operations of the '<em>INamed</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED_OPERATION_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IReferable <em>IReferable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IReferable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIReferable()
	 * @generated
	 */
	int IREFERABLE = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE__NAME = INAMED__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE__QUALIFIED_NAME = INAMED__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE__UNIQUE_NAME = INAMED_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IReferable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE_FEATURE_COUNT = INAMED_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_NAMED_CONTAINER = INAMED___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_NAME_PREFIX = INAMED___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_QUALIFIED_NAME_SEGMENTS = INAMED___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_DEFAULT_NAME_SEPARATOR = INAMED___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_NAMESPACE = INAMED___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_NAME_PREFIX_SEGMENTS = INAMED___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___GET_ENCODED_QUALIFIED_NAME = INAMED_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = INAMED_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>IReferable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE_OPERATION_COUNT = INAMED_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferableObjectImpl <em>Referable Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferableObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferableObject()
	 * @generated
	 */
	int REFERABLE_OBJECT = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT__QUALIFIED_NAME = IREFERABLE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Referable Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_NAMED_CONTAINER = IREFERABLE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_NAME_PREFIX = IREFERABLE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS = IREFERABLE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_DEFAULT_NAME_SEPARATOR = IREFERABLE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_NAMESPACE = IREFERABLE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_NAME_PREFIX_SEGMENTS = IREFERABLE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___GET_ENCODED_QUALIFIED_NAME = IREFERABLE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = IREFERABLE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Referable Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferableBaseObjectImpl <em>Referable Base Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferableBaseObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferableBaseObject()
	 * @generated
	 */
	int REFERABLE_BASE_OBJECT = 4;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES = IANNOTATABLE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__NAME = IANNOTATABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__QUALIFIED_NAME = IANNOTATABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__UNIQUE_NAME = IANNOTATABLE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Referable Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT_FEATURE_COUNT = IANNOTATABLE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER = IANNOTATABLE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_NAME_PREFIX = IANNOTATABLE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS = IANNOTATABLE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR = IANNOTATABLE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_NAMESPACE = IANNOTATABLE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS = IANNOTATABLE_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME = IANNOTATABLE_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = IANNOTATABLE_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Referable Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT_OPERATION_COUNT = IANNOTATABLE_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ITaggable <em>ITaggable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ITaggable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getITaggable()
	 * @generated
	 */
	int ITAGGABLE = 6;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE__TAGS = 0;

	/**
	 * The number of structural features of the '<em>ITaggable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>ITaggable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDisplayName <em>IDisplay Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDisplayName
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDisplayName()
	 * @generated
	 */
	int IDISPLAY_NAME = 9;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME__DISPLAY_NAME = 0;

	/**
	 * The number of structural features of the '<em>IDisplay Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IDisplay Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDescription <em>IDescription</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDescription
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDescription()
	 * @generated
	 */
	int IDESCRIPTION = 10;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION__DESCRIPTION = 0;

	/**
	 * The number of structural features of the '<em>IDescription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IDescription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.INamespaceMember <em>INamespace Member</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.INamespaceMember
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getINamespaceMember()
	 * @generated
	 */
	int INAMESPACE_MEMBER = 11;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMESPACE_MEMBER__NAMESPACE = 0;

	/**
	 * The number of structural features of the '<em>INamespace Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMESPACE_MEMBER_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>INamespace Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMESPACE_MEMBER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TagImpl <em>Tag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TagImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTag()
	 * @generated
	 */
	int TAG = 12;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tag Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__TAG_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Tagged Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__TAGGED_OBJECTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Tag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Tag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NamespaceImpl <em>Namespace</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NamespaceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNamespace()
	 * @generated
	 */
	int NAMESPACE = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__NAME = REFERABLE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__QUALIFIED_NAME = REFERABLE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__UNIQUE_NAME = REFERABLE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Next Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__NEXT_SEGMENTS = REFERABLE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Previous Segment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__PREVIOUS_SEGMENT = REFERABLE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Member Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__MEMBER_OBJECTS = REFERABLE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Namespace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_FEATURE_COUNT = REFERABLE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_NAMED_CONTAINER = REFERABLE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_NAME_PREFIX = REFERABLE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_NAMESPACE = REFERABLE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Namespace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_OPERATION_COUNT = REFERABLE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClassifierImpl <em>Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClassifier()
	 * @generated
	 */
	int CLASSIFIER = 14;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreClassifierImpl <em>Core Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreClassifier()
	 * @generated
	 */
	int CORE_CLASSIFIER = 15;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__CUSTOM_PROPERTIES = CLASSIFIER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__NAME = CLASSIFIER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__QUALIFIED_NAME = CLASSIFIER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__UNIQUE_NAME = CLASSIFIER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__DESCRIPTION = CLASSIFIER__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Core Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER_FEATURE_COUNT = CLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_NAMED_CONTAINER = CLASSIFIER___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_NAME_PREFIX = CLASSIFIER___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_QUALIFIED_NAME_SEGMENTS = CLASSIFIER___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_DEFAULT_NAME_SEPARATOR = CLASSIFIER___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_NAMESPACE = CLASSIFIER___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_NAME_PREFIX_SEGMENTS = CLASSIFIER___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___GET_ENCODED_QUALIFIED_NAME = CLASSIFIER___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CLASSIFIER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Core Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER_OPERATION_COUNT = CLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryClassifierImpl <em>Memory Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryClassifier()
	 * @generated
	 */
	int MEMORY_CLASSIFIER = 16;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__CUSTOM_PROPERTIES = CLASSIFIER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__NAME = CLASSIFIER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__QUALIFIED_NAME = CLASSIFIER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__UNIQUE_NAME = CLASSIFIER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__DESCRIPTION = CLASSIFIER__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Memory Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER_FEATURE_COUNT = CLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_NAMED_CONTAINER = CLASSIFIER___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_NAME_PREFIX = CLASSIFIER___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_QUALIFIED_NAME_SEGMENTS = CLASSIFIER___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_DEFAULT_NAME_SEPARATOR = CLASSIFIER___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_NAMESPACE = CLASSIFIER___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_NAME_PREFIX_SEGMENTS = CLASSIFIER___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___GET_ENCODED_QUALIFIED_NAME = CLASSIFIER___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CLASSIFIER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Memory Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER_OPERATION_COUNT = CLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TransmissionPolicyImpl <em>Transmission Policy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TransmissionPolicyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTransmissionPolicy()
	 * @generated
	 */
	int TRANSMISSION_POLICY = 17;

	/**
	 * The feature id for the '<em><b>Chunk Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__CHUNK_SIZE = 0;

	/**
	 * The feature id for the '<em><b>Chunk Processing Ticks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__CHUNK_PROCESSING_TICKS = 1;

	/**
	 * The feature id for the '<em><b>Transmit Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__TRANSMIT_RATIO = 2;

	/**
	 * The number of structural features of the '<em>Transmission Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Transmission Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.QuantityImpl <em>Quantity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.QuantityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getQuantity()
	 * @generated
	 */
	int QUANTITY = 18;

	/**
	 * The number of structural features of the '<em>Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link java.lang.Comparable <em>Time Comparable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Comparable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeComparable()
	 * @generated
	 */
	int TIME_COMPARABLE = 19;

	/**
	 * The number of structural features of the '<em>Time Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_COMPARABLE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Time Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_COMPARABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeImpl <em>Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTime()
	 * @generated
	 */
	int TIME = 20;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Compare To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___COMPARE_TO__TIME = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Adjust Unit</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___ADJUST_UNIT = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___ADD__TIME = QUANTITY_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Subtract</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___SUBTRACT__TIME = QUANTITY_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___MULTIPLY__LONG = QUANTITY_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___MULTIPLY__DOUBLE = QUANTITY_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Divide</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___DIVIDE__TIME = QUANTITY_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyImpl <em>Frequency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequency()
	 * @generated
	 */
	int FREQUENCY = 21;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Frequency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VoltageImpl <em>Voltage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VoltageImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVoltage()
	 * @generated
	 */
	int VOLTAGE = 22;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Voltage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Voltage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataSizeImpl <em>Data Size</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataSizeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataSize()
	 * @generated
	 */
	int DATA_SIZE = 23;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Size</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Number Bits</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___GET_NUMBER_BITS = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Number Bytes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___GET_NUMBER_BYTES = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Size</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link java.lang.Comparable <em>Data Rate Comparable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Comparable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataRateComparable()
	 * @generated
	 */
	int DATA_RATE_COMPARABLE = 24;

	/**
	 * The number of structural features of the '<em>Data Rate Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_COMPARABLE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Rate Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_COMPARABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataRateImpl <em>Data Rate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataRateImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataRate()
	 * @generated
	 */
	int DATA_RATE = 25;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Rate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Compare To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE___COMPARE_TO__DATARATE = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Data Rate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl <em>Custom Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomProperty()
	 * @generated
	 */
	int CUSTOM_PROPERTY = 26;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Custom Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Custom Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ValueImpl <em>Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ValueImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getValue()
	 * @generated
	 */
	int VALUE = 27;

	/**
	 * The number of structural features of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ListObjectImpl <em>List Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ListObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getListObject()
	 * @generated
	 */
	int LIST_OBJECT = 28;

	/**
	 * The feature id for the '<em><b>Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT__VALUES = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>List Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StringObjectImpl <em>String Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StringObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStringObject()
	 * @generated
	 */
	int STRING_OBJECT = 29;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>String Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BigIntegerObjectImpl <em>Big Integer Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BigIntegerObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBigIntegerObject()
	 * @generated
	 */
	int BIG_INTEGER_OBJECT = 30;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Big Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Big Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferenceObjectImpl <em>Reference Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferenceObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferenceObject()
	 * @generated
	 */
	int REFERENCE_OBJECT = 31;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reference Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Reference Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.IntegerObjectImpl <em>Integer Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.IntegerObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIntegerObject()
	 * @generated
	 */
	int INTEGER_OBJECT = 32;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LongObjectImpl <em>Long Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LongObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLongObject()
	 * @generated
	 */
	int LONG_OBJECT = 33;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Long Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Long Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FloatObjectImpl <em>Float Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FloatObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFloatObject()
	 * @generated
	 */
	int FLOAT_OBJECT = 34;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Float Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Float Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DoubleObjectImpl <em>Double Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DoubleObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDoubleObject()
	 * @generated
	 */
	int DOUBLE_OBJECT = 35;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Double Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Double Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BooleanObjectImpl <em>Boolean Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BooleanObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBooleanObject()
	 * @generated
	 */
	int BOOLEAN_OBJECT = 36;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Boolean Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Boolean Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.NumericStatistic <em>Numeric Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.NumericStatistic
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNumericStatistic()
	 * @generated
	 */
	int NUMERIC_STATISTIC = 37;

	/**
	 * The number of structural features of the '<em>Numeric Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_STATISTIC_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Numeric Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_STATISTIC_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MinAvgMaxStatisticImpl <em>Min Avg Max Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MinAvgMaxStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMinAvgMaxStatistic()
	 * @generated
	 */
	int MIN_AVG_MAX_STATISTIC = 38;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__MIN = NUMERIC_STATISTIC_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Avg</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__AVG = NUMERIC_STATISTIC_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__MAX = NUMERIC_STATISTIC_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Min Avg Max Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC_FEATURE_COUNT = NUMERIC_STATISTIC_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = NUMERIC_STATISTIC_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Min Avg Max Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC_OPERATION_COUNT = NUMERIC_STATISTIC_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SingleValueStatisticImpl <em>Single Value Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SingleValueStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSingleValueStatistic()
	 * @generated
	 */
	int SINGLE_VALUE_STATISTIC = 39;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC__VALUE = NUMERIC_STATISTIC_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Value Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC_FEATURE_COUNT = NUMERIC_STATISTIC_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Single Value Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC_OPERATION_COUNT = NUMERIC_STATISTIC_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation <em>ITime Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getITimeDeviation()
	 * @generated
	 */
	int ITIME_DEVIATION = 40;

	/**
	 * The number of structural features of the '<em>ITime Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>ITime Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeIntervalImpl <em>Time Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeInterval()
	 * @generated
	 */
	int TIME_INTERVAL = 41;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Time Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = 1;

	/**
	 * The number of operations of the '<em>Time Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeConstantImpl <em>Time Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeConstant()
	 * @generated
	 */
	int TIME_CONSTANT = 42;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT__VALUE = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_LOWER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_UPPER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_AVERAGE = ITIME_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeHistogramImpl <em>Time Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeHistogram()
	 * @generated
	 */
	int TIME_HISTOGRAM = 43;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM__ENTRIES = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_LOWER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_UPPER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_AVERAGE = ITIME_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeHistogramEntryImpl <em>Time Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeHistogramEntry()
	 * @generated
	 */
	int TIME_HISTOGRAM_ENTRY = 44;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__LOWER_BOUND = TIME_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__UPPER_BOUND = TIME_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__OCCURRENCES = TIME_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY_FEATURE_COUNT = TIME_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY___GET_AVERAGE = TIME_INTERVAL___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIME_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Time Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY_OPERATION_COUNT = TIME_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedTimeDistributionImpl <em>Bounded Time Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedTimeDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedTimeDistribution()
	 * @generated
	 */
	int BOUNDED_TIME_DISTRIBUTION = 45;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND = TIME_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND = TIME_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT = TIME_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIME_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND = TIME_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND = TIME_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE = TIME_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT = TIME_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedTimeDistributionImpl <em>Truncated Time Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedTimeDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedTimeDistribution()
	 * @generated
	 */
	int TRUNCATED_TIME_DISTRIBUTION = 46;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION__LOWER_BOUND = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION__UPPER_BOUND = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_LOWER_BOUND = ITIME_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_UPPER_BOUND = ITIME_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_AVERAGE = ITIME_DEVIATION___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Truncated Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeBoundariesImpl <em>Time Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeBoundaries()
	 * @generated
	 */
	int TIME_BOUNDARIES = 47;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__SAMPLING_TYPE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeStatisticsImpl <em>Time Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeStatistics()
	 * @generated
	 */
	int TIME_STATISTICS = 48;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__AVERAGE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeUniformDistributionImpl <em>Time Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeUniformDistribution()
	 * @generated
	 */
	int TIME_UNIFORM_DISTRIBUTION = 49;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Time Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeGaussDistributionImpl <em>Time Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeGaussDistribution()
	 * @generated
	 */
	int TIME_GAUSS_DISTRIBUTION = 50;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__SD = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRUNCATED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeWeibullEstimatorsDistributionImpl <em>Time Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeWeibullEstimatorsDistribution()
	 * @generated
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION = 51;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeBetaDistributionImpl <em>Time Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeBetaDistribution()
	 * @generated
	 */
	int TIME_BETA_DISTRIBUTION = 52;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__ALPHA = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__BETA = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_TIME_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation <em>IDiscrete Value Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDiscreteValueDeviation()
	 * @generated
	 */
	int IDISCRETE_VALUE_DEVIATION = 53;

	/**
	 * The number of structural features of the '<em>IDiscrete Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>IDiscrete Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueIntervalImpl <em>Discrete Value Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueInterval()
	 * @generated
	 */
	int DISCRETE_VALUE_INTERVAL = 54;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = 1;

	/**
	 * The number of operations of the '<em>Discrete Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueConstantImpl <em>Discrete Value Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueConstant()
	 * @generated
	 */
	int DISCRETE_VALUE_CONSTANT = 55;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT__VALUE = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Discrete Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramImpl <em>Discrete Value Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueHistogram()
	 * @generated
	 */
	int DISCRETE_VALUE_HISTOGRAM = 56;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM__ENTRIES = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Discrete Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramEntryImpl <em>Discrete Value Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueHistogramEntry()
	 * @generated
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY = 57;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__LOWER_BOUND = DISCRETE_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__UPPER_BOUND = DISCRETE_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__OCCURRENCES = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY_FEATURE_COUNT = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY___GET_AVERAGE = DISCRETE_VALUE_INTERVAL___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = DISCRETE_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Discrete Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY_OPERATION_COUNT = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedDiscreteValueDistributionImpl <em>Bounded Discrete Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedDiscreteValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedDiscreteValueDistribution()
	 * @generated
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION = 58;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND = DISCRETE_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND = DISCRETE_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = DISCRETE_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedDiscreteValueDistributionImpl <em>Truncated Discrete Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedDiscreteValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedDiscreteValueDistribution()
	 * @generated
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION = 59;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Truncated Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBoundariesImpl <em>Discrete Value Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueBoundaries()
	 * @generated
	 */
	int DISCRETE_VALUE_BOUNDARIES = 60;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__SAMPLING_TYPE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueStatisticsImpl <em>Discrete Value Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueStatistics()
	 * @generated
	 */
	int DISCRETE_VALUE_STATISTICS = 61;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueUniformDistributionImpl <em>Discrete Value Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueUniformDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION = 62;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Discrete Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueGaussDistributionImpl <em>Discrete Value Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueGaussDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION = 63;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__SD = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Discrete Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueWeibullEstimatorsDistributionImpl <em>Discrete Value Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION = 64;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBetaDistributionImpl <em>Discrete Value Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueBetaDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION = 65;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__ALPHA = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__BETA = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Discrete Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation <em>IContinuous Value Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIContinuousValueDeviation()
	 * @generated
	 */
	int ICONTINUOUS_VALUE_DEVIATION = 66;

	/**
	 * The number of structural features of the '<em>IContinuous Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>IContinuous Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueIntervalImpl <em>Continuous Value Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueInterval()
	 * @generated
	 */
	int CONTINUOUS_VALUE_INTERVAL = 67;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = 1;

	/**
	 * The number of operations of the '<em>Continuous Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueConstantImpl <em>Continuous Value Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueConstant()
	 * @generated
	 */
	int CONTINUOUS_VALUE_CONSTANT = 68;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT__VALUE = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Continuous Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramImpl <em>Continuous Value Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueHistogram()
	 * @generated
	 */
	int CONTINUOUS_VALUE_HISTOGRAM = 69;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM__ENTRIES = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Continuous Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramEntryImpl <em>Continuous Value Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueHistogramEntry()
	 * @generated
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY = 70;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__OCCURRENCES = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY_FEATURE_COUNT = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY___GET_AVERAGE = CONTINUOUS_VALUE_INTERVAL___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CONTINUOUS_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Continuous Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY_OPERATION_COUNT = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedContinuousValueDistributionImpl <em>Bounded Continuous Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedContinuousValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedContinuousValueDistribution()
	 * @generated
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION = 71;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CONTINUOUS_VALUE_INTERVAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedContinuousValueDistributionImpl <em>Truncated Continuous Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedContinuousValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedContinuousValueDistribution()
	 * @generated
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION = 72;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION___GET_AVERAGE;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Truncated Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBoundariesImpl <em>Continuous Value Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueBoundaries()
	 * @generated
	 */
	int CONTINUOUS_VALUE_BOUNDARIES = 73;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__SAMPLING_TYPE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueStatisticsImpl <em>Continuous Value Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueStatistics()
	 * @generated
	 */
	int CONTINUOUS_VALUE_STATISTICS = 74;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueUniformDistributionImpl <em>Continuous Value Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueUniformDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION = 75;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Continuous Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueGaussDistributionImpl <em>Continuous Value Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueGaussDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION = 76;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__SD = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Continuous Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueWeibullEstimatorsDistributionImpl <em>Continuous Value Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION = 77;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBetaDistributionImpl <em>Continuous Value Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueBetaDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION = 78;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__ALPHA = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__BETA = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Continuous Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeImpl <em>Mode</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMode()
	 * @generated
	 */
	int MODE = 79;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NumericModeImpl <em>Numeric Mode</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NumericModeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNumericMode()
	 * @generated
	 */
	int NUMERIC_MODE = 80;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE__CUSTOM_PROPERTIES = MODE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE__NAME = MODE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE__QUALIFIED_NAME = MODE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE__UNIQUE_NAME = MODE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Numeric Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE_FEATURE_COUNT = MODE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_NAMED_CONTAINER = MODE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_NAME_PREFIX = MODE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_QUALIFIED_NAME_SEGMENTS = MODE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_DEFAULT_NAME_SEPARATOR = MODE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_NAMESPACE = MODE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_NAME_PREFIX_SEGMENTS = MODE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___GET_ENCODED_QUALIFIED_NAME = MODE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = MODE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Numeric Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_MODE_OPERATION_COUNT = MODE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EnumModeImpl <em>Enum Mode</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EnumModeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEnumMode()
	 * @generated
	 */
	int ENUM_MODE = 81;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE__CUSTOM_PROPERTIES = MODE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE__NAME = MODE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE__QUALIFIED_NAME = MODE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE__UNIQUE_NAME = MODE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Literals</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE__LITERALS = MODE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enum Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE_FEATURE_COUNT = MODE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_NAMED_CONTAINER = MODE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_NAME_PREFIX = MODE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_QUALIFIED_NAME_SEGMENTS = MODE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_DEFAULT_NAME_SEPARATOR = MODE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_NAMESPACE = MODE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_NAME_PREFIX_SEGMENTS = MODE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_ENCODED_QUALIFIED_NAME = MODE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = MODE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE___GET_LITERAL__STRING = MODE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Enum Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_MODE_OPERATION_COUNT = MODE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLiteralImpl <em>Mode Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLiteralImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLiteral()
	 * @generated
	 */
	int MODE_LITERAL = 82;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Mode</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__CONTAINING_MODE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentsModelImpl <em>Components Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentsModel()
	 * @generated
	 */
	int COMPONENTS_MODEL = 83;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__COMPONENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__INTERFACES = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__STRUCTURES = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Systems</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__SYSTEMS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Components Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Components Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IComponentContainer <em>IComponent Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IComponentContainer
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIComponentContainer()
	 * @generated
	 */
	int ICOMPONENT_CONTAINER = 84;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_CONTAINER__COMPONENTS = 0;

	/**
	 * The number of structural features of the '<em>IComponent Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_CONTAINER_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IComponent Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_CONTAINER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IInterfaceContainer <em>IInterface Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IInterfaceContainer
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIInterfaceContainer()
	 * @generated
	 */
	int IINTERFACE_CONTAINER = 85;

	/**
	 * The feature id for the '<em><b>Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_CONTAINER__INTERFACES = 0;

	/**
	 * The number of structural features of the '<em>IInterface Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_CONTAINER_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IInterface Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_CONTAINER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ISystem <em>ISystem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ISystem
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISystem()
	 * @generated
	 */
	int ISYSTEM = 86;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__COMPONENT_INSTANCES = 0;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__CONNECTORS = 1;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__GROUNDED_PORTS = 2;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__INNER_PORTS = 3;

	/**
	 * The number of structural features of the '<em>ISystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>ISystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentInterfaceImpl <em>Component Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentInterfaceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentInterface()
	 * @generated
	 */
	int COMPONENT_INTERFACE = 87;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__DATATYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sub Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE__SUB_INTERFACES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Component Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Component Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INTERFACE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MainInterfaceImpl <em>Main Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MainInterfaceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMainInterface()
	 * @generated
	 */
	int MAIN_INTERFACE = 88;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__CUSTOM_PROPERTIES = COMPONENT_INTERFACE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__NAME = COMPONENT_INTERFACE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__QUALIFIED_NAME = COMPONENT_INTERFACE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__UNIQUE_NAME = COMPONENT_INTERFACE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__TAGS = COMPONENT_INTERFACE__TAGS;

	/**
	 * The feature id for the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__DATATYPE = COMPONENT_INTERFACE__DATATYPE;

	/**
	 * The feature id for the '<em><b>Sub Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__SUB_INTERFACES = COMPONENT_INTERFACE__SUB_INTERFACES;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__NAMESPACE = COMPONENT_INTERFACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Structure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__STRUCTURE = COMPONENT_INTERFACE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE__VERSION = COMPONENT_INTERFACE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Main Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE_FEATURE_COUNT = COMPONENT_INTERFACE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_NAMED_CONTAINER = COMPONENT_INTERFACE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_NAME_PREFIX = COMPONENT_INTERFACE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_QUALIFIED_NAME_SEGMENTS = COMPONENT_INTERFACE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_DEFAULT_NAME_SEPARATOR = COMPONENT_INTERFACE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_NAMESPACE = COMPONENT_INTERFACE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_NAME_PREFIX_SEGMENTS = COMPONENT_INTERFACE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___GET_ENCODED_QUALIFIED_NAME = COMPONENT_INTERFACE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = COMPONENT_INTERFACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Main Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAIN_INTERFACE_OPERATION_COUNT = COMPONENT_INTERFACE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SubInterfaceImpl <em>Sub Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SubInterfaceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSubInterface()
	 * @generated
	 */
	int SUB_INTERFACE = 89;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__CUSTOM_PROPERTIES = COMPONENT_INTERFACE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__NAME = COMPONENT_INTERFACE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__QUALIFIED_NAME = COMPONENT_INTERFACE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__UNIQUE_NAME = COMPONENT_INTERFACE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__TAGS = COMPONENT_INTERFACE__TAGS;

	/**
	 * The feature id for the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__DATATYPE = COMPONENT_INTERFACE__DATATYPE;

	/**
	 * The feature id for the '<em><b>Sub Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__SUB_INTERFACES = COMPONENT_INTERFACE__SUB_INTERFACES;

	/**
	 * The feature id for the '<em><b>Containing Interface</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE__CONTAINING_INTERFACE = COMPONENT_INTERFACE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sub Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE_FEATURE_COUNT = COMPONENT_INTERFACE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_NAMED_CONTAINER = COMPONENT_INTERFACE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_NAME_PREFIX = COMPONENT_INTERFACE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_QUALIFIED_NAME_SEGMENTS = COMPONENT_INTERFACE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_DEFAULT_NAME_SEPARATOR = COMPONENT_INTERFACE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_NAMESPACE = COMPONENT_INTERFACE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_ENCODED_QUALIFIED_NAME = COMPONENT_INTERFACE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = COMPONENT_INTERFACE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE___GET_NAME_PREFIX_SEGMENTS = COMPONENT_INTERFACE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sub Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_INTERFACE_OPERATION_COUNT = COMPONENT_INTERFACE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentPortImpl <em>Component Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentPortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentPort()
	 * @generated
	 */
	int COMPONENT_PORT = 90;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing Component</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__CONTAINING_COMPONENT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__KIND = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT__INTERFACE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Component Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Component Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_PORT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentStructureImpl <em>Component Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentStructureImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentStructure()
	 * @generated
	 */
	int COMPONENT_STRUCTURE = 91;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__NAME = REFERABLE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__QUALIFIED_NAME = REFERABLE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__UNIQUE_NAME = REFERABLE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Structure Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__STRUCTURE_TYPE = REFERABLE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sub Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__SUB_STRUCTURES = REFERABLE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Member Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE__MEMBER_OBJECTS = REFERABLE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Component Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE_FEATURE_COUNT = REFERABLE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_NAMED_CONTAINER = REFERABLE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_NAME_PREFIX = REFERABLE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_NAMESPACE = REFERABLE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Containing Structure</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_CONTAINING_STRUCTURE = REFERABLE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Component Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_STRUCTURE_OPERATION_COUNT = REFERABLE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IComponentStructureMember <em>IComponent Structure Member</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IComponentStructureMember
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIComponentStructureMember()
	 * @generated
	 */
	int ICOMPONENT_STRUCTURE_MEMBER = 92;

	/**
	 * The feature id for the '<em><b>Structure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_STRUCTURE_MEMBER__STRUCTURE = 0;

	/**
	 * The number of structural features of the '<em>IComponent Structure Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_STRUCTURE_MEMBER_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IComponent Structure Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_STRUCTURE_MEMBER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl <em>Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponent()
	 * @generated
	 */
	int COMPONENT = 93;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__NAMESPACE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Structure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__STRUCTURE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__PROCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__RUNNABLES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__SEMAPHORES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Os Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__OS_EVENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CompositeImpl <em>Composite</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CompositeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComposite()
	 * @generated
	 */
	int COMPOSITE = 94;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__CUSTOM_PROPERTIES = COMPONENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__QUALIFIED_NAME = COMPONENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__UNIQUE_NAME = COMPONENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__TAGS = COMPONENT__TAGS;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__NAMESPACE = COMPONENT__NAMESPACE;

	/**
	 * The feature id for the '<em><b>Structure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__STRUCTURE = COMPONENT__STRUCTURE;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__PORTS = COMPONENT__PORTS;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__PROCESSES = COMPONENT__PROCESSES;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__RUNNABLES = COMPONENT__RUNNABLES;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__LABELS = COMPONENT__LABELS;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__SEMAPHORES = COMPONENT__SEMAPHORES;

	/**
	 * The feature id for the '<em><b>Os Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__OS_EVENTS = COMPONENT__OS_EVENTS;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__COMPONENT_INSTANCES = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__CONNECTORS = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__GROUNDED_PORTS = COMPONENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__INNER_PORTS = COMPONENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Composite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_NAMED_CONTAINER = COMPONENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_NAME_PREFIX = COMPONENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_QUALIFIED_NAME_SEGMENTS = COMPONENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_DEFAULT_NAME_SEPARATOR = COMPONENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_NAMESPACE = COMPONENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_NAME_PREFIX_SEGMENTS = COMPONENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___GET_ENCODED_QUALIFIED_NAME = COMPONENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = COMPONENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Composite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SystemImpl <em>System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSystem()
	 * @generated
	 */
	int SYSTEM = 95;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__COMPONENT_INSTANCES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__CONNECTORS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__GROUNDED_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__INNER_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentInstanceImpl <em>Component Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentInstanceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentInstance()
	 * @generated
	 */
	int COMPONENT_INSTANCE = 96;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing System</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__CONTAINING_SYSTEM = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectorImpl <em>Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectorImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnector()
	 * @generated
	 */
	int CONNECTOR = 97;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__TAGS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Containing System</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__CONTAINING_SYSTEM = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Source Port</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__SOURCE_PORT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Target Port</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__TARGET_PORT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Implemented Interfaces</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__IMPLEMENTED_INTERFACES = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterfaceChannelImpl <em>Interface Channel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterfaceChannelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterfaceChannel()
	 * @generated
	 */
	int INTERFACE_CHANNEL = 98;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_CHANNEL__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_CHANNEL__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Interface Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_CHANNEL_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Interface Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_CHANNEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.QualifiedPortImpl <em>Qualified Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.QualifiedPortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getQualifiedPort()
	 * @generated
	 */
	int QUALIFIED_PORT = 99;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__INSTANCE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__PORT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Qualified Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Qualified Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConfigModelImpl <em>Config Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConfigModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConfigModel()
	 * @generated
	 */
	int CONFIG_MODEL = 100;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events To Trace</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL__EVENTS_TO_TRACE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Config Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Config Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventConfigImpl <em>Event Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventConfigImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventConfig()
	 * @generated
	 */
	int EVENT_CONFIG = 101;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__EVENT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Event Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Event Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstraintsModelImpl <em>Constraints Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstraintsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstraintsModel()
	 * @generated
	 */
	int CONSTRAINTS_MODEL = 102;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__EVENT_CHAINS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Timing Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__TIMING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Affinity Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__AFFINITY_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Runnable Sequencing Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__RUNNABLE_SEQUENCING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Data Age Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_AGE_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Requirements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__REQUIREMENTS = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Coherency Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_COHERENCY_GROUPS = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Data Stability Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_STABILITY_GROUPS = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Physical Section Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__PHYSICAL_SECTION_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableSequencingConstraintImpl <em>Runnable Sequencing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableSequencingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableSequencingConstraint()
	 * @generated
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT = 103;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__ORDER_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__RUNNABLE_GROUPS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Process Scope</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__PROCESS_SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Runnable Sequencing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Runnable Sequencing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AffinityConstraintImpl <em>Affinity Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AffinityConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAffinityConstraint()
	 * @generated
	 */
	int AFFINITY_CONSTRAINT = 104;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Affinity Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Affinity Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SeparationConstraintImpl <em>Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSeparationConstraint()
	 * @generated
	 */
	int SEPARATION_CONSTRAINT = 105;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__NAME = AFFINITY_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__QUALIFIED_NAME = AFFINITY_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__UNIQUE_NAME = AFFINITY_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT_FEATURE_COUNT = AFFINITY_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER = AFFINITY_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_NAME_PREFIX = AFFINITY_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = AFFINITY_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = AFFINITY_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_NAMESPACE = AFFINITY_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = AFFINITY_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = AFFINITY_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = AFFINITY_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT_OPERATION_COUNT = AFFINITY_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PairingConstraintImpl <em>Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPairingConstraint()
	 * @generated
	 */
	int PAIRING_CONSTRAINT = 106;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__NAME = AFFINITY_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__QUALIFIED_NAME = AFFINITY_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__UNIQUE_NAME = AFFINITY_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT_FEATURE_COUNT = AFFINITY_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_NAMED_CONTAINER = AFFINITY_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_NAME_PREFIX = AFFINITY_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = AFFINITY_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = AFFINITY_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_NAMESPACE = AFFINITY_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = AFFINITY_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = AFFINITY_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = AFFINITY_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT_OPERATION_COUNT = AFFINITY_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintImpl <em>Process Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessConstraint()
	 * @generated
	 */
	int PROCESS_CONSTRAINT = 107;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Process Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Process Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintImpl <em>Runnable Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableConstraint()
	 * @generated
	 */
	int RUNNABLE_CONSTRAINT = 108;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Runnable Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Runnable Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataConstraintImpl <em>Data Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataConstraint()
	 * @generated
	 */
	int DATA_CONSTRAINT = 109;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Data Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Data Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableSeparationConstraintImpl <em>Runnable Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableSeparationConstraint()
	 * @generated
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT = 110;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__QUALIFIED_NAME = SEPARATION_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER = SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_NAME_PREFIX = SEPARATION_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_NAMESPACE = SEPARATION_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Runnable Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessSeparationConstraintImpl <em>Process Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessSeparationConstraint()
	 * @generated
	 */
	int PROCESS_SEPARATION_CONSTRAINT = 111;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__QUALIFIED_NAME = SEPARATION_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER = SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_NAME_PREFIX = SEPARATION_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_NAMESPACE = SEPARATION_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataSeparationConstraintImpl <em>Data Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataSeparationConstraint()
	 * @generated
	 */
	int DATA_SEPARATION_CONSTRAINT = 112;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__QUALIFIED_NAME = SEPARATION_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER = SEPARATION_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_NAME_PREFIX = SEPARATION_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = SEPARATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = SEPARATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_NAMESPACE = SEPARATION_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = SEPARATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = SEPARATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SEPARATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Data Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnablePairingConstraintImpl <em>Runnable Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnablePairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnablePairingConstraint()
	 * @generated
	 */
	int RUNNABLE_PAIRING_CONSTRAINT = 113;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__QUALIFIED_NAME = PAIRING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_NAMED_CONTAINER = PAIRING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_NAME_PREFIX = PAIRING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_NAMESPACE = PAIRING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Runnable Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPairingConstraintImpl <em>Process Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPairingConstraint()
	 * @generated
	 */
	int PROCESS_PAIRING_CONSTRAINT = 114;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__QUALIFIED_NAME = PAIRING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_NAMED_CONTAINER = PAIRING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_NAME_PREFIX = PAIRING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_NAMESPACE = PAIRING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataPairingConstraintImpl <em>Data Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataPairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataPairingConstraint()
	 * @generated
	 */
	int DATA_PAIRING_CONSTRAINT = 115;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__QUALIFIED_NAME = PAIRING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_NAMED_CONTAINER = PAIRING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_NAME_PREFIX = PAIRING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = PAIRING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = PAIRING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_NAMESPACE = PAIRING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = PAIRING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = PAIRING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = PAIRING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Data Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintTargetImpl <em>Runnable Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableConstraintTarget()
	 * @generated
	 */
	int RUNNABLE_CONSTRAINT_TARGET = 116;

	/**
	 * The number of structural features of the '<em>Runnable Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Runnable Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintTargetImpl <em>Process Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessConstraintTarget()
	 * @generated
	 */
	int PROCESS_CONSTRAINT_TARGET = 117;

	/**
	 * The number of structural features of the '<em>Process Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Process Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataConstraintTargetImpl <em>Data Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataConstraintTarget()
	 * @generated
	 */
	int DATA_CONSTRAINT_TARGET = 118;

	/**
	 * The number of structural features of the '<em>Data Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetMemoryImpl <em>Target Memory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetMemoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetMemory()
	 * @generated
	 */
	int TARGET_MEMORY = 119;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY__CUSTOM_PROPERTIES = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memories</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY__MEMORIES = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY_FEATURE_COUNT = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY_OPERATION_COUNT = DATA_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetCoreImpl <em>Target Core</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetCoreImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetCore()
	 * @generated
	 */
	int TARGET_CORE = 120;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE__CUSTOM_PROPERTIES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE__CORES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE_FEATURE_COUNT = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE_OPERATION_COUNT = RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetSchedulerImpl <em>Target Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetSchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetScheduler()
	 * @generated
	 */
	int TARGET_SCHEDULER = 121;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER__CUSTOM_PROPERTIES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Schedulers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER__SCHEDULERS = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER_FEATURE_COUNT = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER_OPERATION_COUNT = RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelGroupImpl <em>Label Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelGroup()
	 * @generated
	 */
	int LABEL_GROUP = 122;

	/**
	 * The number of structural features of the '<em>Label Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Label Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableGroupImpl <em>Runnable Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableGroup()
	 * @generated
	 */
	int RUNNABLE_GROUP = 123;

	/**
	 * The number of structural features of the '<em>Runnable Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Runnable Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessGroupImpl <em>Process Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessGroup()
	 * @generated
	 */
	int PROCESS_GROUP = 124;

	/**
	 * The number of structural features of the '<em>Process Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Process Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelEntityGroupImpl <em>Label Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelEntityGroup()
	 * @generated
	 */
	int LABEL_ENTITY_GROUP = 125;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP__CUSTOM_PROPERTIES = LABEL_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP__LABELS = LABEL_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Label Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP_FEATURE_COUNT = LABEL_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Label Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP_OPERATION_COUNT = LABEL_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableEntityGroupImpl <em>Runnable Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableEntityGroup()
	 * @generated
	 */
	int RUNNABLE_ENTITY_GROUP = 126;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP__CUSTOM_PROPERTIES = RUNNABLE_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP__RUNNABLES = RUNNABLE_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP_FEATURE_COUNT = RUNNABLE_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Runnable Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP_OPERATION_COUNT = RUNNABLE_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessEntityGroupImpl <em>Process Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessEntityGroup()
	 * @generated
	 */
	int PROCESS_ENTITY_GROUP = 127;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP__CUSTOM_PROPERTIES = PROCESS_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP__PROCESSES = PROCESS_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP_FEATURE_COUNT = PROCESS_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Process Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP_OPERATION_COUNT = PROCESS_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TagGroupImpl <em>Tag Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TagGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTagGroup()
	 * @generated
	 */
	int TAG_GROUP = 128;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP__CUSTOM_PROPERTIES = RUNNABLE_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP__TAG = RUNNABLE_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Tag Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP_FEATURE_COUNT = RUNNABLE_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Tag Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP_OPERATION_COUNT = RUNNABLE_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractEventChainImpl <em>Abstract Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractEventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractEventChain()
	 * @generated
	 */
	int ABSTRACT_EVENT_CHAIN = 129;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__STIMULUS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__RESPONSE = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__ITEMS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Item Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__ITEM_TYPE = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Min Items Completed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__MIN_ITEMS_COMPLETED = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Abstract Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Abstract Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainImpl <em>Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChain()
	 * @generated
	 */
	int EVENT_CHAIN = 130;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__CUSTOM_PROPERTIES = ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__NAME = ABSTRACT_EVENT_CHAIN__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__QUALIFIED_NAME = ABSTRACT_EVENT_CHAIN__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__STIMULUS = ABSTRACT_EVENT_CHAIN__STIMULUS;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__RESPONSE = ABSTRACT_EVENT_CHAIN__RESPONSE;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__ITEMS = ABSTRACT_EVENT_CHAIN__ITEMS;

	/**
	 * The feature id for the '<em><b>Item Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__ITEM_TYPE = ABSTRACT_EVENT_CHAIN__ITEM_TYPE;

	/**
	 * The feature id for the '<em><b>Min Items Completed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__MIN_ITEMS_COMPLETED = ABSTRACT_EVENT_CHAIN__MIN_ITEMS_COMPLETED;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__UNIQUE_NAME = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_FEATURE_COUNT = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_NAMED_CONTAINER = ABSTRACT_EVENT_CHAIN___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_NAME_PREFIX = ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_EVENT_CHAIN___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_EVENT_CHAIN___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_NAMESPACE = ABSTRACT_EVENT_CHAIN___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_OPERATION_COUNT = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SubEventChainImpl <em>Sub Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SubEventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSubEventChain()
	 * @generated
	 */
	int SUB_EVENT_CHAIN = 131;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__CUSTOM_PROPERTIES = ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__NAME = ABSTRACT_EVENT_CHAIN__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__QUALIFIED_NAME = ABSTRACT_EVENT_CHAIN__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__STIMULUS = ABSTRACT_EVENT_CHAIN__STIMULUS;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__RESPONSE = ABSTRACT_EVENT_CHAIN__RESPONSE;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__ITEMS = ABSTRACT_EVENT_CHAIN__ITEMS;

	/**
	 * The feature id for the '<em><b>Item Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__ITEM_TYPE = ABSTRACT_EVENT_CHAIN__ITEM_TYPE;

	/**
	 * The feature id for the '<em><b>Min Items Completed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__MIN_ITEMS_COMPLETED = ABSTRACT_EVENT_CHAIN__MIN_ITEMS_COMPLETED;

	/**
	 * The number of structural features of the '<em>Sub Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN_FEATURE_COUNT = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_NAMED_CONTAINER = ABSTRACT_EVENT_CHAIN___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_NAME_PREFIX = ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_EVENT_CHAIN___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_EVENT_CHAIN___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_NAMESPACE = ABSTRACT_EVENT_CHAIN___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_EVENT_CHAIN___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Sub Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN_OPERATION_COUNT = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.EventChainItem <em>Event Chain Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.EventChainItem
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainItem()
	 * @generated
	 */
	int EVENT_CHAIN_ITEM = 132;

	/**
	 * The number of structural features of the '<em>Event Chain Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM___GET_EVENT_CHAIN = 0;

	/**
	 * The number of operations of the '<em>Event Chain Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainReferenceImpl <em>Event Chain Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainReferenceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainReference()
	 * @generated
	 */
	int EVENT_CHAIN_REFERENCE = 133;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE__EVENT_CHAIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE___GET_EVENT_CHAIN = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Event Chain Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainContainerImpl <em>Event Chain Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainContainerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainContainer()
	 * @generated
	 */
	int EVENT_CHAIN_CONTAINER = 134;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER__EVENT_CHAIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER___GET_EVENT_CHAIN = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Event Chain Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimingConstraintImpl <em>Timing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimingConstraint()
	 * @generated
	 */
	int TIMING_CONSTRAINT = 135;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Timing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Timing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionConstraintImpl <em>Physical Section Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPhysicalSectionConstraint()
	 * @generated
	 */
	int PHYSICAL_SECTION_CONSTRAINT = 136;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__SECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memories</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__MEMORIES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Physical Section Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Physical Section Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SynchronizationConstraintImpl <em>Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSynchronizationConstraint()
	 * @generated
	 */
	int SYNCHRONIZATION_CONSTRAINT = 137;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__QUALIFIED_NAME = TIMING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__TOLERANCE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_NAMED_CONTAINER = TIMING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX = TIMING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = TIMING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = TIMING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_NAMESPACE = TIMING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = TIMING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = TIMING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIMING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventSynchronizationConstraintImpl <em>Event Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventSynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventSynchronizationConstraint()
	 * @generated
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT = 138;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__NAME = SYNCHRONIZATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__QUALIFIED_NAME = SYNCHRONIZATION_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__TOLERANCE = SYNCHRONIZATION_CONSTRAINT__TOLERANCE;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__EVENTS = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_NAMED_CONTAINER = SYNCHRONIZATION_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX = SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = SYNCHRONIZATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = SYNCHRONIZATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_NAMESPACE = SYNCHRONIZATION_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = SYNCHRONIZATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SYNCHRONIZATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainSynchronizationConstraintImpl <em>Event Chain Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainSynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainSynchronizationConstraint()
	 * @generated
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT = 139;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__NAME = SYNCHRONIZATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__QUALIFIED_NAME = SYNCHRONIZATION_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__TOLERANCE = SYNCHRONIZATION_CONSTRAINT__TOLERANCE;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__SCOPE = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__TYPE = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Chain Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_NAMED_CONTAINER = SYNCHRONIZATION_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX = SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = SYNCHRONIZATION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = SYNCHRONIZATION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_NAMESPACE = SYNCHRONIZATION_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = SYNCHRONIZATION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = SYNCHRONIZATION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SYNCHRONIZATION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event Chain Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DelayConstraintImpl <em>Delay Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DelayConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDelayConstraint()
	 * @generated
	 */
	int DELAY_CONSTRAINT = 140;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__QUALIFIED_NAME = TIMING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Mapping Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__MAPPING_TYPE = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__SOURCE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__TARGET = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__UPPER = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__LOWER = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Delay Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_NAMED_CONTAINER = TIMING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_NAME_PREFIX = TIMING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = TIMING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = TIMING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_NAMESPACE = TIMING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = TIMING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = TIMING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIMING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Delay Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainLatencyConstraintImpl <em>Event Chain Latency Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainLatencyConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainLatencyConstraint()
	 * @generated
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT = 141;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__QUALIFIED_NAME = TIMING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__SCOPE = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__TYPE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Minimum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__MINIMUM = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Maximum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__MAXIMUM = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Event Chain Latency Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_NAMED_CONTAINER = TIMING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_NAME_PREFIX = TIMING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = TIMING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = TIMING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_NAMESPACE = TIMING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = TIMING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = TIMING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIMING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event Chain Latency Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RepetitionConstraintImpl <em>Repetition Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RepetitionConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRepetitionConstraint()
	 * @generated
	 */
	int REPETITION_CONSTRAINT = 142;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__QUALIFIED_NAME = TIMING_CONSTRAINT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__EVENT = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Span</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__SPAN = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__LOWER = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__UPPER = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Jitter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__JITTER = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__PERIOD = TIMING_CONSTRAINT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Repetition Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_NAMED_CONTAINER = TIMING_CONSTRAINT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_NAME_PREFIX = TIMING_CONSTRAINT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = TIMING_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = TIMING_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_NAMESPACE = TIMING_CONSTRAINT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = TIMING_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = TIMING_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TIMING_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Repetition Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeConstraintImpl <em>Data Age Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeConstraint()
	 * @generated
	 */
	int DATA_AGE_CONSTRAINT = 143;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__RUNNABLE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__LABEL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Age</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__DATA_AGE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Data Age Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Data Age Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeImpl <em>Data Age</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAge()
	 * @generated
	 */
	int DATA_AGE = 144;

	/**
	 * The number of structural features of the '<em>Data Age</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Age</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeCycleImpl <em>Data Age Cycle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeCycleImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeCycle()
	 * @generated
	 */
	int DATA_AGE_CYCLE = 145;

	/**
	 * The feature id for the '<em><b>Minimum Cycle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE__MINIMUM_CYCLE = DATA_AGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Cycle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE__MAXIMUM_CYCLE = DATA_AGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Age Cycle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE_FEATURE_COUNT = DATA_AGE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Age Cycle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE_OPERATION_COUNT = DATA_AGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeTimeImpl <em>Data Age Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeTimeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeTime()
	 * @generated
	 */
	int DATA_AGE_TIME = 146;

	/**
	 * The feature id for the '<em><b>Minimum Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME__MINIMUM_TIME = DATA_AGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME__MAXIMUM_TIME = DATA_AGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Age Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME_FEATURE_COUNT = DATA_AGE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Age Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME_OPERATION_COUNT = DATA_AGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RequirementImpl <em>Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRequirement()
	 * @generated
	 */
	int REQUIREMENT = 147;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__SEVERITY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__LIMIT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessRequirementImpl <em>Process Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessRequirement()
	 * @generated
	 */
	int PROCESS_REQUIREMENT = 148;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__QUALIFIED_NAME = REQUIREMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__PROCESS = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_NAMED_CONTAINER = REQUIREMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_NAME_PREFIX = REQUIREMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS = REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR = REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_NAMESPACE = REQUIREMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT___GET_NAME_PREFIX_SEGMENTS = REQUIREMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Process Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableRequirementImpl <em>Runnable Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableRequirement()
	 * @generated
	 */
	int RUNNABLE_REQUIREMENT = 149;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__QUALIFIED_NAME = REQUIREMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__RUNNABLE = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_NAMED_CONTAINER = REQUIREMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_NAME_PREFIX = REQUIREMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS = REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR = REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_NAMESPACE = REQUIREMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT___GET_NAME_PREFIX_SEGMENTS = REQUIREMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Runnable Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArchitectureRequirementImpl <em>Architecture Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArchitectureRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArchitectureRequirement()
	 * @generated
	 */
	int ARCHITECTURE_REQUIREMENT = 150;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__QUALIFIED_NAME = REQUIREMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__COMPONENT = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Architecture Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_NAMED_CONTAINER = REQUIREMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_NAME_PREFIX = REQUIREMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS = REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR = REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_NAMESPACE = REQUIREMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT___GET_NAME_PREFIX_SEGMENTS = REQUIREMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Architecture Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainRequirementImpl <em>Process Chain Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChainRequirement()
	 * @generated
	 */
	int PROCESS_CHAIN_REQUIREMENT = 151;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__QUALIFIED_NAME = REQUIREMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Process Chain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__PROCESS_CHAIN = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Chain Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_NAMED_CONTAINER = REQUIREMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_NAME_PREFIX = REQUIREMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS = REQUIREMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR = REQUIREMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_NAMESPACE = REQUIREMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT___GET_NAME_PREFIX_SEGMENTS = REQUIREMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Process Chain Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RequirementLimitImpl <em>Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRequirementLimit()
	 * @generated
	 */
	int REQUIREMENT_LIMIT = 152;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT__LIMIT_TYPE = 0;

	/**
	 * The number of structural features of the '<em>Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CPUPercentageRequirementLimitImpl <em>CPU Percentage Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CPUPercentageRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCPUPercentageRequirementLimit()
	 * @generated
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT = 153;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Hardware Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__HARDWARE_CONTEXT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>CPU Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>CPU Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyRequirementLimitImpl <em>Frequency Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyRequirementLimit()
	 * @generated
	 */
	int FREQUENCY_REQUIREMENT_LIMIT = 154;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Frequency Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PercentageRequirementLimitImpl <em>Percentage Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PercentageRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPercentageRequirementLimit()
	 * @generated
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT = 155;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CountRequirementLimitImpl <em>Count Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CountRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCountRequirementLimit()
	 * @generated
	 */
	int COUNT_REQUIREMENT_LIMIT = 156;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Count Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Count Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeRequirementLimitImpl <em>Time Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeRequirementLimit()
	 * @generated
	 */
	int TIME_REQUIREMENT_LIMIT = 157;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataCoherencyGroupImpl <em>Data Coherency Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataCoherencyGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataCoherencyGroup()
	 * @generated
	 */
	int DATA_COHERENCY_GROUP = 158;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__DIRECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Data Coherency Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Data Coherency Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataStabilityGroupImpl <em>Data Stability Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataStabilityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataStabilityGroup()
	 * @generated
	 */
	int DATA_STABILITY_GROUP = 159;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Stability Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Data Stability Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataGroupScopeImpl <em>Data Group Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataGroupScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataGroupScope()
	 * @generated
	 */
	int DATA_GROUP_SCOPE = 160;

	/**
	 * The number of structural features of the '<em>Data Group Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_GROUP_SCOPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Group Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_GROUP_SCOPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessScopeImpl <em>Process Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessScope()
	 * @generated
	 */
	int PROCESS_SCOPE = 161;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE__PROCESS = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableScopeImpl <em>Runnable Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableScope()
	 * @generated
	 */
	int RUNNABLE_SCOPE = 162;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE__RUNNABLE = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentScopeImpl <em>Component Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentScope()
	 * @generated
	 */
	int COMPONENT_SCOPE = 163;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE__COMPONENT = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Component Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Component Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventModelImpl <em>Event Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventModel()
	 * @generated
	 */
	int EVENT_MODEL = 164;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__EVENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 165;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventSetImpl <em>Event Set</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventSetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventSet()
	 * @generated
	 */
	int EVENT_SET = 166;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__CUSTOM_PROPERTIES = EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__QUALIFIED_NAME = EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__UNIQUE_NAME = EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__TAGS = EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__DESCRIPTION = EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__EVENTS = EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET_FEATURE_COUNT = EVENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_NAMED_CONTAINER = EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_NAME_PREFIX = EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_QUALIFIED_NAME_SEGMENTS = EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_DEFAULT_NAME_SEPARATOR = EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_NAMESPACE = EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_NAME_PREFIX_SEGMENTS = EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___GET_ENCODED_QUALIFIED_NAME = EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET_OPERATION_COUNT = EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EntityEventImpl <em>Entity Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EntityEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEntityEvent()
	 * @generated
	 */
	int ENTITY_EVENT = 167;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__CUSTOM_PROPERTIES = EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__QUALIFIED_NAME = EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__UNIQUE_NAME = EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__TAGS = EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__DESCRIPTION = EVENT__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Entity Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT_FEATURE_COUNT = EVENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_NAMED_CONTAINER = EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_NAME_PREFIX = EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS = EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR = EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_NAMESPACE = EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS = EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME = EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Entity Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT_OPERATION_COUNT = EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TriggerEventImpl <em>Trigger Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TriggerEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTriggerEvent()
	 * @generated
	 */
	int TRIGGER_EVENT = 168;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Trigger Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Trigger Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomEventImpl <em>Custom Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomEvent()
	 * @generated
	 */
	int CUSTOM_EVENT = 169;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__QUALIFIED_NAME = TRIGGER_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit Triggers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__EXPLICIT_TRIGGERS = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Custom Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_NAMED_CONTAINER = TRIGGER_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_NAME_PREFIX = TRIGGER_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_QUALIFIED_NAME_SEGMENTS = TRIGGER_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_DEFAULT_NAME_SEPARATOR = TRIGGER_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_NAMESPACE = TRIGGER_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_NAME_PREFIX_SEGMENTS = TRIGGER_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___GET_ENCODED_QUALIFIED_NAME = TRIGGER_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRIGGER_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Custom Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimulusEventImpl <em>Stimulus Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimulusEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimulusEvent()
	 * @generated
	 */
	int STIMULUS_EVENT = 170;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Stimulus Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Stimulus Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessEventImpl <em>Process Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessEvent()
	 * @generated
	 */
	int PROCESS_EVENT = 171;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Process Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainEventImpl <em>Process Chain Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChainEvent()
	 * @generated
	 */
	int PROCESS_CHAIN_EVENT = 172;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Process Chain Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Chain Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableEventImpl <em>Runnable Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableEvent()
	 * @generated
	 */
	int RUNNABLE_EVENT = 173;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__QUALIFIED_NAME = TRIGGER_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__PROCESSING_UNIT = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Runnable Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_NAMED_CONTAINER = TRIGGER_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_NAME_PREFIX = TRIGGER_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_QUALIFIED_NAME_SEGMENTS = TRIGGER_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_DEFAULT_NAME_SEPARATOR = TRIGGER_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_NAMESPACE = TRIGGER_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_NAME_PREFIX_SEGMENTS = TRIGGER_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___GET_ENCODED_QUALIFIED_NAME = TRIGGER_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRIGGER_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Runnable Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelEventImpl <em>Label Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelEvent()
	 * @generated
	 */
	int LABEL_EVENT = 174;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__QUALIFIED_NAME = TRIGGER_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__RUNNABLE = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Label Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_NAMED_CONTAINER = TRIGGER_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_NAME_PREFIX = TRIGGER_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_QUALIFIED_NAME_SEGMENTS = TRIGGER_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_DEFAULT_NAME_SEPARATOR = TRIGGER_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_NAMESPACE = TRIGGER_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_NAME_PREFIX_SEGMENTS = TRIGGER_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___GET_ENCODED_QUALIFIED_NAME = TRIGGER_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRIGGER_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Label Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelEventImpl <em>Channel Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelEvent()
	 * @generated
	 */
	int CHANNEL_EVENT = 175;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__QUALIFIED_NAME = TRIGGER_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__RUNNABLE = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Channel Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_NAMED_CONTAINER = TRIGGER_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_NAME_PREFIX = TRIGGER_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_QUALIFIED_NAME_SEGMENTS = TRIGGER_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_DEFAULT_NAME_SEPARATOR = TRIGGER_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_NAMESPACE = TRIGGER_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_NAME_PREFIX_SEGMENTS = TRIGGER_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___GET_ENCODED_QUALIFIED_NAME = TRIGGER_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = TRIGGER_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Channel Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreEventImpl <em>Semaphore Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreEvent()
	 * @generated
	 */
	int SEMAPHORE_EVENT = 176;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__RUNNABLE = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__PROCESS = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Semaphore Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Semaphore Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentEventImpl <em>Component Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentEvent()
	 * @generated
	 */
	int COMPONENT_EVENT = 177;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__QUALIFIED_NAME = ENTITY_EVENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_NAMED_CONTAINER = ENTITY_EVENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_NAME_PREFIX = ENTITY_EVENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_QUALIFIED_NAME_SEGMENTS = ENTITY_EVENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_DEFAULT_NAME_SEPARATOR = ENTITY_EVENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_NAMESPACE = ENTITY_EVENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_NAME_PREFIX_SEGMENTS = ENTITY_EVENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___GET_ENCODED_QUALIFIED_NAME = ENTITY_EVENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ENTITY_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Component Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HWModelImpl <em>HW Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HWModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHWModel()
	 * @generated
	 */
	int HW_MODEL = 178;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Definitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__DEFINITIONS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature Categories</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__FEATURE_CATEGORIES = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__STRUCTURES = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Domains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__DOMAINS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>HW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>HW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwStructureImpl <em>Hw Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwStructureImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwStructure()
	 * @generated
	 */
	int HW_STRUCTURE = 179;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Structure Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__STRUCTURE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__STRUCTURES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modules</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__MODULES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Connections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__CONNECTIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__INNER_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Hw Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwModuleImpl <em>Hw Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwModuleImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwModule()
	 * @generated
	 */
	int HW_MODULE = 180;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__POWER_DOMAIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__FREQUENCY_DOMAIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Hw Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Hw Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwDomainImpl <em>Hw Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDomain()
	 * @generated
	 */
	int HW_DOMAIN = 181;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Hw Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyDomainImpl <em>Frequency Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyDomain()
	 * @generated
	 */
	int FREQUENCY_DOMAIN = 182;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__CUSTOM_PROPERTIES = HW_DOMAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__NAME = HW_DOMAIN__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__QUALIFIED_NAME = HW_DOMAIN__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__UNIQUE_NAME = HW_DOMAIN__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__TAGS = HW_DOMAIN__TAGS;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__DEFAULT_VALUE = HW_DOMAIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clock Gating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__CLOCK_GATING = HW_DOMAIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN_FEATURE_COUNT = HW_DOMAIN_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_NAMED_CONTAINER = HW_DOMAIN___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_NAME_PREFIX = HW_DOMAIN___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_QUALIFIED_NAME_SEGMENTS = HW_DOMAIN___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_DEFAULT_NAME_SEPARATOR = HW_DOMAIN___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_NAMESPACE = HW_DOMAIN___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_NAME_PREFIX_SEGMENTS = HW_DOMAIN___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___GET_ENCODED_QUALIFIED_NAME = HW_DOMAIN___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DOMAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Frequency Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN_OPERATION_COUNT = HW_DOMAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PowerDomainImpl <em>Power Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PowerDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPowerDomain()
	 * @generated
	 */
	int POWER_DOMAIN = 183;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__CUSTOM_PROPERTIES = HW_DOMAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__NAME = HW_DOMAIN__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__QUALIFIED_NAME = HW_DOMAIN__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__UNIQUE_NAME = HW_DOMAIN__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__TAGS = HW_DOMAIN__TAGS;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__DEFAULT_VALUE = HW_DOMAIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Power Gating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__POWER_GATING = HW_DOMAIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Power Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN_FEATURE_COUNT = HW_DOMAIN_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_NAMED_CONTAINER = HW_DOMAIN___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_NAME_PREFIX = HW_DOMAIN___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_QUALIFIED_NAME_SEGMENTS = HW_DOMAIN___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_DEFAULT_NAME_SEPARATOR = HW_DOMAIN___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_NAMESPACE = HW_DOMAIN___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_NAME_PREFIX_SEGMENTS = HW_DOMAIN___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___GET_ENCODED_QUALIFIED_NAME = HW_DOMAIN___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DOMAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Power Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN_OPERATION_COUNT = HW_DOMAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitImpl <em>Processing Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessingUnit()
	 * @generated
	 */
	int PROCESSING_UNIT = 184;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__QUALIFIED_NAME = HW_MODULE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__ACCESS_ELEMENTS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Caches</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__CACHES = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processing Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_NAMED_CONTAINER = HW_MODULE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_NAME_PREFIX = HW_MODULE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_QUALIFIED_NAME_SEGMENTS = HW_MODULE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_DEFAULT_NAME_SEPARATOR = HW_MODULE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_NAMESPACE = HW_MODULE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_NAME_PREFIX_SEGMENTS = HW_MODULE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_ENCODED_QUALIFIED_NAME = HW_MODULE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_MODULE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_PORTS = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Processing Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryImpl <em>Memory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemory()
	 * @generated
	 */
	int MEMORY = 185;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__QUALIFIED_NAME = HW_MODULE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__MAPPINGS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_NAMED_CONTAINER = HW_MODULE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_NAME_PREFIX = HW_MODULE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_QUALIFIED_NAME_SEGMENTS = HW_MODULE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_DEFAULT_NAME_SEPARATOR = HW_MODULE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_NAMESPACE = HW_MODULE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_NAME_PREFIX_SEGMENTS = HW_MODULE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_ENCODED_QUALIFIED_NAME = HW_MODULE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_MODULE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CacheImpl <em>Cache</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CacheImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCache()
	 * @generated
	 */
	int CACHE = 186;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__QUALIFIED_NAME = HW_MODULE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Cache</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_NAMED_CONTAINER = HW_MODULE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_NAME_PREFIX = HW_MODULE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_QUALIFIED_NAME_SEGMENTS = HW_MODULE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_DEFAULT_NAME_SEPARATOR = HW_MODULE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_NAMESPACE = HW_MODULE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_NAME_PREFIX_SEGMENTS = HW_MODULE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_ENCODED_QUALIFIED_NAME = HW_MODULE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_MODULE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Cache</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwFeatureCategoryImpl <em>Hw Feature Category</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwFeatureCategoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwFeatureCategory()
	 * @generated
	 */
	int HW_FEATURE_CATEGORY = 187;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__FEATURE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__FEATURES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Hw Feature Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Hw Feature Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwFeatureImpl <em>Hw Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwFeatureImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwFeature()
	 * @generated
	 */
	int HW_FEATURE = 188;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Category</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__CONTAINING_CATEGORY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Hw Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Hw Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwPortImpl <em>Hw Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwPortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPort()
	 * @generated
	 */
	int HW_PORT = 189;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bit Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__BIT_WIDTH = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PRIORITY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Port Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PORT_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Port Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PORT_INTERFACE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Delegated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__DELEGATED = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Connections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__CONNECTIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerImpl <em>Connection Handler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnectionHandler()
	 * @generated
	 */
	int CONNECTION_HANDLER = 190;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__QUALIFIED_NAME = HW_MODULE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Internal Connections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__INTERNAL_CONNECTIONS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Connection Handler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_NAMED_CONTAINER = HW_MODULE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_NAME_PREFIX = HW_MODULE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_QUALIFIED_NAME_SEGMENTS = HW_MODULE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_DEFAULT_NAME_SEPARATOR = HW_MODULE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_NAMESPACE = HW_MODULE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_NAME_PREFIX_SEGMENTS = HW_MODULE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_ENCODED_QUALIFIED_NAME = HW_MODULE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_MODULE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Connection Handler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwConnectionImpl <em>Hw Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwConnectionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwConnection()
	 * @generated
	 */
	int HW_CONNECTION = 191;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__READ_LATENCY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__WRITE_LATENCY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__DATA_RATE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Port1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__PORT1 = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Port2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__PORT2 = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__INTERNAL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_PORTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Hw Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwAccessElementImpl <em>Hw Access Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwAccessElementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwAccessElement()
	 * @generated
	 */
	int HW_ACCESS_ELEMENT = 192;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__TAGS = ITAGGABLE__TAGS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__NAME = ITAGGABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__QUALIFIED_NAME = ITAGGABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__SOURCE = ITAGGABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__DESTINATION = ITAGGABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Access Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__ACCESS_PATH = ITAGGABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__READ_LATENCY = ITAGGABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__WRITE_LATENCY = ITAGGABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__DATA_RATE = ITAGGABLE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Hw Access Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT_FEATURE_COUNT = ITAGGABLE_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_NAMED_CONTAINER = ITAGGABLE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_NAME_PREFIX = ITAGGABLE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS = ITAGGABLE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_DEFAULT_NAME_SEPARATOR = ITAGGABLE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_NAMESPACE = ITAGGABLE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT___GET_NAME_PREFIX_SEGMENTS = ITAGGABLE_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Hw Access Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT_OPERATION_COUNT = ITAGGABLE_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwDefinitionImpl <em>Hw Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDefinition()
	 * @generated
	 */
	int HW_DEFINITION = 193;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Hw Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitDefinitionImpl <em>Processing Unit Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessingUnitDefinition()
	 * @generated
	 */
	int PROCESSING_UNIT_DEFINITION = 194;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__QUALIFIED_NAME = HW_DEFINITION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Pu Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__PU_TYPE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Features</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__FEATURES = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__CLASSIFIERS = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processing Unit Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_NAMED_CONTAINER = HW_DEFINITION___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_NAME_PREFIX = HW_DEFINITION___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS = HW_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_DEFAULT_NAME_SEPARATOR = HW_DEFINITION___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_NAMESPACE = HW_DEFINITION___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_NAME_PREFIX_SEGMENTS = HW_DEFINITION___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___GET_ENCODED_QUALIFIED_NAME = HW_DEFINITION___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Processing Unit Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerDefinitionImpl <em>Connection Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnectionHandlerDefinition()
	 * @generated
	 */
	int CONNECTION_HANDLER_DEFINITION = 195;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__QUALIFIED_NAME = HW_DEFINITION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__POLICY = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__READ_LATENCY = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__WRITE_LATENCY = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__DATA_RATE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Max Burst Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__MAX_BURST_SIZE = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Max Concurrent Transfers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__MAX_CONCURRENT_TRANSFERS = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Connection Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_NAMED_CONTAINER = HW_DEFINITION___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_NAME_PREFIX = HW_DEFINITION___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS = HW_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_DEFAULT_NAME_SEPARATOR = HW_DEFINITION___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_NAMESPACE = HW_DEFINITION___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_NAME_PREFIX_SEGMENTS = HW_DEFINITION___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___GET_ENCODED_QUALIFIED_NAME = HW_DEFINITION___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Connection Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryDefinitionImpl <em>Memory Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryDefinition()
	 * @generated
	 */
	int MEMORY_DEFINITION = 196;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__QUALIFIED_NAME = HW_DEFINITION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__SIZE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__ACCESS_LATENCY = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__DATA_RATE = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Memory Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__MEMORY_TYPE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__CLASSIFIERS = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Memory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_NAMED_CONTAINER = HW_DEFINITION___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_NAME_PREFIX = HW_DEFINITION___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS = HW_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_DEFAULT_NAME_SEPARATOR = HW_DEFINITION___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_NAMESPACE = HW_DEFINITION___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_NAME_PREFIX_SEGMENTS = HW_DEFINITION___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___GET_ENCODED_QUALIFIED_NAME = HW_DEFINITION___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Memory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CacheDefinitionImpl <em>Cache Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CacheDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCacheDefinition()
	 * @generated
	 */
	int CACHE_DEFINITION = 197;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__QUALIFIED_NAME = HW_DEFINITION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__SIZE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Line Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__LINE_SIZE = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__ACCESS_LATENCY = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cache Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__CACHE_TYPE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Write Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__WRITE_STRATEGY = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>NWays</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__NWAYS = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Coherency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__COHERENCY = HW_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Exclusive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__EXCLUSIVE = HW_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Hit Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__HIT_RATE = HW_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Cache Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_NAMED_CONTAINER = HW_DEFINITION___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_NAME_PREFIX = HW_DEFINITION___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS = HW_DEFINITION___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_DEFAULT_NAME_SEPARATOR = HW_DEFINITION___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_NAMESPACE = HW_DEFINITION___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_NAME_PREFIX_SEGMENTS = HW_DEFINITION___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___GET_ENCODED_QUALIFIED_NAME = HW_DEFINITION___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = HW_DEFINITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Cache Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwPathImpl <em>Hw Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwPathImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPath()
	 * @generated
	 */
	int HW_PATH = 198;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH__DESTINATION = 1;

	/**
	 * The number of structural features of the '<em>Hw Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Containing Access Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH___GET_CONTAINING_ACCESS_ELEMENT = 0;

	/**
	 * The number of operations of the '<em>Hw Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwAccessPathImpl <em>Hw Access Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwAccessPathImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwAccessPath()
	 * @generated
	 */
	int HW_ACCESS_PATH = 199;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__SOURCE = HW_PATH__SOURCE;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__DESTINATION = HW_PATH__DESTINATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__NAME = HW_PATH_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__QUALIFIED_NAME = HW_PATH_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Containing Access Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__CONTAINING_ACCESS_ELEMENT = HW_PATH_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Path Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__PATH_ELEMENTS = HW_PATH_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Start Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__START_ADDRESS = HW_PATH_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>End Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__END_ADDRESS = HW_PATH_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mem Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__MEM_OFFSET = HW_PATH_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Access Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH_FEATURE_COUNT = HW_PATH_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get Containing Access Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_CONTAINING_ACCESS_ELEMENT = HW_PATH___GET_CONTAINING_ACCESS_ELEMENT;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_NAMED_CONTAINER = HW_PATH_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_NAME_PREFIX = HW_PATH_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_QUALIFIED_NAME_SEGMENTS = HW_PATH_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_DEFAULT_NAME_SEPARATOR = HW_PATH_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_NAMESPACE = HW_PATH_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_NAME_PREFIX_SEGMENTS = HW_PATH_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Hw Access Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH_OPERATION_COUNT = HW_PATH_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.HwPathElement <em>Hw Path Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.HwPathElement
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPathElement()
	 * @generated
	 */
	int HW_PATH_ELEMENT = 200;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT__QUALIFIED_NAME = IREFERABLE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Hw Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_NAMED_CONTAINER = IREFERABLE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_NAME_PREFIX = IREFERABLE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS = IREFERABLE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_DEFAULT_NAME_SEPARATOR = IREFERABLE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_NAMESPACE = IREFERABLE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_NAME_PREFIX_SEGMENTS = IREFERABLE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_ENCODED_QUALIFIED_NAME = IREFERABLE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = IREFERABLE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_PORTS = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.HwDestination <em>Hw Destination</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.HwDestination
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDestination()
	 * @generated
	 */
	int HW_DESTINATION = 201;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION__QUALIFIED_NAME = IREFERABLE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Hw Destination</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_NAMED_CONTAINER = IREFERABLE___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_NAME_PREFIX = IREFERABLE___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_QUALIFIED_NAME_SEGMENTS = IREFERABLE___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_DEFAULT_NAME_SEPARATOR = IREFERABLE___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_NAMESPACE = IREFERABLE___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_NAME_PREFIX_SEGMENTS = IREFERABLE___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_ENCODED_QUALIFIED_NAME = IREFERABLE___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = IREFERABLE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_PORTS = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Destination</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MappingModelImpl <em>Mapping Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MappingModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMappingModel()
	 * @generated
	 */
	int MAPPING_MODEL = 202;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__SCHEDULER_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__RUNNABLE_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Task Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__TASK_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Isr Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__ISR_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Memory Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__MEMORY_MAPPING = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Physical Section Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__PHYSICAL_SECTION_MAPPING = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Address Mapping Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__ADDRESS_MAPPING_TYPE = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Mapping Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Mapping Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerAllocationImpl <em>Scheduler Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulerAllocation()
	 * @generated
	 */
	int SCHEDULER_ALLOCATION = 203;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Responsibility</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__RESPONSIBILITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Executing PU</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__EXECUTING_PU = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Scheduler Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Scheduler Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskAllocationImpl <em>Task Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskAllocation()
	 * @generated
	 */
	int TASK_ALLOCATION = 204;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Task</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__TASK = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Affinity</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__AFFINITY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scheduling Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__SCHEDULING_PARAMETERS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__PARAMETER_EXTENSIONS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Task Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Task Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ISRAllocationImpl <em>ISR Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ISRAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISRAllocation()
	 * @generated
	 */
	int ISR_ALLOCATION = 205;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Isr</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__ISR = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Controller</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__CONTROLLER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__PRIORITY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>ISR Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>ISR Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationImpl <em>Runnable Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableAllocation()
	 * @generated
	 */
	int RUNNABLE_ALLOCATION = 206;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__ENTITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Runnable Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryMappingImpl <em>Memory Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryMappingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryMapping()
	 * @generated
	 */
	int MEMORY_MAPPING = 207;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Abstract Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__ABSTRACT_ELEMENT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__MEMORY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Memory Position Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__MEMORY_POSITION_ADDRESS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Memory Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Memory Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionMappingImpl <em>Physical Section Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionMappingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPhysicalSectionMapping()
	 * @generated
	 */
	int PHYSICAL_SECTION_MAPPING = 208;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__ORIGIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__MEMORY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Start Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__START_ADDRESS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>End Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__END_ADDRESS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Run Entities</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__RUN_ENTITIES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Physical Section Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Physical Section Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OSModelImpl <em>OS Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OSModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOSModel()
	 * @generated
	 */
	int OS_MODEL = 209;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__SEMAPHORES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operating Systems</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__OPERATING_SYSTEMS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Os Overheads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__OS_OVERHEADS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>OS Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>OS Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsDataConsistencyImpl <em>Os Data Consistency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsDataConsistencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsDataConsistency()
	 * @generated
	 */
	int OS_DATA_CONSISTENCY = 210;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__MODE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__DATA_STABILITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Non Atomic Data Coherency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__NON_ATOMIC_DATA_COHERENCY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Data Consistency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Os Data Consistency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataStabilityImpl <em>Data Stability</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataStabilityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataStability()
	 * @generated
	 */
	int DATA_STABILITY = 211;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ENABLED = 0;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ALGORITHM = 1;

	/**
	 * The feature id for the '<em><b>Access Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ACCESS_MULTIPLICITY = 2;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__LEVEL = 3;

	/**
	 * The number of structural features of the '<em>Data Stability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Data Stability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NonAtomicDataCoherencyImpl <em>Non Atomic Data Coherency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NonAtomicDataCoherencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNonAtomicDataCoherency()
	 * @generated
	 */
	int NON_ATOMIC_DATA_COHERENCY = 212;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ENABLED = 0;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ALGORITHM = 1;

	/**
	 * The feature id for the '<em><b>Access Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ACCESS_MULTIPLICITY = 2;

	/**
	 * The number of structural features of the '<em>Non Atomic Data Coherency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Non Atomic Data Coherency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreImpl <em>Semaphore</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphore()
	 * @generated
	 */
	int SEMAPHORE = 213;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Semaphore Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__SEMAPHORE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Initial Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__INITIAL_VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__MAX_VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Priority Ceiling Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__PRIORITY_CEILING_PROTOCOL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Semaphore Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__SEMAPHORE_ACCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__REFERRING_COMPONENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Semaphore</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Semaphore</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerImpl <em>Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getScheduler()
	 * @generated
	 */
	int SCHEDULER = 214;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__COMPUTATION_ITEMS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__SCHEDULER_ALLOCATIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__RUNNABLE_ALLOCATIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_SCHEDULING_ALGORITHM = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskSchedulerImpl <em>Task Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskSchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskScheduler()
	 * @generated
	 */
	int TASK_SCHEDULER = 215;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CUSTOM_PROPERTIES = SCHEDULER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__NAME = SCHEDULER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__QUALIFIED_NAME = SCHEDULER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__UNIQUE_NAME = SCHEDULER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__COMPUTATION_ITEMS = SCHEDULER__COMPUTATION_ITEMS;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__SCHEDULER_ALLOCATIONS = SCHEDULER__SCHEDULER_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__RUNNABLE_ALLOCATIONS = SCHEDULER__RUNNABLE_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Scheduling Algorithm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__SCHEDULING_ALGORITHM = SCHEDULER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent Association</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__PARENT_ASSOCIATION = SCHEDULER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Child Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CHILD_ASSOCIATIONS = SCHEDULER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Task Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__TASK_ALLOCATIONS = SCHEDULER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__PARENT_SCHEDULER = SCHEDULER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Child Schedulers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CHILD_SCHEDULERS = SCHEDULER_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Task Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER_FEATURE_COUNT = SCHEDULER_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_NAMED_CONTAINER = SCHEDULER___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_NAME_PREFIX = SCHEDULER___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_QUALIFIED_NAME_SEGMENTS = SCHEDULER___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_DEFAULT_NAME_SEPARATOR = SCHEDULER___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_NAMESPACE = SCHEDULER___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_NAME_PREFIX_SEGMENTS = SCHEDULER___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_ENCODED_QUALIFIED_NAME = SCHEDULER___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SCHEDULER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_SCHEDULING_ALGORITHM = SCHEDULER___GET_SCHEDULING_ALGORITHM;

	/**
	 * The number of operations of the '<em>Task Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER_OPERATION_COUNT = SCHEDULER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerAssociationImpl <em>Scheduler Association</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerAssociationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulerAssociation()
	 * @generated
	 */
	int SCHEDULER_ASSOCIATION = 216;

	/**
	 * The feature id for the '<em><b>Child</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__CHILD = 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__PARENT = 1;

	/**
	 * The feature id for the '<em><b>Scheduling Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__SCHEDULING_PARAMETERS = 2;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__PARAMETER_EXTENSIONS = 3;

	/**
	 * The number of structural features of the '<em>Scheduler Association</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Scheduler Association</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterruptControllerImpl <em>Interrupt Controller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterruptControllerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterruptController()
	 * @generated
	 */
	int INTERRUPT_CONTROLLER = 217;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__CUSTOM_PROPERTIES = SCHEDULER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__NAME = SCHEDULER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__QUALIFIED_NAME = SCHEDULER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__UNIQUE_NAME = SCHEDULER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__COMPUTATION_ITEMS = SCHEDULER__COMPUTATION_ITEMS;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__SCHEDULER_ALLOCATIONS = SCHEDULER__SCHEDULER_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__RUNNABLE_ALLOCATIONS = SCHEDULER__RUNNABLE_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Scheduling Algorithm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__SCHEDULING_ALGORITHM = SCHEDULER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Isr Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__ISR_ALLOCATIONS = SCHEDULER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interrupt Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER_FEATURE_COUNT = SCHEDULER_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_NAMED_CONTAINER = SCHEDULER___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_NAME_PREFIX = SCHEDULER___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_QUALIFIED_NAME_SEGMENTS = SCHEDULER___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_DEFAULT_NAME_SEPARATOR = SCHEDULER___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_NAMESPACE = SCHEDULER___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_NAME_PREFIX_SEGMENTS = SCHEDULER___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_ENCODED_QUALIFIED_NAME = SCHEDULER___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = SCHEDULER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_SCHEDULING_ALGORITHM = SCHEDULER___GET_SCHEDULING_ALGORITHM;

	/**
	 * The number of operations of the '<em>Interrupt Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER_OPERATION_COUNT = SCHEDULER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulingParametersImpl <em>Scheduling Parameters</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulingParametersImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulingParameters()
	 * @generated
	 */
	int SCHEDULING_PARAMETERS = 218;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__PRIORITY = 0;

	/**
	 * The feature id for the '<em><b>Min Budget</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__MIN_BUDGET = 1;

	/**
	 * The feature id for the '<em><b>Max Budget</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__MAX_BUDGET = 2;

	/**
	 * The feature id for the '<em><b>Replenishment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__REPLENISHMENT = 3;

	/**
	 * The number of structural features of the '<em>Scheduling Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Scheduling Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ParameterExtensionImpl <em>Parameter Extension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ParameterExtensionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getParameterExtension()
	 * @generated
	 */
	int PARAMETER_EXTENSION = 219;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Parameter Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Parameter Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AlgorithmImpl <em>Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAlgorithm()
	 * @generated
	 */
	int ALGORITHM = 220;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterruptSchedulingAlgorithmImpl <em>Interrupt Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterruptSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterruptSchedulingAlgorithm()
	 * @generated
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM = 221;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Interrupt Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM_FEATURE_COUNT = ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Interrupt Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM_OPERATION_COUNT = ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskSchedulingAlgorithmImpl <em>Task Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskSchedulingAlgorithm()
	 * @generated
	 */
	int TASK_SCHEDULING_ALGORITHM = 222;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Task Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT = ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Task Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT = ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityImpl <em>Fixed Priority</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriority()
	 * @generated
	 */
	int FIXED_PRIORITY = 223;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveImpl <em>Fixed Priority Preemptive</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriorityPreemptive()
	 * @generated
	 */
	int FIXED_PRIORITY_PREEMPTIVE = 224;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority Preemptive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority Preemptive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveWithBudgetEnforcementImpl <em>Fixed Priority Preemptive With Budget Enforcement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveWithBudgetEnforcementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriorityPreemptiveWithBudgetEnforcement()
	 * @generated
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT = 225;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority Preemptive With Budget Enforcement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority Preemptive With Budget Enforcement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OSEKImpl <em>OSEK</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OSEKImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOSEK()
	 * @generated
	 */
	int OSEK = 226;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>OSEK</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>OSEK</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DeadlineMonotonicImpl <em>Deadline Monotonic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DeadlineMonotonicImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDeadlineMonotonic()
	 * @generated
	 */
	int DEADLINE_MONOTONIC = 227;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Deadline Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Deadline Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RateMonotonicImpl <em>Rate Monotonic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RateMonotonicImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRateMonotonic()
	 * @generated
	 */
	int RATE_MONOTONIC = 228;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Rate Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Rate Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PfairImpl <em>Pfair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PfairImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPfair()
	 * @generated
	 */
	int PFAIR = 229;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR__QUANT_SIZE_NS = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Pfair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Pfair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PfairPD2Impl <em>Pfair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PfairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPfairPD2()
	 * @generated
	 */
	int PFAIR_PD2 = 230;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Pfair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Pfair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PartlyPFairPD2Impl <em>Partly PFair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PartlyPFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPartlyPFairPD2()
	 * @generated
	 */
	int PARTLY_PFAIR_PD2 = 231;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Partly PFair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Partly PFair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EarlyReleaseFairPD2Impl <em>Early Release Fair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EarlyReleaseFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEarlyReleaseFairPD2()
	 * @generated
	 */
	int EARLY_RELEASE_FAIR_PD2 = 232;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PartlyEarlyReleaseFairPD2Impl <em>Partly Early Release Fair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PartlyEarlyReleaseFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPartlyEarlyReleaseFairPD2()
	 * @generated
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2 = 233;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Partly Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Partly Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DynamicPriorityImpl <em>Dynamic Priority</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DynamicPriorityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDynamicPriority()
	 * @generated
	 */
	int DYNAMIC_PRIORITY = 234;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Dynamic Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Dynamic Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LeastLocalRemainingExecutionTimeFirstImpl <em>Least Local Remaining Execution Time First</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LeastLocalRemainingExecutionTimeFirstImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLeastLocalRemainingExecutionTimeFirst()
	 * @generated
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST = 235;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Least Local Remaining Execution Time First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Least Local Remaining Execution Time First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EarliestDeadlineFirstImpl <em>Earliest Deadline First</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EarliestDeadlineFirstImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEarliestDeadlineFirst()
	 * @generated
	 */
	int EARLIEST_DEADLINE_FIRST = 236;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Earliest Deadline First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Earliest Deadline First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PriorityBasedRoundRobinImpl <em>Priority Based Round Robin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PriorityBasedRoundRobinImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPriorityBasedRoundRobin()
	 * @generated
	 */
	int PRIORITY_BASED_ROUND_ROBIN = 237;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Priority Based Round Robin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Priority Based Round Robin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReservationBasedServerImpl <em>Reservation Based Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReservationBasedServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReservationBasedServer()
	 * @generated
	 */
	int RESERVATION_BASED_SERVER = 238;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Reservation Based Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Reservation Based Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DeferrableServerImpl <em>Deferrable Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DeferrableServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDeferrableServer()
	 * @generated
	 */
	int DEFERRABLE_SERVER = 239;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Deferrable Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Deferrable Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PollingPeriodicServerImpl <em>Polling Periodic Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PollingPeriodicServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPollingPeriodicServer()
	 * @generated
	 */
	int POLLING_PERIODIC_SERVER = 240;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Polling Periodic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Polling Periodic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SporadicServerImpl <em>Sporadic Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SporadicServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSporadicServer()
	 * @generated
	 */
	int SPORADIC_SERVER = 241;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Sporadic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sporadic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerImpl <em>Constant Bandwidth Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstantBandwidthServer()
	 * @generated
	 */
	int CONSTANT_BANDWIDTH_SERVER = 242;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Constant Bandwidth Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Constant Bandwidth Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerWithCASHImpl <em>Constant Bandwidth Server With CASH</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerWithCASHImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstantBandwidthServerWithCASH()
	 * @generated
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH = 243;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Constant Bandwidth Server With CASH</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Constant Bandwidth Server With CASH</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GroupingImpl <em>Grouping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GroupingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGrouping()
	 * @generated
	 */
	int GROUPING = 244;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Grouping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Grouping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.UserSpecificSchedulingAlgorithmImpl <em>User Specific Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.UserSpecificSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getUserSpecificSchedulingAlgorithm()
	 * @generated
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM = 245;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM__PARAMETER_EXTENSIONS = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>User Specific Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>User Specific Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PriorityBasedImpl <em>Priority Based</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PriorityBasedImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPriorityBased()
	 * @generated
	 */
	int PRIORITY_BASED = 246;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED__CUSTOM_PROPERTIES = INTERRUPT_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Priority Based</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_FEATURE_COUNT = INTERRUPT_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Priority Based</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_OPERATION_COUNT = INTERRUPT_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OperatingSystemImpl <em>Operating System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OperatingSystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOperatingSystem()
	 * @generated
	 */
	int OPERATING_SYSTEM = 247;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Task Schedulers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__TASK_SCHEDULERS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Interrupt Controllers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__INTERRUPT_CONTROLLERS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Os Data Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__OS_DATA_CONSISTENCY = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VendorOperatingSystemImpl <em>Vendor Operating System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VendorOperatingSystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVendorOperatingSystem()
	 * @generated
	 */
	int VENDOR_OPERATING_SYSTEM = 248;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__CUSTOM_PROPERTIES = OPERATING_SYSTEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__NAME = OPERATING_SYSTEM__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__QUALIFIED_NAME = OPERATING_SYSTEM__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OVERHEAD = OPERATING_SYSTEM__OVERHEAD;

	/**
	 * The feature id for the '<em><b>Task Schedulers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__TASK_SCHEDULERS = OPERATING_SYSTEM__TASK_SCHEDULERS;

	/**
	 * The feature id for the '<em><b>Interrupt Controllers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__INTERRUPT_CONTROLLERS = OPERATING_SYSTEM__INTERRUPT_CONTROLLERS;

	/**
	 * The feature id for the '<em><b>Os Data Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OS_DATA_CONSISTENCY = OPERATING_SYSTEM__OS_DATA_CONSISTENCY;

	/**
	 * The feature id for the '<em><b>Os Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OS_NAME = OPERATING_SYSTEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__VENDOR = OPERATING_SYSTEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__VERSION = OPERATING_SYSTEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Vendor Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM_FEATURE_COUNT = OPERATING_SYSTEM_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_NAMED_CONTAINER = OPERATING_SYSTEM___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_NAME_PREFIX = OPERATING_SYSTEM___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_QUALIFIED_NAME_SEGMENTS = OPERATING_SYSTEM___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_DEFAULT_NAME_SEPARATOR = OPERATING_SYSTEM___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_NAMESPACE = OPERATING_SYSTEM___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM___GET_NAME_PREFIX_SEGMENTS = OPERATING_SYSTEM___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The number of operations of the '<em>Vendor Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM_OPERATION_COUNT = OPERATING_SYSTEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsOverheadImpl <em>Os Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsOverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsOverhead()
	 * @generated
	 */
	int OS_OVERHEAD = 249;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Api Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__API_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Isr Category1 Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__ISR_CATEGORY1_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Isr Category2 Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__ISR_CATEGORY2_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Os Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsAPIOverheadImpl <em>Os API Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsAPIOverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsAPIOverhead()
	 * @generated
	 */
	int OS_API_OVERHEAD = 250;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Api Send Message</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SEND_MESSAGE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Api Terminate Task</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_TERMINATE_TASK = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Api Schedule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SCHEDULE = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Api Request Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_REQUEST_RESOURCE = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Api Release Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RELEASE_RESOURCE = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Api Set Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SET_EVENT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Api Wait Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_WAIT_EVENT = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Api Clear Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_CLEAR_EVENT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Api Activate Task</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_ACTIVATE_TASK = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Api Enforced Migration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_ENFORCED_MIGRATION = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Api Suspend Os Interrupts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SUSPEND_OS_INTERRUPTS = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Api Resume Os Interrupts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RESUME_OS_INTERRUPTS = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Api Request Spinlock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_REQUEST_SPINLOCK = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Api Release Spinlock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RELEASE_SPINLOCK = BASE_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Api Sender Receiver Read</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SENDER_RECEIVER_READ = BASE_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Api Sender Receiver Write</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SENDER_RECEIVER_WRITE = BASE_OBJECT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Api Synchronous Server Call Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SYNCHRONOUS_SERVER_CALL_POINT = BASE_OBJECT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Api Ioc Read</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_IOC_READ = BASE_OBJECT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Api Ioc Write</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_IOC_WRITE = BASE_OBJECT_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>Os API Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>Os API Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsISROverheadImpl <em>Os ISR Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsISROverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsISROverhead()
	 * @generated
	 */
	int OS_ISR_OVERHEAD = 251;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Pre Execution Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__PRE_EXECUTION_OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Post Execution Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__POST_EXECUTION_OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Os ISR Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Os ISR Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PropertyConstraintsModelImpl <em>Property Constraints Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PropertyConstraintsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPropertyConstraintsModel()
	 * @generated
	 */
	int PROPERTY_CONSTRAINTS_MODEL = 252;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Allocation Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__ALLOCATION_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mapping Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__MAPPING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Property Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Property Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreAllocationConstraintImpl <em>Core Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreAllocationConstraint()
	 * @generated
	 */
	int CORE_ALLOCATION_CONSTRAINT = 253;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Core Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Core Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryMappingConstraintImpl <em>Memory Mapping Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryMappingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryMappingConstraint()
	 * @generated
	 */
	int MEMORY_MAPPING_CONSTRAINT = 254;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Memory Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Memory Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Memory Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessAllocationConstraintImpl <em>Process Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessAllocationConstraint()
	 * @generated
	 */
	int PROCESS_ALLOCATION_CONSTRAINT = 255;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__PROCESS = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeAllocationConstraintImpl <em>Process Prototype Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPrototypeAllocationConstraint()
	 * @generated
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT = 256;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Process Prototype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__PROCESS_PROTOTYPE = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Prototype Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Prototype Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationConstraintImpl <em>Runnable Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableAllocationConstraint()
	 * @generated
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT = 257;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__RUNNABLE = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractElementMappingConstraintImpl <em>Abstract Element Mapping Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractElementMappingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractElementMappingConstraint()
	 * @generated
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT = 258;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES = MEMORY_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Memory Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION = MEMORY_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Abstract Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__ABSTRACT_ELEMENT = MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Element Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT_FEATURE_COUNT = MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Element Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT_OPERATION_COUNT = MEMORY_MAPPING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClassificationImpl <em>Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClassification()
	 * @generated
	 */
	int CLASSIFICATION = 259;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__CONDITION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__GROUPING = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreClassificationImpl <em>Core Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreClassification()
	 * @generated
	 */
	int CORE_CLASSIFICATION = 260;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CUSTOM_PROPERTIES = CLASSIFICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CONDITION = CLASSIFICATION__CONDITION;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__GROUPING = CLASSIFICATION__GROUPING;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CLASSIFIERS = CLASSIFICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Core Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION_FEATURE_COUNT = CLASSIFICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Core Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION_OPERATION_COUNT = CLASSIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryClassificationImpl <em>Memory Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryClassification()
	 * @generated
	 */
	int MEMORY_CLASSIFICATION = 261;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CUSTOM_PROPERTIES = CLASSIFICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CONDITION = CLASSIFICATION__CONDITION;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__GROUPING = CLASSIFICATION__GROUPING;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CLASSIFIERS = CLASSIFICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Memory Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION_FEATURE_COUNT = CLASSIFICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Memory Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION_OPERATION_COUNT = CLASSIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimuliModelImpl <em>Stimuli Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimuliModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimuliModel()
	 * @generated
	 */
	int STIMULI_MODEL = 262;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__STIMULI = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clocks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__CLOCKS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Stimuli Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Stimuli Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimulusImpl <em>Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimulus()
	 * @generated
	 */
	int STIMULUS = 263;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__SET_MODE_VALUE_LIST = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__EXECUTION_CONDITION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__AFFECTED_PROCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueListImpl <em>Mode Value List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueListImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueList()
	 * @generated
	 */
	int MODE_VALUE_LIST = 264;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST__ENTRIES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Value List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Value List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueMapEntryImpl <em>Mode Value Map Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueMapEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueMapEntry()
	 * @generated
	 */
	int MODE_VALUE_MAP_ENTRY = 265;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Mode Value Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Mode Value Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueImpl <em>Mode Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValue()
	 * @generated
	 */
	int MODE_VALUE = 266;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__LABEL = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__VALUE = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Mode Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE___GET_LITERAL = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Integer</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE___GET_INTEGER = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Mode Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeAssignmentImpl <em>Mode Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeAssignmentImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeAssignment()
	 * @generated
	 */
	int MODE_ASSIGNMENT = 267;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT__CUSTOM_PROPERTIES = MODE_VALUE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT__LABEL = MODE_VALUE__LABEL;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT__VALUE = MODE_VALUE__VALUE;

	/**
	 * The number of structural features of the '<em>Mode Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT_FEATURE_COUNT = MODE_VALUE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = MODE_VALUE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT___GET_LITERAL = MODE_VALUE___GET_LITERAL;

	/**
	 * The operation id for the '<em>Get Integer</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT___GET_INTEGER = MODE_VALUE___GET_INTEGER;

	/**
	 * The number of operations of the '<em>Mode Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_ASSIGNMENT_OPERATION_COUNT = MODE_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeConditionDisjunctionImpl <em>Mode Condition Disjunction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeConditionDisjunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeConditionDisjunction()
	 * @generated
	 */
	int MODE_CONDITION_DISJUNCTION = 268;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION__ENTRIES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Condition Disjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION___IS_SATISFIED_BY__EMAP = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Condition Disjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ModeConditionDisjunctionEntry <em>Mode Condition Disjunction Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ModeConditionDisjunctionEntry
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeConditionDisjunctionEntry()
	 * @generated
	 */
	int MODE_CONDITION_DISJUNCTION_ENTRY = 269;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Mode Condition Disjunction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_ENTRY___IS_SATISFIED_BY__EMAP = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Condition Disjunction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_DISJUNCTION_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ModeCondition <em>Mode Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ModeCondition
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeCondition()
	 * @generated
	 */
	int MODE_CONDITION = 270;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION__CUSTOM_PROPERTIES = MODE_CONDITION_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION__RELATION = MODE_CONDITION_DISJUNCTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_FEATURE_COUNT = MODE_CONDITION_DISJUNCTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION___IS_SATISFIED_BY__EMAP = MODE_CONDITION_DISJUNCTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_OPERATION_COUNT = MODE_CONDITION_DISJUNCTION_ENTRY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueConditionImpl <em>Mode Value Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueConditionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueCondition()
	 * @generated
	 */
	int MODE_VALUE_CONDITION = 271;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION__CUSTOM_PROPERTIES = MODE_VALUE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION__LABEL = MODE_VALUE__LABEL;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION__VALUE = MODE_VALUE__VALUE;

	/**
	 * The feature id for the '<em><b>Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION__RELATION = MODE_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Value Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION_FEATURE_COUNT = MODE_VALUE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = MODE_VALUE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION___GET_LITERAL = MODE_VALUE___GET_LITERAL;

	/**
	 * The operation id for the '<em>Get Integer</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION___GET_INTEGER = MODE_VALUE___GET_INTEGER;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION___IS_SATISFIED_BY__EMAP = MODE_VALUE_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Mode Value Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONDITION_OPERATION_COUNT = MODE_VALUE_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLabelConditionImpl <em>Mode Label Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLabelConditionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLabelCondition()
	 * @generated
	 */
	int MODE_LABEL_CONDITION = 272;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION__CUSTOM_PROPERTIES = MODE_CONDITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION__RELATION = MODE_CONDITION__RELATION;

	/**
	 * The feature id for the '<em><b>Label1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION__LABEL1 = MODE_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION__LABEL2 = MODE_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Mode Label Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION_FEATURE_COUNT = MODE_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION___IS_SATISFIED_BY__EMAP = MODE_CONDITION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Label Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_CONDITION_OPERATION_COUNT = MODE_CONDITION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeConditionConjunctionImpl <em>Mode Condition Conjunction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeConditionConjunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeConditionConjunction()
	 * @generated
	 */
	int MODE_CONDITION_CONJUNCTION = 273;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_CONJUNCTION__CUSTOM_PROPERTIES = MODE_CONDITION_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_CONJUNCTION__ENTRIES = MODE_CONDITION_DISJUNCTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Condition Conjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_CONJUNCTION_FEATURE_COUNT = MODE_CONDITION_DISJUNCTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_CONJUNCTION___IS_SATISFIED_BY__EMAP = MODE_CONDITION_DISJUNCTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Condition Conjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_CONDITION_CONJUNCTION_OPERATION_COUNT = MODE_CONDITION_DISJUNCTION_ENTRY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.FixedPeriodic <em>Fixed Periodic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.FixedPeriodic
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPeriodic()
	 * @generated
	 */
	int FIXED_PERIODIC = 274;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC__RECURRENCE = 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC__OFFSET = 1;

	/**
	 * The number of structural features of the '<em>Fixed Periodic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Fixed Periodic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicStimulusImpl <em>Periodic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicStimulus()
	 * @generated
	 */
	int PERIODIC_STIMULUS = 275;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Jitter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__JITTER = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Min Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__MIN_DISTANCE = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RelativePeriodicStimulusImpl <em>Relative Periodic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RelativePeriodicStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRelativePeriodicStimulus()
	 * @generated
	 */
	int RELATIVE_PERIODIC_STIMULUS = 276;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Next Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__NEXT_OCCURRENCE = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Relative Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Relative Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VariableRateStimulusImpl <em>Variable Rate Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VariableRateStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVariableRateStimulus()
	 * @generated
	 */
	int VARIABLE_RATE_STIMULUS = 277;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__STEP = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Occurrences Per Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__OCCURRENCES_PER_STEP = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Increase Per Step</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__MAX_INCREASE_PER_STEP = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Decrease Per Step</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__MAX_DECREASE_PER_STEP = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Scenario</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__SCENARIO = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Variable Rate Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Variable Rate Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ScenarioImpl <em>Scenario</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ScenarioImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getScenario()
	 * @generated
	 */
	int SCENARIO = 278;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Clock</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__CLOCK = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sampling Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__SAMPLING_OFFSET = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sampling Recurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__SAMPLING_RECURRENCE = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Scenario</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Scenario</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicSyntheticStimulusImpl <em>Periodic Synthetic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicSyntheticStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicSyntheticStimulus()
	 * @generated
	 */
	int PERIODIC_SYNTHETIC_STIMULUS = 279;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Occurrence Times</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__OCCURRENCE_TIMES = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Periodic Synthetic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Periodic Synthetic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomStimulusImpl <em>Custom Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomStimulus()
	 * @generated
	 */
	int CUSTOM_STIMULUS = 280;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__DESCRIPTION = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Custom Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SingleStimulusImpl <em>Single Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SingleStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSingleStimulus()
	 * @generated
	 */
	int SINGLE_STIMULUS = 281;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__OCCURRENCE = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Single Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterProcessStimulusImpl <em>Inter Process Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterProcessStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterProcessStimulus()
	 * @generated
	 */
	int INTER_PROCESS_STIMULUS = 282;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__COUNTER = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit Triggers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__EXPLICIT_TRIGGERS = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Inter Process Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Inter Process Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicBurstStimulusImpl <em>Periodic Burst Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicBurstStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicBurstStimulus()
	 * @generated
	 */
	int PERIODIC_BURST_STIMULUS = 283;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Burst Length</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__BURST_LENGTH = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Occurrence Min Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OCCURRENCE_MIN_DISTANCE = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Occurrence Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OCCURRENCE_COUNT = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Periodic Burst Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Periodic Burst Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventStimulusImpl <em>Event Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventStimulus()
	 * @generated
	 */
	int EVENT_STIMULUS = 284;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Triggering Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__TRIGGERING_EVENTS = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__COUNTER = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Event Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveStimulusImpl <em>Arrival Curve Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArrivalCurveStimulus()
	 * @generated
	 */
	int ARRIVAL_CURVE_STIMULUS = 285;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__QUALIFIED_NAME = STIMULUS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__EXECUTION_CONDITION = STIMULUS__EXECUTION_CONDITION;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__ENTRIES = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Arrival Curve Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_NAMED_CONTAINER = STIMULUS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_NAME_PREFIX = STIMULUS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_QUALIFIED_NAME_SEGMENTS = STIMULUS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_DEFAULT_NAME_SEPARATOR = STIMULUS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_NAMESPACE = STIMULUS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_NAME_PREFIX_SEGMENTS = STIMULUS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___GET_ENCODED_QUALIFIED_NAME = STIMULUS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = STIMULUS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Arrival Curve Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveEntryImpl <em>Arrival Curve Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArrivalCurveEntry()
	 * @generated
	 */
	int ARRIVAL_CURVE_ENTRY = 286;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Number Of Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__NUMBER_OF_OCCURRENCES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lower Time Border</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__LOWER_TIME_BORDER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Upper Time Border</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__UPPER_TIME_BORDER = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Arrival Curve Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Arrival Curve Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockImpl <em>Clock</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClock()
	 * @generated
	 */
	int CLOCK = 287;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockFunctionImpl <em>Clock Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockFunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockFunction()
	 * @generated
	 */
	int CLOCK_FUNCTION = 288;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__CUSTOM_PROPERTIES = CLOCK__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__NAME = CLOCK__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__QUALIFIED_NAME = CLOCK__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__UNIQUE_NAME = CLOCK__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__CURVE_TYPE = CLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__PERIOD = CLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Peak To Peak</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__PEAK_TO_PEAK = CLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>XOffset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__XOFFSET = CLOCK_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>YOffset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION__YOFFSET = CLOCK_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Clock Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION_FEATURE_COUNT = CLOCK_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_NAMED_CONTAINER = CLOCK___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_NAME_PREFIX = CLOCK___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_QUALIFIED_NAME_SEGMENTS = CLOCK___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_DEFAULT_NAME_SEPARATOR = CLOCK___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_NAMESPACE = CLOCK___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_NAME_PREFIX_SEGMENTS = CLOCK___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___GET_ENCODED_QUALIFIED_NAME = CLOCK___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CLOCK___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Clock Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FUNCTION_OPERATION_COUNT = CLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockStepListImpl <em>Clock Step List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockStepListImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockStepList()
	 * @generated
	 */
	int CLOCK_STEP_LIST = 289;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__CUSTOM_PROPERTIES = CLOCK__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__NAME = CLOCK__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__QUALIFIED_NAME = CLOCK__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__UNIQUE_NAME = CLOCK__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__ENTRIES = CLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST__PERIOD = CLOCK_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clock Step List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST_FEATURE_COUNT = CLOCK_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_NAMED_CONTAINER = CLOCK___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_NAME_PREFIX = CLOCK___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_QUALIFIED_NAME_SEGMENTS = CLOCK___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_DEFAULT_NAME_SEPARATOR = CLOCK___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_NAMESPACE = CLOCK___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_NAME_PREFIX_SEGMENTS = CLOCK___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___GET_ENCODED_QUALIFIED_NAME = CLOCK___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = CLOCK___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Clock Step List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_LIST_OPERATION_COUNT = CLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockStepImpl <em>Clock Step</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockStepImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockStep()
	 * @generated
	 */
	int CLOCK_STEP = 290;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Frequency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP__FREQUENCY = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP__TIME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clock Step</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Clock Step</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_STEP_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SWModelImpl <em>SW Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SWModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSWModel()
	 * @generated
	 */
	int SW_MODEL = 291;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Isrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__ISRS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tasks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__TASKS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__RUNNABLES = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__LABELS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Channels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CHANNELS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Process Prototypes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__PROCESS_PROTOTYPES = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Sections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__SECTIONS = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Activations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__ACTIVATIONS = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__EVENTS = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Definitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__TYPE_DEFINITIONS = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Custom Entities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CUSTOM_ENTITIES = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Process Chains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__PROCESS_CHAINS = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Modes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__MODES = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mode Labels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__MODE_LABELS = BASE_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>SW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The operation id for the '<em>Mode Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL___MODE_LITERAL__STRING_STRING = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>SW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractMemoryElementImpl <em>Abstract Memory Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractMemoryElementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractMemoryElement()
	 * @generated
	 */
	int ABSTRACT_MEMORY_ELEMENT = 292;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__SIZE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__MAPPINGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Memory Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Abstract Memory Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractProcessImpl <em>Abstract Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractProcess()
	 * @generated
	 */
	int ABSTRACT_PROCESS = 293;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Abstract Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomEntityImpl <em>Custom Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomEntityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomEntity()
	 * @generated
	 */
	int CUSTOM_ENTITY = 294;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__DESCRIPTION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__TYPE_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Custom Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Custom Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainImpl <em>Process Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChain()
	 * @generated
	 */
	int PROCESS_CHAIN = 295;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__PROCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessImpl <em>Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcess()
	 * @generated
	 */
	int PROCESS = 296;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CUSTOM_PROPERTIES = ABSTRACT_PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__NAME = ABSTRACT_PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__QUALIFIED_NAME = ABSTRACT_PROCESS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__UNIQUE_NAME = ABSTRACT_PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__TAGS = ABSTRACT_PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__SIZE = ABSTRACT_PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__MAPPINGS = ABSTRACT_PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__REFERRING_COMPONENTS = ABSTRACT_PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Activity Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__ACTIVITY_GRAPH = ABSTRACT_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__STIMULI = ABSTRACT_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_FEATURE_COUNT = ABSTRACT_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_NAMED_CONTAINER = ABSTRACT_PROCESS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_NAME_PREFIX = ABSTRACT_PROCESS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_PROCESS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_PROCESS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_NAMESPACE = ABSTRACT_PROCESS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_PROCESS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_PROCESS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_OPERATION_COUNT = ABSTRACT_PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer <em>IActivity Graph Item Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIActivityGraphItemContainer()
	 * @generated
	 */
	int IACTIVITY_GRAPH_ITEM_CONTAINER = 297;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH_ITEM_CONTAINER__ITEMS = 0;

	/**
	 * The number of structural features of the '<em>IActivity Graph Item Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH_ITEM_CONTAINER_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IActivity Graph Item Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH_ITEM_CONTAINER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ActivityGraphImpl <em>Activity Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ActivityGraphImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getActivityGraph()
	 * @generated
	 */
	int ACTIVITY_GRAPH = 298;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH__ITEMS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Activity Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Activity Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ActivityGraphItemImpl <em>Activity Graph Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ActivityGraphItemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getActivityGraphItem()
	 * @generated
	 */
	int ACTIVITY_GRAPH_ITEM = 299;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Activity Graph Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Activity Graph Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_GRAPH_ITEM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchImpl <em>Mode Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitch()
	 * @generated
	 */
	int MODE_SWITCH = 300;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__ENTRIES = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Default Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__DEFAULT_ENTRY = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchEntryImpl <em>Mode Switch Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitchEntry()
	 * @generated
	 */
	int MODE_SWITCH_ENTRY = 301;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__QUALIFIED_NAME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__ITEMS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__CONDITION = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Mode Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_NAMED_CONTAINER = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_NAME_PREFIX = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_QUALIFIED_NAME_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_DEFAULT_NAME_SEPARATOR = BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_NAMESPACE = BASE_OBJECT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY___GET_NAME_PREFIX_SEGMENTS = BASE_OBJECT_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Mode Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchDefaultImpl <em>Mode Switch Default</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchDefaultImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitchDefault()
	 * @generated
	 */
	int MODE_SWITCH_DEFAULT = 302;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT__ITEMS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Switch Default</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Switch Default</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchImpl <em>Probability Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProbabilitySwitch()
	 * @generated
	 */
	int PROBABILITY_SWITCH = 303;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__ENTRIES = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchEntryImpl <em>Probability Switch Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProbabilitySwitchEntry()
	 * @generated
	 */
	int PROBABILITY_SWITCH_ENTRY = 304;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__ITEMS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Probability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__PROBABILITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Probability Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Probability Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CounterImpl <em>Counter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CounterImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCounter()
	 * @generated
	 */
	int COUNTER = 305;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Prescaler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__PRESCALER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__OFFSET = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Counter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Counter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.WaitEventImpl <em>Wait Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.WaitEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getWaitEvent()
	 * @generated
	 */
	int WAIT_EVENT = 306;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__EVENT_MASK = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mask Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__MASK_TYPE = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__WAITING_BEHAVIOUR = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__COUNTER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Wait Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Wait Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SetEventImpl <em>Set Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SetEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSetEvent()
	 * @generated
	 */
	int SET_EVENT = 307;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__EVENT_MASK = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__PROCESS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__COUNTER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Set Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Set Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClearEventImpl <em>Clear Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClearEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClearEvent()
	 * @generated
	 */
	int CLEAR_EVENT = 308;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__EVENT_MASK = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__COUNTER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clear Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Clear Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventMaskImpl <em>Event Mask</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventMaskImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventMask()
	 * @generated
	 */
	int EVENT_MASK = 309;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK__EVENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Mask</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Mask</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsEventImpl <em>Os Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsEvent()
	 * @generated
	 */
	int OS_EVENT = 310;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Communication Overhead In Bit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__COMMUNICATION_OVERHEAD_IN_BIT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__REFERRING_COMPONENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Os Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterProcessTriggerImpl <em>Inter Process Trigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterProcessTriggerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterProcessTrigger()
	 * @generated
	 */
	int INTER_PROCESS_TRIGGER = 311;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__STIMULUS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__COUNTER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Inter Process Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Inter Process Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EnforcedMigrationImpl <em>Enforced Migration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EnforcedMigrationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEnforcedMigration()
	 * @generated
	 */
	int ENFORCED_MIGRATION = 312;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Resource Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__RESOURCE_OWNER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enforced Migration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Enforced Migration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulePointImpl <em>Schedule Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulePointImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulePoint()
	 * @generated
	 */
	int SCHEDULE_POINT = 313;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The number of structural features of the '<em>Schedule Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Schedule Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TerminateProcessImpl <em>Terminate Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TerminateProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTerminateProcess()
	 * @generated
	 */
	int TERMINATE_PROCESS = 314;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__COUNTER = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Terminate Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Terminate Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskImpl <em>Task</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTask()
	 * @generated
	 */
	int TASK = 315;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__CUSTOM_PROPERTIES = PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__NAME = PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__QUALIFIED_NAME = PROCESS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__UNIQUE_NAME = PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__TAGS = PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__SIZE = PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__MAPPINGS = PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__REFERRING_COMPONENTS = PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Activity Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__ACTIVITY_GRAPH = PROCESS__ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__STIMULI = PROCESS__STIMULI;

	/**
	 * The feature id for the '<em><b>Preemption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__PREEMPTION = PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiple Task Activation Limit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__MULTIPLE_TASK_ACTIVATION_LIMIT = PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Task</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_FEATURE_COUNT = PROCESS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_NAMED_CONTAINER = PROCESS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_NAME_PREFIX = PROCESS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_QUALIFIED_NAME_SEGMENTS = PROCESS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_DEFAULT_NAME_SEPARATOR = PROCESS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_NAMESPACE = PROCESS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_NAME_PREFIX_SEGMENTS = PROCESS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___GET_ENCODED_QUALIFIED_NAME = PROCESS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Task</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_OPERATION_COUNT = PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ISRImpl <em>ISR</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ISRImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISR()
	 * @generated
	 */
	int ISR = 316;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__CUSTOM_PROPERTIES = PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__NAME = PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__QUALIFIED_NAME = PROCESS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__UNIQUE_NAME = PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__TAGS = PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__SIZE = PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__MAPPINGS = PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__REFERRING_COMPONENTS = PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Activity Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__ACTIVITY_GRAPH = PROCESS__ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__STIMULI = PROCESS__STIMULI;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__CATEGORY = PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>ISR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_FEATURE_COUNT = PROCESS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_NAMED_CONTAINER = PROCESS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_NAME_PREFIX = PROCESS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_QUALIFIED_NAME_SEGMENTS = PROCESS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_DEFAULT_NAME_SEPARATOR = PROCESS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_NAMESPACE = PROCESS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_NAME_PREFIX_SEGMENTS = PROCESS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___GET_ENCODED_QUALIFIED_NAME = PROCESS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>ISR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_OPERATION_COUNT = PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeImpl <em>Process Prototype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPrototype()
	 * @generated
	 */
	int PROCESS_PROTOTYPE = 317;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__CUSTOM_PROPERTIES = ABSTRACT_PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__NAME = ABSTRACT_PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__QUALIFIED_NAME = ABSTRACT_PROCESS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__UNIQUE_NAME = ABSTRACT_PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__TAGS = ABSTRACT_PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__SIZE = ABSTRACT_PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__MAPPINGS = ABSTRACT_PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__REFERRING_COMPONENTS = ABSTRACT_PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Preemption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__PREEMPTION = ABSTRACT_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>First Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__FIRST_RUNNABLE = ABSTRACT_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__LAST_RUNNABLE = ABSTRACT_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Access Precedence Spec</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ACCESS_PRECEDENCE_SPEC = ABSTRACT_PROCESS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Order Precedence Spec</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ORDER_PRECEDENCE_SPEC = ABSTRACT_PROCESS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Chained Prototypes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__CHAINED_PROTOTYPES = ABSTRACT_PROCESS_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Activation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ACTIVATION = ABSTRACT_PROCESS_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Runnable Calls</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__RUNNABLE_CALLS = ABSTRACT_PROCESS_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_FEATURE_COUNT = ABSTRACT_PROCESS_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_NAMED_CONTAINER = ABSTRACT_PROCESS___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_NAME_PREFIX = ABSTRACT_PROCESS___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_PROCESS___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_PROCESS___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_NAMESPACE = ABSTRACT_PROCESS___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_PROCESS___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_PROCESS___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_PROCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_OPERATION_COUNT = ABSTRACT_PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChainedProcessPrototypeImpl <em>Chained Process Prototype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChainedProcessPrototypeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChainedProcessPrototype()
	 * @generated
	 */
	int CHAINED_PROCESS_PROTOTYPE = 318;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Prototype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__PROTOTYPE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Apply</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__APPLY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__OFFSET = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Chained Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Chained Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GeneralPrecedenceImpl <em>General Precedence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GeneralPrecedenceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGeneralPrecedence()
	 * @generated
	 */
	int GENERAL_PRECEDENCE = 319;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__ORIGIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__TARGET = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>General Precedence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>General Precedence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AccessPrecedenceSpecImpl <em>Access Precedence Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AccessPrecedenceSpecImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAccessPrecedenceSpec()
	 * @generated
	 */
	int ACCESS_PRECEDENCE_SPEC = 320;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__CUSTOM_PROPERTIES = GENERAL_PRECEDENCE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__ORIGIN = GENERAL_PRECEDENCE__ORIGIN;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__TARGET = GENERAL_PRECEDENCE__TARGET;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__LABEL = GENERAL_PRECEDENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__ORDER_TYPE = GENERAL_PRECEDENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Access Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC_FEATURE_COUNT = GENERAL_PRECEDENCE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Access Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC_OPERATION_COUNT = GENERAL_PRECEDENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OrderPrecedenceSpecImpl <em>Order Precedence Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OrderPrecedenceSpecImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOrderPrecedenceSpec()
	 * @generated
	 */
	int ORDER_PRECEDENCE_SPEC = 321;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__CUSTOM_PROPERTIES = GENERAL_PRECEDENCE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__ORIGIN = GENERAL_PRECEDENCE__ORIGIN;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__TARGET = GENERAL_PRECEDENCE__TARGET;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__ORDER_TYPE = GENERAL_PRECEDENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Order Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC_FEATURE_COUNT = GENERAL_PRECEDENCE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Order Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC_OPERATION_COUNT = GENERAL_PRECEDENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDependsOn <em>IDepends On</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDependsOn
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDependsOn()
	 * @generated
	 */
	int IDEPENDS_ON = 322;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDS_ON__DEPENDS_ON = 0;

	/**
	 * The number of structural features of the '<em>IDepends On</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDS_ON_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IDepends On</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDS_ON_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataDependencyImpl <em>Data Dependency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataDependencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataDependency()
	 * @generated
	 */
	int DATA_DEPENDENCY = 323;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__LABELS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__PARAMETERS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Call Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CALL_ARGUMENTS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CONTAINING_RUNNABLE = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Data Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Data Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableParameterImpl <em>Runnable Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableParameterImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableParameter()
	 * @generated
	 */
	int RUNNABLE_PARAMETER = 324;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DEPENDS_ON = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__CONTAINING_RUNNABLE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DIRECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DATA_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Runnable Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableImpl <em>Runnable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnable()
	 * @generated
	 */
	int RUNNABLE = 325;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__NAMESPACE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Execution Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__EXECUTION_CONDITION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__PARAMETERS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Activity Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__ACTIVITY_GRAPH = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Activations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__ACTIVATIONS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Callback</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__CALLBACK = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SERVICE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Asil Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__ASIL_LEVEL = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SECTION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Runnable Calls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__RUNNABLE_CALLS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Runnable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Get Runnable Items</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_RUNNABLE_ITEMS = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get First Activation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_FIRST_ACTIVATION = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelImpl <em>Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabel()
	 * @generated
	 */
	int LABEL = 326;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__NAMESPACE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DATA_TYPE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__CONSTANT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>BVolatile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__BVOLATILE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DATA_STABILITY = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stability Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__STABILITY_LEVEL = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__SECTION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Label Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__LABEL_ACCESSES = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelImpl <em>Channel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannel()
	 * @generated
	 */
	int CHANNEL = 327;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__NAMESPACE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__ELEMENT_TYPE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__DEFAULT_ELEMENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__MAX_ELEMENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Channel Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__CHANNEL_ACCESSES = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLabelImpl <em>Mode Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLabelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLabel()
	 * @generated
	 */
	int MODE_LABEL = 328;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__MODE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Initial Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__INITIAL_VALUE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Mode Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_NAMED_CONTAINER = ABSTRACT_MEMORY_ELEMENT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_NAME_PREFIX = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_QUALIFIED_NAME_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_DEFAULT_NAME_SEPARATOR = ABSTRACT_MEMORY_ELEMENT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_NAMESPACE = ABSTRACT_MEMORY_ELEMENT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_NAME_PREFIX_SEGMENTS = ABSTRACT_MEMORY_ELEMENT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___GET_ENCODED_QUALIFIED_NAME = ABSTRACT_MEMORY_ELEMENT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Enum</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___IS_ENUM = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Numeric</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___IS_NUMERIC = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Mode Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SectionImpl <em>Section</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SectionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSection()
	 * @generated
	 */
	int SECTION = 329;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__QUALIFIED_NAME = REFERABLE_BASE_OBJECT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Asil Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__ASIL_LEVEL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__RUNNABLES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get Named Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_NAMED_CONTAINER = REFERABLE_BASE_OBJECT___GET_NAMED_CONTAINER;

	/**
	 * The operation id for the '<em>Get Name Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_NAME_PREFIX = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX;

	/**
	 * The operation id for the '<em>Get Qualified Name Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_QUALIFIED_NAME_SEGMENTS = REFERABLE_BASE_OBJECT___GET_QUALIFIED_NAME_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Default Name Separator</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_DEFAULT_NAME_SEPARATOR = REFERABLE_BASE_OBJECT___GET_DEFAULT_NAME_SEPARATOR;

	/**
	 * The operation id for the '<em>Get Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_NAMESPACE = REFERABLE_BASE_OBJECT___GET_NAMESPACE;

	/**
	 * The operation id for the '<em>Get Name Prefix Segments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_NAME_PREFIX_SEGMENTS = REFERABLE_BASE_OBJECT___GET_NAME_PREFIX_SEGMENTS;

	/**
	 * The operation id for the '<em>Get Encoded Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___GET_ENCODED_QUALIFIED_NAME = REFERABLE_BASE_OBJECT___GET_ENCODED_QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = REFERABLE_BASE_OBJECT___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The number of operations of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComputationItemImpl <em>Computation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComputationItemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComputationItem()
	 * @generated
	 */
	int COMPUTATION_ITEM = 330;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The number of structural features of the '<em>Computation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Computation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ExecutionNeedImpl <em>Execution Need</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ExecutionNeedImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getExecutionNeed()
	 * @generated
	 */
	int EXECUTION_NEED = 331;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Needs</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__NEEDS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Execution Need</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Execution Need</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl <em>Need Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNeedEntry()
	 * @generated
	 */
	int NEED_ENTRY = 332;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Need Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Need Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TicksImpl <em>Ticks</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TicksImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTicks()
	 * @generated
	 */
	int TICKS = 333;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CUSTOM_PROPERTIES = COMPUTATION_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CONTAINING_PROCESS = COMPUTATION_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CONTAINING_RUNNABLE = COMPUTATION_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CONTAINING_ACTIVITY_GRAPH = COMPUTATION_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Default</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__DEFAULT = COMPUTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Extended</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__EXTENDED = COMPUTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ticks</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_FEATURE_COUNT = COMPUTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Ticks</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_OPERATION_COUNT = COMPUTATION_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TicksEntryImpl <em>Ticks Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TicksEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTicksEntry()
	 * @generated
	 */
	int TICKS_ENTRY = 334;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Ticks Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Ticks Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLabelAccessImpl <em>Mode Label Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLabelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLabelAccess()
	 * @generated
	 */
	int MODE_LABEL_ACCESS = 335;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__DATA = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__ACCESS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__VALUE = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Step</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__STEP = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Mode Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Validate Invariants</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS___VALIDATE_INVARIANTS__DIAGNOSTICCHAIN_MAP = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelAccessImpl <em>Label Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccess()
	 * @generated
	 */
	int LABEL_ACCESS = 336;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CUSTOM_PROPERTIES = COMPUTATION_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CONTAINING_PROCESS = COMPUTATION_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CONTAINING_RUNNABLE = COMPUTATION_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CONTAINING_ACTIVITY_GRAPH = COMPUTATION_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__TAGS = COMPUTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DEPENDS_ON = COMPUTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DATA = COMPUTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__ACCESS = COMPUTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__STATISTIC = COMPUTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__TRANSMISSION_POLICY = COMPUTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DATA_STABILITY = COMPUTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__IMPLEMENTATION = COMPUTATION_ITEM_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_FEATURE_COUNT = COMPUTATION_ITEM_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_OPERATION_COUNT = COMPUTATION_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelAccessImpl <em>Channel Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelAccess()
	 * @generated
	 */
	int CHANNEL_ACCESS = 337;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__DATA = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__ELEMENTS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__TRANSMISSION_POLICY = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Channel Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Channel Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelSendImpl <em>Channel Send</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelSendImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelSend()
	 * @generated
	 */
	int CHANNEL_SEND = 338;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CUSTOM_PROPERTIES = CHANNEL_ACCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CONTAINING_PROCESS = CHANNEL_ACCESS__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CONTAINING_RUNNABLE = CHANNEL_ACCESS__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CONTAINING_ACTIVITY_GRAPH = CHANNEL_ACCESS__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__DATA = CHANNEL_ACCESS__DATA;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__ELEMENTS = CHANNEL_ACCESS__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__TRANSMISSION_POLICY = CHANNEL_ACCESS__TRANSMISSION_POLICY;

	/**
	 * The number of structural features of the '<em>Channel Send</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND_FEATURE_COUNT = CHANNEL_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Channel Send</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND_OPERATION_COUNT = CHANNEL_ACCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelReceiveImpl <em>Channel Receive</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelReceiveImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelReceive()
	 * @generated
	 */
	int CHANNEL_RECEIVE = 339;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CUSTOM_PROPERTIES = CHANNEL_ACCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CONTAINING_PROCESS = CHANNEL_ACCESS__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CONTAINING_RUNNABLE = CHANNEL_ACCESS__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CONTAINING_ACTIVITY_GRAPH = CHANNEL_ACCESS__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__DATA = CHANNEL_ACCESS__DATA;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__ELEMENTS = CHANNEL_ACCESS__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__TRANSMISSION_POLICY = CHANNEL_ACCESS__TRANSMISSION_POLICY;

	/**
	 * The feature id for the '<em><b>Receive Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__RECEIVE_OPERATION = CHANNEL_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Must Be New</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__DATA_MUST_BE_NEW = CHANNEL_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Element Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__ELEMENT_INDEX = CHANNEL_ACCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__LOWER_BOUND = CHANNEL_ACCESS_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Channel Receive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE_FEATURE_COUNT = CHANNEL_ACCESS_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Channel Receive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE_OPERATION_COUNT = CHANNEL_ACCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreAccessImpl <em>Semaphore Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreAccess()
	 * @generated
	 */
	int SEMAPHORE_ACCESS = 340;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Semaphore</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__SEMAPHORE = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__ACCESS = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__WAITING_BEHAVIOUR = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Semaphore Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Semaphore Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverCommunicationImpl <em>Sender Receiver Communication</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverCommunicationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverCommunication()
	 * @generated
	 */
	int SENDER_RECEIVER_COMMUNICATION = 341;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__BUFFERED = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__LABEL = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__PORT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Sender Receiver Communication</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Sender Receiver Communication</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverReadImpl <em>Sender Receiver Read</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverReadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverRead()
	 * @generated
	 */
	int SENDER_RECEIVER_READ = 342;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CUSTOM_PROPERTIES = SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CONTAINING_PROCESS = SENDER_RECEIVER_COMMUNICATION__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CONTAINING_RUNNABLE = SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CONTAINING_ACTIVITY_GRAPH = SENDER_RECEIVER_COMMUNICATION__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__BUFFERED = SENDER_RECEIVER_COMMUNICATION__BUFFERED;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__LABEL = SENDER_RECEIVER_COMMUNICATION__LABEL;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__PORT = SENDER_RECEIVER_COMMUNICATION__PORT;

	/**
	 * The number of structural features of the '<em>Sender Receiver Read</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ_FEATURE_COUNT = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sender Receiver Read</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ_OPERATION_COUNT = SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverWriteImpl <em>Sender Receiver Write</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverWriteImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverWrite()
	 * @generated
	 */
	int SENDER_RECEIVER_WRITE = 343;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CUSTOM_PROPERTIES = SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CONTAINING_PROCESS = SENDER_RECEIVER_COMMUNICATION__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CONTAINING_RUNNABLE = SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CONTAINING_ACTIVITY_GRAPH = SENDER_RECEIVER_COMMUNICATION__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__BUFFERED = SENDER_RECEIVER_COMMUNICATION__BUFFERED;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__LABEL = SENDER_RECEIVER_COMMUNICATION__LABEL;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__PORT = SENDER_RECEIVER_COMMUNICATION__PORT;

	/**
	 * The feature id for the '<em><b>Notified Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__NOTIFIED_RUNNABLES = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sender Receiver Write</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE_FEATURE_COUNT = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Sender Receiver Write</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE_OPERATION_COUNT = SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ServerCallImpl <em>Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getServerCall()
	 * @generated
	 */
	int SERVER_CALL = 344;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CUSTOM_PROPERTIES = ACTIVITY_GRAPH_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CONTAINING_PROCESS = ACTIVITY_GRAPH_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CONTAINING_RUNNABLE = ACTIVITY_GRAPH_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CONTAINING_ACTIVITY_GRAPH = ACTIVITY_GRAPH_ITEM__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__SERVER_RUNNABLE = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__PORT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL_FEATURE_COUNT = ACTIVITY_GRAPH_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL_OPERATION_COUNT = ACTIVITY_GRAPH_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SynchronousServerCallImpl <em>Synchronous Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SynchronousServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSynchronousServerCall()
	 * @generated
	 */
	int SYNCHRONOUS_SERVER_CALL = 345;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CONTAINING_PROCESS = SERVER_CALL__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CONTAINING_ACTIVITY_GRAPH = SERVER_CALL__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__PORT = SERVER_CALL__PORT;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__WAITING_BEHAVIOUR = SERVER_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Synchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL_FEATURE_COUNT = SERVER_CALL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Synchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL_OPERATION_COUNT = SERVER_CALL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AsynchronousServerCallImpl <em>Asynchronous Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AsynchronousServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAsynchronousServerCall()
	 * @generated
	 */
	int ASYNCHRONOUS_SERVER_CALL = 346;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CONTAINING_PROCESS = SERVER_CALL__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CONTAINING_ACTIVITY_GRAPH = SERVER_CALL__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__PORT = SERVER_CALL__PORT;

	/**
	 * The feature id for the '<em><b>Result Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__RESULT_RUNNABLE = SERVER_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Asynchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL_FEATURE_COUNT = SERVER_CALL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Asynchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL_OPERATION_COUNT = SERVER_CALL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GetResultServerCallImpl <em>Get Result Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GetResultServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGetResultServerCall()
	 * @generated
	 */
	int GET_RESULT_SERVER_CALL = 347;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CONTAINING_PROCESS = SERVER_CALL__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Containing Activity Graph</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CONTAINING_ACTIVITY_GRAPH = SERVER_CALL__CONTAINING_ACTIVITY_GRAPH;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/