/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.ModelVisualization;
import org.eclipse.app4mc.visualization.ui.registry.ModelVisualizationRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VisualizationPart {
    public static final String ID = "org.eclipse.app4mc.visualization.ui.partdescriptor.app4mcvisualizations";
    private static final String LAST_CHOICES_KEY = "LAST_CHOICES";
    private static final String VISUALIZATIONS_KEY = "VISUALIZATIONS";
    private static final String VISUALIZATION_PARAMETERS_KEY = "VISUALIZATION_PARAMETERS";
    @Inject
    @Service
    ModelVisualizationRegistry registry;
    @Inject
    IEclipseContext partContext;
    Composite parentComposite;
    Composite visualizationComposite;
    List<Class<?>> activeTypes;
    List<?> activeModelElements;
    ModelVisualization activeVisualization;
    List<ModelVisualization> availableModelVisualizations;
    IEclipseContext activeContext;
    boolean pinned = false;
    Map<String, String> lastChoices = new HashMap<String, String>();
    Set<String> visualizations = new HashSet<String>();
    Map<String, VisualizationParameters> visualizationsConfiguration = new HashMap<String, VisualizationParameters>();
    private boolean adapterEnabled = true;
    Adapter updateViewAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (VisualizationPart.this.adapterEnabled && VisualizationPart.this.activeVisualization != null) {
                VisualizationPart.this.showVisualization(VisualizationPart.this.activeVisualization.getId());
            }
        }
    };

    @PostConstruct
    public void postConstruct(Composite parent, MPart part, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ISelection selection) {
        String parametersString;
        String visualizationsString;
        String[] keyValue2;
        int n;
        Map state;
        String lastChoicesString;
        this.parentComposite = parent;
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.parentComposite.setBackground(Display.getDefault().getSystemColor(1));
        if (this.visualizationComposite == null) {
            this.visualizationComposite = new Composite(parent, 0);
            this.visualizationComposite.setLayout((Layout)new FillLayout());
            if (selection != null) {
                this.handleSelection(selection);
            } else {
                this.showEmpty(this.visualizationComposite);
            }
        }
        if ((lastChoicesString = (String)(state = part.getPersistedState()).get(LAST_CHOICES_KEY)) != null && lastChoicesString.startsWith("{") && lastChoicesString.endsWith("}")) {
            lastChoicesString = lastChoicesString.substring(1, lastChoicesString.length() - 1);
            String[] stringArray = lastChoicesString.split(",");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                keyValue2 = entry.split("=");
                if (keyValue2.length == 2) {
                    this.lastChoices.put(keyValue2[0].trim(), keyValue2[1].trim());
                }
                ++n2;
            }
        }
        if ((visualizationsString = (String)state.get(VISUALIZATIONS_KEY)) != null && visualizationsString.startsWith("[") && visualizationsString.endsWith("]")) {
            visualizationsString = visualizationsString.substring(1, visualizationsString.length() - 1);
            this.visualizations.clear();
            if (!visualizationsString.trim().isEmpty()) {
                keyValue2 = visualizationsString.split(",");
                int n3 = keyValue2.length;
                n = 0;
                while (n < n3) {
                    String id = keyValue2[n];
                    this.visualizations.add(id.trim());
                    ++n;
                }
            }
        }
        if ((parametersString = (String)state.get(VISUALIZATION_PARAMETERS_KEY)) != null && parametersString.startsWith("{") && parametersString.endsWith("}")) {
            parametersString = parametersString.substring(1, parametersString.length() - 1);
            String[] stringArray = parametersString.split(",");
            int keyValue2 = stringArray.length;
            int n4 = 0;
            while (n4 < keyValue2) {
                String entry = stringArray[n4];
                String[] keyValue3 = entry.split("=");
                if (keyValue3.length == 2) {
                    this.visualizationsConfiguration.put(keyValue3[0].trim(), new VisualizationParameters(keyValue3[1].trim()));
                }
                ++n4;
            }
        }
        for (MToolBarElement element : part.getToolbar().getChildren()) {
            if (!element.getElementId().equals("org.eclipse.app4mc.visualization.ui.directtoolitem.pin")) continue;
            MDirectToolItem toolItem = (MDirectToolItem)element;
            toolItem.setSelected(this.pinned);
        }
    }

    public void showVisualization(String visualizationId) {
        this.showVisualization(visualizationId, false);
    }

    public void showVisualization(String visualizationId, boolean reload) {
        if (this.parentComposite == null || !reload && this.isPinned()) {
            return;
        }
        if (this.visualizationComposite != null) {
            if (this.activeContext != null && this.activeVisualization != null) {
                ContextInjectionFactory.invoke((Object)this.activeVisualization, PreDestroy.class, (IEclipseContext)this.activeContext, null);
                this.activeContext.dispose();
            }
            this.visualizationComposite.dispose();
        }
        this.visualizationComposite = new Composite(this.parentComposite, 0);
        this.visualizationComposite.setLayout((Layout)new FillLayout());
        this.availableModelVisualizations = this.registry.getVisualizations(this.activeTypes);
        this.applyFilterTo(this.availableModelVisualizations);
        this.activeVisualization = this.selectVisualization(visualizationId, this.availableModelVisualizations);
        if (this.activeVisualization == null) {
            this.showEmpty(this.visualizationComposite);
        } else {
            if (this.activeVisualization.getId().equals(visualizationId)) {
                this.lastChoices.put(this.activeTypes.get(0).getName(), visualizationId);
            }
            this.activeContext = this.partContext.createChild(this.activeTypes.get(0) + " Visualization");
            this.activeContext.set(Composite.class, (Object)this.visualizationComposite);
            this.activeContext.set(VisualizationParameters.class, (Object)this.visualizationsConfiguration.computeIfAbsent(this.activeVisualization.getId(), k -> new VisualizationParameters()));
            this.activeContext.set(this.activeVisualization.getType(), this.activeModelElements.get(0));
            this.activeContext.set(List.class, this.activeModelElements);
            ContextInjectionFactory.invoke((Object)this.activeVisualization.getVisualization(), PostConstruct.class, (IEclipseContext)this.activeContext);
            this.parentComposite.layout(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    void handleSelection(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ISelection selection) {
        if (!this.pinned) {
            ISelection iSelection;
            EObject previous = null;
            if (this.activeModelElements != null && this.activeModelElements.size() == 1 && this.activeModelElements.get(0) instanceof EObject) {
                previous = (EObject)this.activeModelElements.get(0);
            }
            if ((iSelection = selection) instanceof TreeSelection) {
                void s;
                TreeSelection treeSelection = (TreeSelection)iSelection;
                TreeSelection cfr_ignored_0 = (TreeSelection)iSelection;
                if (!s.isEmpty()) {
                    Object obj;
                    this.activeModelElements = s.toList();
                    this.activeTypes = this.getNearestCommonTypes(this.activeModelElements);
                    this.availableModelVisualizations = null;
                    if (previous != null) {
                        this.adapterEnabled = false;
                        previous.eAdapters().remove((Object)this.updateViewAdapter);
                    }
                    if (!this.activeTypes.isEmpty() && this.activeModelElements.size() == 1 && (obj = this.activeModelElements.get(0)) instanceof EObject) {
                        void activeObject;
                        EObject eObject = (EObject)obj;
                        EObject cfr_ignored_1 = (EObject)obj;
                        activeObject.eAdapters().add((Object)this.updateViewAdapter);
                        this.adapterEnabled = true;
                    }
                    this.showVisualization(!this.activeTypes.isEmpty() ? this.lastChoices.get(this.activeTypes.get(0).getName()) : null);
                }
            }
        }
    }

    private ModelVisualization selectVisualization(String id, List<ModelVisualization> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (id == null) {
            return list.get(0);
        }
        return list.stream().filter(mv -> mv.getId().equals(id)).findFirst().orElse(list.get(0));
    }

    private List<Class<?>> getNearestCommonTypes(List<?> modelElements) {
        Class<?> typeCandidate;
        if (modelElements.isEmpty()) {
            return Collections.emptyList();
        }
        Class<?> class1 = modelElements.get(0).getClass();
        Class<?>[] interfaces = class1.getInterfaces();
        Class<?> clazz = typeCandidate = interfaces.length > 0 ? interfaces[0] : class1;
        if (modelElements.size() == 1) {
            return Collections.singletonList(typeCandidate);
        }
        boolean sameModelType = modelElements.stream().allMatch(element -> {
            Class<?> elementClass = element.getClass();
            Class<?>[] elementInterfaces = elementClass.getInterfaces();
            return elementInterfaces.length > 0 && elementInterfaces[0].equals(typeCandidate);
        });
        if (sameModelType) {
            return Collections.singletonList(typeCandidate);
        }
        List allInterfaces = ClassUtils.getAllInterfaces(class1);
        String name = class1.getPackage().getName();
        String prefix = name.endsWith(".impl") ? name.substring(0, name.length() - 5) : name;
        allInterfaces.removeIf(i -> !i.equals(EObject.class) && !i.getPackage().getName().startsWith(prefix));
        int i2 = 1;
        while (i2 < modelElements.size()) {
            allInterfaces.retainAll(ClassUtils.getAllInterfaces(modelElements.get(i2).getClass()));
            ++i2;
        }
        ArrayList commonInterfaces = new ArrayList();
        for (Class tmpInterface : allInterfaces) {
            ArrayList otherInterfaces = new ArrayList(allInterfaces);
            otherInterfaces.remove(tmpInterface);
            if (!otherInterfaces.stream().noneMatch(tmpInterface::isAssignableFrom)) continue;
            commonInterfaces.add(tmpInterface);
        }
        return commonInterfaces;
    }

    private void applyFilterTo(List<ModelVisualization> proposedVisualizations) {
        if (this.visualizations.isEmpty()) {
            return;
        }
        proposedVisualizations.removeIf(mv -> !this.visualizations.contains(mv.getId()));
    }

    private void showEmpty(Composite parent) {
        Label label = new Label(parent, 0);
        if (this.hasActiveModelElement()) {
            StringBuilder sb = new StringBuilder("There is no visualization available for the active selection.");
            if (this.activeTypes.isEmpty()) {
                sb.append("\n\n - no common types detected - ");
            } else {
                sb.append("\n\ndetected ");
                sb.append(this.activeModelElements.size() == 1 ? "" : "common ");
                sb.append(this.activeTypes.size() == 1 ? "type:" : "types:");
                this.activeTypes.forEach(t -> {
                    StringBuilder stringBuilder2 = sb.append("\n - " + t.getSimpleName());
                });
            }
            label.setText(sb.toString());
        } else {
            label.setText("There is no active selection.");
        }
        parent.getParent().layout(true);
    }

    @PreDestroy
    public void preDestroy() {
        if (this.visualizationComposite != null) {
            this.visualizationComposite.dispose();
        }
        if (this.activeContext != null) {
            this.activeContext.dispose();
        }
    }

    public List<Class<?>> getActiveModelTypes() {
        return this.activeTypes;
    }

    public List<?> getActiveModelElements() {
        return this.activeModelElements;
    }

    public boolean hasActiveModelElement() {
        return this.activeModelElements != null && !this.activeModelElements.isEmpty();
    }

    public ModelVisualization getActiveVisualization() {
        return this.activeVisualization;
    }

    public List<ModelVisualization> getAvailableModelVisualizations() {
        return this.availableModelVisualizations != null ? this.availableModelVisualizations : Collections.emptyList();
    }

    public Map<String, String> getLastChoices() {
        return this.lastChoices;
    }

    public Set<String> getVisualizations() {
        return this.visualizations;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @PersistState
    public void persistState(MPart part) {
        Map state = part.getPersistedState();
        state.put(LAST_CHOICES_KEY, this.lastChoices.toString());
        state.put(VISUALIZATIONS_KEY, this.visualizations.toString());
        this.visualizationsConfiguration.values().removeIf(VisualizationParameters::isEmpty);
        state.put(VISUALIZATION_PARAMETERS_KEY, this.visualizationsConfiguration.toString());
    }
}

