/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.os;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-OS-PU-Allocation-MustBeDisjunct", checks={"OS Scheduler to core mapping must be distinct"})
public class InchronOsPUAllocationMustBeDisjunct
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getOperatingSystem();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof OperatingSystem) {
            void os;
            OperatingSystem operatingSystem = (OperatingSystem)eObject2;
            OperatingSystem cfr_ignored_0 = (OperatingSystem)eObject2;
            EObject obj = os.eContainer();
            HashSet setPUOtherOS = new HashSet();
            EObject eObject3 = obj;
            if (eObject3 instanceof OSModel) {
                void osMod;
                OSModel oSModel = (OSModel)eObject3;
                OSModel cfr_ignored_1 = (OSModel)eObject3;
                EList listOS = osMod.getOperatingSystems();
                for (OperatingSystem osEntry : listOS) {
                    if (osEntry.equals(os)) continue;
                    Iterator listSched = osEntry.getTaskSchedulers();
                    Iterator iterator = listSched.iterator();
                    while (iterator.hasNext()) {
                        TaskScheduler sched = (TaskScheduler)iterator.next();
                        EList listSchedAlloc = sched.getSchedulerAllocations();
                        for (SchedulerAllocation schedAlloc : listSchedAlloc) {
                            EList listPU = schedAlloc.getResponsibility();
                            setPUOtherOS.addAll(listPU);
                        }
                    }
                }
            }
            HashSet setPU = new HashSet();
            EList listSched = os.getTaskSchedulers();
            for (TaskScheduler sched : listSched) {
                EList listSchedAlloc = sched.getSchedulerAllocations();
                for (SchedulerAllocation schedAlloc : listSchedAlloc) {
                    EList listPU = schedAlloc.getResponsibility();
                    setPU.addAll(listPU);
                }
            }
            boolean checkAllocation = false;
            ArrayList<String> ar = new ArrayList<String>();
            for (ProcessingUnit core : setPU) {
                if (!setPUOtherOS.contains(core)) continue;
                checkAllocation = true;
                ar.add(core.getName());
            }
            if (checkAllocation) {
                Collections.sort(ar);
                String str = String.join((CharSequence)",", ar);
                this.addIssue(results, (EObject)os, null, "Operating system " + this.name((INamed)os) + " consists of task schedulers allocated to processing units: " + str + " referenced by other operating systems");
            }
        }
    }
}

