/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetBasedResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions.IContextAware {
    private ResourceSet resourceSet;
    @Inject
    private IResourceServiceProvider.Registry registry;

    public void setRegistry(IResourceServiceProvider.Registry registry) {
        this.registry = registry;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)this.resourceSet.getResources(), (Function)new Function<Resource, IResourceDescription>(){

            public IResourceDescription apply(Resource from) {
                return ResourceSetBasedResourceDescriptions.this.getResourceDescription(from.getURI());
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.getAllResourceDescriptions();
    }

    @Override
    public boolean isEmpty() {
        return this.resourceSet.getResources().isEmpty();
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, false);
        if (resource == null) {
            return null;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        if (manager == null) {
            return null;
        }
        return manager.getResourceDescription(resource);
    }

    @Override
    public void setContext(Notifier ctx) {
        this.resourceSet = EcoreUtil2.getResourceSet(ctx);
    }
}

