/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.mwe.ContainersStateFactory;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.mwe.ResourceDescriptionsProvider;
import org.eclipse.xtext.mwe.UriFilter;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.containers.DelegatingIAllContainerAdapter;
import org.eclipse.xtext.resource.containers.IAllContainersState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeResourceSetInitializer {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private ResourceDescriptionsProvider provider;
    @Inject
    private ContainersStateFactory factory;
    @Inject
    private PathTraverser traverser;
    @Inject
    private IResourceServiceProvider.Registry registry;

    public List<String> getClassPathEntries() {
        String[] strings;
        ArrayList pathes = Lists.newArrayList();
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String[] stringArray = strings = classPath.split(separator);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            pathes.add(path);
            ++n2;
        }
        return pathes;
    }

    protected Multimap<String, URI> getPathToUriMap(List<String> pathes) {
        return this.getPathToUriMap(pathes, null);
    }

    protected Multimap<String, URI> getPathToUriMap(List<String> pathes, final UriFilter filter) {
        return this.traverser.resolvePathes(pathes, new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean result = true;
                if (filter != null) {
                    result = filter.matches(input);
                }
                if (result) {
                    result = RuntimeResourceSetInitializer.this.registry.getResourceServiceProvider(input) != null;
                }
                return result;
            }
        });
    }

    public ResourceSet getInitializedResourceSet(List<String> pathes) {
        return this.getInitializedResourceSet(pathes, null);
    }

    public ResourceSet getInitializedResourceSet(List<String> pathes, UriFilter filter) {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Multimap<String, URI> pathToUriMap = this.getPathToUriMap(pathes, filter);
        IAllContainersState containersState = this.factory.getContainersState(pathes, pathToUriMap);
        resourceSet.eAdapters().add((Object)new DelegatingIAllContainerAdapter(containersState));
        for (URI uri : pathToUriMap.values()) {
            resourceSet.createResource(uri);
        }
        return resourceSet;
    }

    public IResourceDescriptions getDescriptions(ResourceSet resourceSet) {
        return this.provider.get(resourceSet);
    }
}

