/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadWriteAcces<P>
implements IReadAccess<P> {
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();

    protected abstract P getState();

    @Override
    public <T> T readOnly(IUnitOfWork<T, P> work) {
        this.readLock.lock();
        try {
            P state = this.getState();
            this.beforeReadOnly(state, work);
            T exec = work.exec(state);
            this.afterReadOnly(state, exec, work);
            T t = exec;
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T modify(IUnitOfWork<T, P> work) {
        this.writeLock.lock();
        try {
            P state = this.getState();
            this.beforeModify(state, work);
            T exec = work.exec(state);
            this.afterModify(state, exec, work);
            T t = exec;
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void beforeModify(P state, IUnitOfWork<?, P> work) {
    }

    protected void beforeReadOnly(P state, IUnitOfWork<?, P> work) {
    }

    protected void afterModify(P state, Object result, IUnitOfWork<?, P> work) {
    }

    protected void afterReadOnly(P state, Object result, IUnitOfWork<?, P> work) {
    }
}

