/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.IRenameProcessorAdapter;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.ui.AbstractLinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.ReplaceEditExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictLinkedPositionGroupCalculator
extends AbstractLinkedPositionGroupCalculator {
    @Inject
    private ReplaceEditExtractor replaceEditExtractor;
    @Inject
    private IRenameProcessorAdapter.Factory renameProcessorAdapterFactory;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    private Logger log = Logger.getLogger(StrictLinkedPositionGroupCalculator.class);

    protected ProcessorBasedRefactoring createRenameRefactoring(IRenameElementContext renameElementContext) {
        IRenameRefactoringProvider renameRefactoringProvider = (IRenameRefactoringProvider)this.globalServiceProvider.findService(renameElementContext.getTargetElementURI(), IRenameRefactoringProvider.class);
        return renameRefactoringProvider.getRenameRefactoring(renameElementContext);
    }

    @Override
    public LinkedPositionGroup getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        try {
            ProcessorBasedRefactoring renameRefactoring = this.createRenameRefactoring(renameElementContext);
            LinkedPositionGroup[] result = new LinkedPositionGroup[]{this.internalGetLinkedPositionGroup(renameElementContext, renameRefactoring, monitor)};
            if (monitor.isCanceled()) {
                result[0] = null;
            } else {
                monitor.done();
            }
            return result[0];
        }
        catch (Exception exc) {
            throw new WrappedException(exc);
        }
    }

    protected LinkedPositionGroup internalGetLinkedPositionGroup(IRenameElementContext renameElementContext, ProcessorBasedRefactoring renameRefactoring, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        XtextEditor xtextEditor = (XtextEditor)renameElementContext.getTriggeringEditor();
        IXtextDocument document = xtextEditor.getDocument();
        IRenameProcessorAdapter renameProcessorAdapter = this.renameProcessorAdapterFactory.create((RenameProcessor)renameRefactoring.getProcessor());
        String originalName = renameProcessorAdapter.getOriginalName();
        renameProcessorAdapter.setNewName(this.getDummyNewName(originalName));
        List<ReplaceEdit> edits = this.computeReplaceEditsForDocument(renameRefactoring, document, (IProgressMonitor)progress.newChild(80));
        return this.createLinkedGroupFromReplaceEdits(edits, xtextEditor, originalName, progress);
    }

    protected String getDummyNewName(String originalName) {
        return String.valueOf(originalName) + "_____";
    }

    protected List<ReplaceEdit> computeReplaceEditsForDocument(ProcessorBasedRefactoring renameRefactoring, IDocument document, IProgressMonitor monitor) {
        try {
            RefactoringTickProvider ticks = renameRefactoring.getRefactoringTickProvider();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks.getAllTicks());
            RefactoringStatus result = renameRefactoring.checkInitialConditions((IProgressMonitor)subMonitor.newChild(ticks.getCheckInitialConditionsTicks()));
            if (!result.hasError()) {
                result.merge(renameRefactoring.checkFinalConditions((IProgressMonitor)subMonitor.newChild(ticks.getCheckFinalConditionsTicks())));
                if (!result.hasError()) {
                    Change change = renameRefactoring.createChange((IProgressMonitor)subMonitor.newChild(ticks.getCreateChangeTicks()));
                    return this.replaceEditExtractor.getReplaceEditsForDocument(change, document);
                }
            }
        }
        catch (CoreException e) {
            this.log.error((Object)"Error calculating refactoring changes", (Throwable)e);
        }
        return null;
    }
}

