/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultRenameStrategy
extends AbstractRenameStrategy {
    protected ITextRegion originalNameRegion;

    protected DefaultRenameStrategy(EObject targetElement, ILocationInFileProvider locationInFileProvider) {
        super(targetElement);
        this.originalNameRegion = locationInFileProvider.getFullTextRegion(targetElement, (EStructuralFeature)this.getNameAttribute(targetElement), 0);
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        updateAcceptor.accept(this.targetElementOriginalURI.trimFragment(), this.getDeclarationTextEdit(newName));
    }

    protected TextEdit getDeclarationTextEdit(String newName) {
        return new ReplaceEdit(this.originalNameRegion.getOffset(), this.originalNameRegion.getLength(), newName);
    }

    public static class Provider
    implements IRenameStrategy.Provider {
        @Inject
        private ILocationInFileProvider locationInFileProvider;

        public IRenameStrategy get(EObject targetElement, IRenameElementContext renameElementContext) {
            return new DefaultRenameStrategy(targetElement, this.locationInFileProvider);
        }

        protected ILocationInFileProvider getLocationInFileProvider() {
            return this.locationInFileProvider;
        }
    }
}

