/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceUpdater
extends AbstractReferenceUpdater {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ITokenSerializer.ICrossReferenceSerializer crossReferenceSerializer;
    @Inject
    private ITransientValueService transientValueService;

    @Override
    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating reference updates", (int)resource2references.keySet().size());
        for (URI referringResourceURI : resource2references.keySet()) {
            if (progress.isCanceled()) {
                return;
            }
            Resource referringResource = resourceSet.getResource(referringResourceURI, false);
            if (!(referringResource instanceof XtextResource)) {
                throw new RefactoringStatusException("Resource " + Strings.notNull((Object)referringResourceURI) + " is not an XtextResource", true);
            }
            ((XtextResource)referringResource).getCache().clear(referringResource);
            for (IReferenceDescription referenceDescription : resource2references.get((Object)referringResourceURI)) {
                this.createReferenceUpdate(referenceDescription, referringResourceURI, elementRenameArguments, resourceSet, updateAcceptor);
            }
            progress.worked(1);
        }
    }

    protected void createReferenceUpdate(IReferenceDescription referenceDescription, URI referringResourceURI, ElementRenameArguments elementRenameArguments, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        URI referringElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getSourceEObjectUri());
        EObject referringElement = resourceSet.getEObject(referringElementNewURI, false);
        URI targetElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getTargetEObjectUri());
        EObject newTargetElement = resourceSet.getEObject(targetElementNewURI, false);
        this.createReferenceUpdate(referringElement, referringResourceURI, referenceDescription.getEReference(), referenceDescription.getIndexInList(), newTargetElement, updateAcceptor);
    }

    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        ITextRegion referenceTextRegion;
        CrossReference crossReference;
        if (!this.transientValueService.isTransient(referringElement, (EStructuralFeature)reference, indexInList) && (crossReference = this.getCrossReference(referringElement, (referenceTextRegion = this.locationInFileProvider.getFullTextRegion(referringElement, (EStructuralFeature)reference, indexInList)).getOffset())) != null) {
            String newReferenceText = this.crossReferenceSerializer.serializeCrossRef(referringElement, crossReference, newTargetElement, null);
            ReplaceEdit referenceEdit = new ReplaceEdit(referenceTextRegion.getOffset(), referenceTextRegion.getLength(), newReferenceText);
            updateAcceptor.accept(referringResourceURI, (TextEdit)referenceEdit);
        }
    }

    protected CrossReference getCrossReference(EObject referringElement, int offset) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)referringElement);
        if (node != null) {
            for (INode childNode : node.getAsTreeIterable()) {
                if (childNode.getOffset() < offset || !(childNode.getGrammarElement() instanceof CrossReference)) continue;
                return (CrossReference)childNode.getGrammarElement();
            }
        }
        return null;
    }
}

