/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";
    private String[] modelProviderIds;

    public CloseResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    protected CloseResourceAction(Shell shell, String text) {
        super(shell, text);
    }

    public CloseResourceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    protected CloseResourceAction(IShellProvider provider, String text) {
        super(provider, text);
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CloseResourceAction_title;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).close(monitor);
    }

    public void run() {
        List projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        IResource[] projectArray = projects.toArray(new IResource[projects.size()]);
        if (!IDE.saveAllEditors(projectArray, true)) {
            return;
        }
        if (!this.validateClose()) {
            return;
        }
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject project = (IProject)resources.next();
            rule = MultiRule.combine(rule, (ISchedulingRule)factory.modifyRule((IResource)project));
        }
        this.runInBackground(rule);
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (!currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }

    protected synchronized List getSelectedResources() {
        return super.getSelectedResources();
    }

    protected synchronized List getSelectedNonResources() {
        return super.getSelectedNonResources();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    private boolean validateClose() {
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        List resources = this.getActionResources();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!(resource instanceof IProject)) continue;
            IProject project = (IProject)resource;
            factory.close(project);
        }
        String message = resources.size() == 1 ? NLS.bind((String)IDEWorkbenchMessages.CloseResourceAction_warningForOne, (Object)((IResource)resources.get(0)).getName()) : IDEWorkbenchMessages.CloseResourceAction_warningForMultiple;
        return IDE.promptToConfirm(this.getShell(), IDEWorkbenchMessages.CloseResourceAction_confirm, message, factory.getDelta(), this.getModelProviderIds(), false);
    }
}

