/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableColumnPresentation;
import org.eclipse.jface.viewers.TreePath;

public class JavaVariableLabelProvider
extends VariableLabelProvider
implements Preferences.IPropertyChangeListener {
    public static JDIModelPresentation fLabelProvider = new JDIModelPresentation();
    private Map fQualifiedNameSettings = new HashMap();
    private boolean fQualifiedNames = false;
    private int fSerializeMode = 1;
    private static final int SERIALIZE_ALL = 0;
    private static final int SERIALIZE_NONE = 1;
    private static final int SERIALIZE_SOME = 2;
    static /* synthetic */ Class class$0;

    public JavaVariableLabelProvider() {
        Preferences prefs = JDIDebugUIPlugin.getDefault().getPluginPreferences();
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.determineSerializationMode(prefs.getString(IJDIPreferencesConstants.PREF_SHOW_DETAILS));
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof IJavaValue) {
            return fLabelProvider.getFormattedValueText((IJavaValue)value);
        }
        return super.getValueText(variable, value, context);
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = value.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = variable.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    private Boolean isShowQualfiiedNames(IPresentationContext context) {
        Boolean qualified = (Boolean)this.fQualifiedNameSettings.get(context.getId());
        if (qualified == null) {
            qualified = JDIDebugUIPlugin.getDefault().getPluginPreferences().getBoolean(String.valueOf(context.getId()) + '.' + IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES);
            this.fQualifiedNameSettings.put(context.getId(), qualified);
        }
        return qualified;
    }

    protected String getColumnText(IVariable variable, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_ID.equals(columnId)) {
            long uniqueId;
            if (value instanceof JDIObjectValue && (uniqueId = ((JDIObjectValue)value).getUniqueId()) >= 0L) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueId);
                return buffer.toString();
            }
            return "";
        }
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_COUNT.equals(columnId)) {
            if (value instanceof IJavaObject) {
                IJavaType jType = ((IJavaObject)value).getJavaType();
                if (jType == null && variable instanceof IJavaVariable) {
                    jType = ((IJavaVariable)variable).getJavaType();
                }
                if (jType instanceof IJavaReferenceType && !(jType instanceof IJavaInterfaceType)) {
                    long count = ((IJavaReferenceType)jType).getInstanceCount();
                    if (count == -1L) {
                        return DebugUIMessages.JavaVariableLabelProvider_0;
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(count);
                    return buffer.toString();
                }
            }
            return "";
        }
        return super.getColumnText(variable, value, context, columnId);
    }

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        Boolean showQ = this.isShowQualfiiedNames(update.getPresentationContext());
        this.fQualifiedNames = showQ;
        fLabelProvider.setAttribute("DISPLAY_QUALIFIED_NAMES", showQ);
        super.retrieveLabel(update);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().endsWith(IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES)) {
            this.fQualifiedNameSettings.clear();
        } else if (event.getProperty().equals(IJDIPreferencesConstants.PREF_SHOW_DETAILS)) {
            this.determineSerializationMode((String)event.getNewValue());
        }
    }

    private void determineSerializationMode(String value) {
        this.fSerializeMode = value.equals("INLINE_ALL") ? 1 : (value.equals("INLINE_FORMATTERS") ? 2 : 0);
    }

    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        IDebugModelPresentation presentation;
        if (columnId == null && (presentation = this.getModelPresentation(context, JDIDebugModel.getPluginIdentifier())) != null) {
            return presentation.getText(elementPath.getLastSegment());
        }
        return super.getLabel(elementPath, context, columnId);
    }

    protected ISchedulingRule getRule(ILabelUpdate update) {
        IJavaStackFrame frame = null;
        switch (this.fSerializeMode) {
            case 1: {
                return null;
            }
            case 0: {
                Object input = update.getViewerInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                frame = (IJavaStackFrame)DebugPlugin.getAdapter((Object)input, (Class)clazz);
                break;
            }
            case 2: {
                Object element = update.getElement();
                if (!(element instanceof IJavaVariable)) break;
                try {
                    IValue value = ((IJavaVariable)element).getValue();
                    if (!(value instanceof IJavaValue) || fLabelProvider.isShowLabelDetails((IJavaValue)value)) break;
                    Object input = update.getViewerInput();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    frame = (IJavaStackFrame)DebugPlugin.getAdapter((Object)input, (Class)clazz);
                    break;
                }
                catch (DebugException debugException) {}
            }
        }
        if (frame != null) {
            return ((JDIThread)frame.getThread()).getThreadRule();
        }
        return null;
    }
}

