/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.birt.chart.util.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IOUtil {
    private IOUtil() {
    }

    static byte[] readFully(String filename) throws IOException {
        return IOUtil.readFully(SecurityUtil.newFileInputStream((String)filename));
    }

    static byte[] readFully(File file) throws IOException {
        return IOUtil.readFully(SecurityUtil.newFileInputStream((File)file));
    }

    static byte[] readFully(InputStream is) throws IOException {
        byte[] tmp;
        int size = 10000;
        int off = 0;
        byte[] ret = new byte[size];
        try {
            int got;
            while ((got = is.read(ret, off, size - off)) != -1) {
                if ((off += got) != size) continue;
                tmp = new byte[size *= 2];
                System.arraycopy(ret, 0, tmp, 0, off);
                ret = tmp;
            }
        }
        finally {
            IOUtil.close(is);
        }
        if (off != size) {
            tmp = new byte[off];
            System.arraycopy(ret, 0, tmp, 0, off);
            ret = tmp;
        }
        return ret;
    }

    static Vector<String> readText(String filename) throws IOException {
        return IOUtil.readText(SecurityUtil.newFileReader((String)filename));
    }

    static Vector<String> readText(File file) throws IOException {
        return IOUtil.readText(SecurityUtil.newFileReader((File)file));
    }

    static Vector<String> readText(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        try {
            String line;
            Vector<String> ret = new Vector<String>();
            while ((line = br.readLine()) != null) {
                ret.addElement(line.intern());
            }
            Vector<String> vector = ret;
            return vector;
        }
        finally {
            IOUtil.close(br);
        }
    }

    static void writeText(Vector<String> lines, String filename) throws IOException {
        IOUtil.writeText(lines, SecurityUtil.newFileWriter((String)filename));
    }

    static void writeText(Vector<String> lines, File file) throws IOException {
        IOUtil.writeText(lines, SecurityUtil.newFileWriter((File)file));
    }

    static void writeText(Vector<String> lines, Writer out) throws IOException {
        BufferedWriter bw = new BufferedWriter(out);
        try {
            int l = lines.size();
            int i = 0;
            while (i < l) {
                bw.write(lines.elementAt(i));
                bw.newLine();
                ++i;
            }
        }
        finally {
            IOUtil.close(bw);
        }
    }

    static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

