/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.factories;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class CachingEditPartFactory
implements EditPartFactory {
    private Map<EditPart, Map<Object, EditPart>> m_cache = new WeakHashMap<EditPart, Map<Object, EditPart>>();
    private EditPartFactory m_delegate;

    public CachingEditPartFactory(EditPartFactory i_delegate) {
        if (i_delegate == null) {
            throw new NullPointerException("i_delegate must not be null");
        }
        this.m_delegate = i_delegate;
    }

    public EditPart createEditPart(EditPart i_context, Object i_model) {
        EditPart part;
        Map<Object, EditPart> contextCache = this.m_cache.get(i_context);
        if (contextCache == null) {
            contextCache = new WeakHashMap<Object, EditPart>();
            this.m_cache.put(i_context, contextCache);
        }
        if ((part = contextCache.get(i_model)) != null) {
            return part;
        }
        part = this.m_delegate.createEditPart(i_context, i_model);
        if (part != null) {
            contextCache.put(i_model, part);
        }
        return part;
    }
}

