/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import org.eclipse.swt.graphics.Color;

public class ColorConverter {
    public static byte[] toByteArray(byte i_red, byte i_green, byte i_blue, int i_alpha, byte[] io_colors) {
        byte[] colors = io_colors;
        if (colors == null) {
            colors = new byte[4];
        }
        if (colors.length != 4) {
            throw new IllegalArgumentException("io_byteColors must have a length of 4");
        }
        colors[0] = i_red;
        colors[1] = i_green;
        colors[2] = i_blue;
        colors[3] = (byte)(i_alpha & 0xFF);
        return colors;
    }

    public static byte[] toByteArray(Color i_color, int i_alpha, byte[] io_colors) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        byte red = (byte)(i_color.getRed() & 0xFF);
        byte green = (byte)(i_color.getGreen() & 0xFF);
        byte blue = (byte)(i_color.getBlue() & 0xFF);
        return ColorConverter.toByteArray(red, green, blue, i_alpha, io_colors);
    }

    public static float[] toFloatArray(Color i_color, int i_alpha, float[] io_colors) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        int red = i_color.getRed();
        int green = i_color.getGreen();
        int blue = i_color.getBlue();
        return ColorConverter.toFloatArray(red, green, blue, i_alpha, io_colors);
    }

    public static float[] toFloatArray(int i_color, int i_alpha, float[] io_colors) {
        int red = i_color & 0xFF;
        int green = i_color >> 8 & 0xFF;
        int blue = i_color >> 16 & 0xFF;
        return ColorConverter.toFloatArray(red, green, blue, i_alpha, io_colors);
    }

    public static float[] toFloatArray(int i_red, int i_green, int i_blue, int i_alpha, float[] io_colors) {
        float[] colors = io_colors;
        if (colors == null) {
            colors = new float[4];
        }
        if (colors.length != 4) {
            throw new IllegalArgumentException("io_byteColors must have a length of 4");
        }
        colors[0] = (float)(i_red & 0xFF) / 255.0f;
        colors[1] = (float)(i_green & 0xFF) / 255.0f;
        colors[2] = (float)(i_blue & 0xFF) / 255.0f;
        colors[3] = (float)(i_alpha & 0xFF) / 255.0f;
        return colors;
    }

    public static int[] toIntArray(Color i_color, int i_alpha, int[] io_colors) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        int red = i_color.getRed();
        int green = i_color.getGreen();
        int blue = i_color.getBlue();
        return ColorConverter.toIntArray(red, green, blue, i_alpha, io_colors);
    }

    public static int[] toIntArray(int i_red, int i_green, int i_blue, int i_alpha, int[] io_colors) {
        int[] colors = io_colors;
        if (colors == null) {
            colors = new int[4];
        }
        if (colors.length != 4) {
            throw new IllegalArgumentException("io_byteColors must have a length of 4");
        }
        colors[0] = i_red & 0xFF;
        colors[1] = i_green & 0xFF;
        colors[2] = i_blue & 0xFF;
        colors[3] = i_alpha & 0xFF;
        return colors;
    }

    private ColorConverter() {
    }
}

