/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.picking;

import java.util.logging.Logger;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.picking.Hit;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.picking.Query;
import org.eclipse.draw3d.util.Draw3DCache;

public class GeometryPicker
implements Picker {
    private static final Logger log = Logger.getLogger(GeometryPicker.class.getName());
    private ISurface m_currentSurface;
    private IFigure3D m_rootFigure;
    private IScene m_scene;
    private TreeSearch m_surfaceSearch;

    public GeometryPicker(IScene i_scene) {
        if (i_scene == null) {
            throw new NullPointerException("i_scene must not be null");
        }
        this.m_scene = i_scene;
    }

    public ISurface getCurrentSurface() {
        if (this.m_currentSurface == null) {
            return this.m_rootFigure.getSurface();
        }
        return this.m_currentSurface;
    }

    public Hit getHit(int i_mx, int i_my) {
        return this.getHit(i_mx, i_my, null);
    }

    public Hit getHit(int i_mx, int i_my, TreeSearch i_search) {
        Hit hit;
        Vector3f rayPoint = Draw3DCache.getVector3f();
        try {
            ICamera camera = this.m_scene.getCamera();
            camera.unProject(i_mx, i_my, 0.0f, null, rayPoint);
            hit = this.getHit((IVector3f)rayPoint, i_search);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
        return hit;
    }

    public Hit getHit(IVector3f i_rayPoint) {
        return this.getHit(i_rayPoint, (TreeSearch)null);
    }

    public Hit getHit(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        return this.getHit(i_rayOrigin, i_rayDirection, null);
    }

    public Hit getHit(IVector3f i_rayOrigin, IVector3f i_rayDirection, TreeSearch i_search) {
        if (i_rayOrigin == null) {
            throw new NullPointerException("i_rayOrigin must not be null");
        }
        if (i_rayDirection == null) {
            throw new NullPointerException("i_rayDirection must not be null");
        }
        Query query = new Query(i_rayOrigin, i_rayDirection, this.m_rootFigure, i_search);
        query.setDebug(this.m_scene.isDebug());
        return query.execute();
    }

    public Hit getHit(IVector3f i_rayPoint, TreeSearch i_search) {
        Hit hit;
        if (i_rayPoint == null) {
            throw new NullPointerException("i_rayPoint must not be null");
        }
        Vector3f rayOrigin = Draw3DCache.getVector3f();
        Vector3f rayDirection = Draw3DCache.getVector3f();
        try {
            ICamera camera = this.m_scene.getCamera();
            camera.getPosition(rayOrigin);
            if (rayOrigin.equals(i_rayPoint)) {
                throw new IllegalArgumentException("rayOrigin must not be equal to the camera position");
            }
            Math3D.getRayDirection((IVector3f)rayOrigin, (IVector3f)i_rayPoint, (Vector3f)rayDirection);
            hit = this.getHit((IVector3f)rayOrigin, (IVector3f)rayDirection, i_search);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayOrigin, rayDirection});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayOrigin, rayDirection});
        return hit;
    }

    public void setRootFigure(IFigure3D i_rootFigure) {
        this.m_rootFigure = i_rootFigure;
    }

    public void setSurfaceSearch(TreeSearch i_search) {
        this.m_surfaceSearch = i_search;
    }

    public void updateCurrentSurface(int i_mx, int i_my) {
        ISurface surface;
        Hit hit = this.getHit(i_mx, i_my, this.m_surfaceSearch);
        if (hit != null && (surface = hit.getFigure3D().getSurface()) != null) {
            this.m_currentSurface = surface;
        }
    }
}

