/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.VertexPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveSet {
    private PrimitiveSet m_parent;
    private PrimitiveClass m_primitiveClass;
    private List<Primitive> m_primitives = new LinkedList<Primitive>();
    private int m_vertexCount;

    public PrimitiveSet(PrimitiveClass i_primitiveClass) {
        if (i_primitiveClass == null) {
            throw new NullPointerException("i_primitiveClass must not be null");
        }
        this.m_primitiveClass = i_primitiveClass;
    }

    protected PrimitiveSet(PrimitiveSet i_parent, PrimitiveClass i_primitiveClass) {
        this(i_primitiveClass);
        if (i_parent == null) {
            throw new NullPointerException("i_parent must not be null");
        }
        this.m_parent = i_parent;
    }

    public boolean add(Primitive i_primitive) {
        if (i_primitive == null) {
            throw new NullPointerException("i_primitive must not be null");
        }
        if (!this.m_primitiveClass.contains(i_primitive)) {
            if (this.m_parent != null && !this.overlaps(i_primitive)) {
                return this.m_parent.add(i_primitive);
            }
            return false;
        }
        this.m_primitives.add(i_primitive);
        if (i_primitive instanceof VertexPrimitive) {
            VertexPrimitive vertexPrimitive = (VertexPrimitive)i_primitive;
            this.m_vertexCount += vertexPrimitive.getVertexCount();
        }
        return true;
    }

    public PrimitiveClass getPrimitiveClass() {
        return this.m_primitiveClass;
    }

    public <T extends Primitive> List<T> getPrimitives() {
        return Collections.unmodifiableList(this.m_primitives);
    }

    public List<PrimitiveSet> getSets(List<PrimitiveSet> io_result) {
        List<PrimitiveSet> result = io_result;
        if (result == null) {
            result = new LinkedList<PrimitiveSet>();
        }
        if (this.m_parent != null) {
            result = this.m_parent.getSets(result);
        }
        result.add(this);
        return result;
    }

    public int getSize() {
        return this.m_primitives.size();
    }

    public int getVertexCount() {
        return this.m_vertexCount;
    }

    protected boolean overlaps(Primitive i_candidate) {
        if (i_candidate == null) {
            throw new NullPointerException("i_candidate must not be null");
        }
        for (Primitive primitive : this.m_primitives) {
            if (!primitive.intersects(i_candidate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PrimitiveSet [class=" + this.m_primitiveClass + ", primitives=" + this.m_primitives.size() + "]";
    }
}

