/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.MouseEvent3D;
import org.eclipse.draw3d.PickingUpdateManager3D;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class EventDispatcher3D
extends EventDispatcher {
    private static final Logger log = Logger.getLogger(EventDispatcher3D.class.getName());
    private EventDispatcher m_dispatcher;
    private Method m_getAccessibilityDispatcherMethod;
    private Method m_releaseCaptureMethod;
    private IScene m_scene;
    private Method m_setCaptureMethod;
    private Method m_updateCursorMethod;

    public EventDispatcher3D(EventDispatcher i_dispatcher, IScene i_scene) {
        if (i_dispatcher == null) {
            throw new NullPointerException("i_dispatcher must not be null");
        }
        if (i_scene == null) {
            throw new NullPointerException("i_scene must not be null");
        }
        this.m_dispatcher = i_dispatcher;
        this.m_scene = i_scene;
    }

    protected MouseEvent3D convert(MouseEvent i_me) {
        Picker picker = this.getPicker();
        picker.updateCurrentSurface(i_me.x, i_me.y);
        ISurface surface = picker.getCurrentSurface();
        ICamera camera = this.m_scene.getCamera();
        return new MouseEvent3D(i_me, surface, camera);
    }

    public void dispatchFocusGained(FocusEvent i_e) {
        this.m_dispatcher.dispatchFocusGained(i_e);
    }

    public void dispatchFocusLost(FocusEvent i_e) {
        this.m_dispatcher.dispatchFocusLost(i_e);
    }

    public void dispatchKeyPressed(KeyEvent i_e) {
        this.m_dispatcher.dispatchKeyPressed(i_e);
    }

    public void dispatchKeyReleased(KeyEvent i_e) {
        this.m_dispatcher.dispatchKeyReleased(i_e);
    }

    public void dispatchKeyTraversed(TraverseEvent i_e) {
        this.m_dispatcher.dispatchKeyTraversed(i_e);
    }

    public void dispatchMouseDoubleClicked(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseDoubleClicked((MouseEvent)me);
    }

    public void dispatchMouseEntered(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseEntered((MouseEvent)me);
    }

    public void dispatchMouseExited(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseExited((MouseEvent)me);
    }

    public void dispatchMouseHover(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseHover((MouseEvent)me);
    }

    public void dispatchMouseMoved(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseMoved((MouseEvent)me);
    }

    public void dispatchMousePressed(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMousePressed((MouseEvent)me);
    }

    public void dispatchMouseReleased(MouseEvent i_me) {
        MouseEvent3D me = this.convert(i_me);
        this.m_dispatcher.dispatchMouseReleased((MouseEvent)me);
    }

    public void dispatchMouseWheelScrolled(Event i_e) {
        this.m_dispatcher.dispatchMouseWheelScrolled(i_e);
    }

    public EventDispatcher.AccessibilityDispatcher getAccessibilityDispatcher() {
        try {
            if (this.m_getAccessibilityDispatcherMethod == null) {
                this.m_getAccessibilityDispatcherMethod = this.m_dispatcher.getClass().getDeclaredMethod("getAccessibilityDispatcher", new Class[0]);
                this.m_getAccessibilityDispatcherMethod.setAccessible(true);
            }
            return (EventDispatcher.AccessibilityDispatcher)this.m_getAccessibilityDispatcherMethod.invoke((Object)this.m_dispatcher, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("could not reflectively invoke method " + this.m_dispatcher.getClass().getName() + ".getAccessibilityDispatcher()", e);
        }
    }

    private Picker getPicker() {
        PickingUpdateManager3D updateManager = this.m_scene.getUpdateManager3D();
        return updateManager.getPicker();
    }

    public IFigure getFocusOwner() {
        try {
            return this.m_dispatcher.getFocusOwner();
        }
        catch (Error ex) {
            log.warning("Error retrieving focus owner: " + ex);
            return null;
        }
    }

    public boolean isCaptured() {
        return this.m_dispatcher.isCaptured();
    }

    public void releaseCapture() {
        try {
            if (this.m_releaseCaptureMethod == null) {
                this.m_releaseCaptureMethod = this.m_dispatcher.getClass().getDeclaredMethod("releaseCapture", new Class[0]);
                this.m_releaseCaptureMethod.setAccessible(true);
            }
            this.m_releaseCaptureMethod.invoke((Object)this.m_dispatcher, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("could not reflectively invoke method " + this.m_dispatcher.getClass().getName() + ".releaseCapture()", e);
        }
    }

    public void requestFocus(IFigure i_fig) {
        this.m_dispatcher.requestFocus(i_fig);
    }

    public void requestRemoveFocus(IFigure i_fig) {
        this.m_dispatcher.requestRemoveFocus(i_fig);
    }

    public void setCapture(IFigure i_figure) {
        try {
            if (this.m_setCaptureMethod == null) {
                this.m_setCaptureMethod = this.m_dispatcher.getClass().getDeclaredMethod("setCapture", IFigure.class);
                this.m_setCaptureMethod.setAccessible(true);
            }
            this.m_setCaptureMethod.invoke((Object)this.m_dispatcher, i_figure);
        }
        catch (Exception e) {
            throw new RuntimeException("could not reflectively invoke method " + this.m_dispatcher.getClass().getName() + ".setCapture()", e);
        }
    }

    public void setControl(Control i_control) {
        this.m_dispatcher.setControl(i_control);
    }

    public void setRoot(IFigure i_figure) {
        this.m_dispatcher.setRoot(i_figure);
    }

    public void updateCursor() {
        try {
            if (this.m_updateCursorMethod == null) {
                this.m_updateCursorMethod = this.m_dispatcher.getClass().getDeclaredMethod("updateCursor", new Class[0]);
                this.m_updateCursorMethod.setAccessible(true);
            }
            this.m_updateCursorMethod.invoke((Object)this.m_dispatcher, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("could not reflectively invoke method " + this.m_dispatcher.getClass().getName() + ".updateCursor()", e);
        }
    }
}

