/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.font;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.GLFontKey;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFont;
import org.eclipse.swt.graphics.Font;

public class LwjglFontManager {
    private DisplayListManager m_displayListManager;
    private static final Logger log = Logger.getLogger(LwjglFontManager.class.getName());
    private boolean m_disposed = false;
    private Map<GLFontKey, LwjglFont> m_fonts = new HashMap<GLFontKey, LwjglFont>();

    public LwjglFontManager(DisplayListManager i_displayListManager) {
        if (i_displayListManager == null) {
            throw new NullPointerException("i_displayListManager must not be null");
        }
        this.m_displayListManager = i_displayListManager;
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        for (LwjglFont glFont : this.m_fonts.values()) {
            glFont.dispose();
        }
        this.m_fonts = null;
        this.m_disposed = true;
    }

    public LwjglFont getFont(Font i_font, char i_startChar, char i_endChar, boolean i_antiAliased) {
        if (this.m_disposed) {
            throw new IllegalStateException("font manager is disposed");
        }
        if (i_font == null) {
            throw new NullPointerException("i_font must not be null");
        }
        GLFontKey key = new GLFontKey(i_font, i_startChar, i_endChar, i_antiAliased);
        LwjglFont glFont = this.m_fonts.get(key);
        if (glFont == null) {
            glFont = new LwjglFont(i_font, i_startChar, i_endChar, i_antiAliased, this.m_displayListManager);
            this.m_fonts.put(key, glFont);
            if (log.isLoggable(Level.FINE)) {
                log.fine("loaded new GL raster font " + glFont);
            }
        }
        return glFont;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LwjglFontManager [");
        Iterator<LwjglFont> iter = this.m_fonts.values().iterator();
        while (iter.hasNext()) {
            LwjglFont glFont = iter.next();
            builder.append("Font: ");
            builder.append(glFont.toString());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

