/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry.intersection;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.intersection.AVLTree;
import org.eclipse.draw3d.geometry.intersection.Intersection;
import org.eclipse.draw3d.geometry.intersection.Polyline;
import org.eclipse.draw3d.geometry.intersection.Segment;

public class PolylineIntersectsPolylineAlgorithm {
    private static final Comparator<Event> m_eventComparator = new Comparator<Event>(){

        @Override
        public int compare(Event i_e0, Event i_e1) {
            return m_pointComparator.compare(i_e0.getPoint(), i_e1.getPoint());
        }
    };
    private static final Comparator<IVector2f> m_pointComparator = new Comparator<IVector2f>(){

        @Override
        public int compare(IVector2f i_p0, IVector2f i_p1) {
            if (i_p0.getY() < i_p1.getY()) {
                return -1;
            }
            if (i_p0.getY() > i_p1.getY()) {
                return 1;
            }
            if (i_p0.getX() < i_p1.getX()) {
                return -1;
            }
            if (i_p0.getX() > i_p1.getX()) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<Object> m_queryComparator = new Comparator<Object>(){

        @Override
        public int compare(Object i_o0, Object i_o1) {
            if (i_o0 instanceof TreeSegment && i_o1 instanceof TreeSegment) {
                return m_segmentComparator.compare((TreeSegment)i_o0, (TreeSegment)i_o1);
            }
            if (i_o0 instanceof IVector2f && i_o1 instanceof IVector2f) {
                return m_pointComparator.compare((IVector2f)i_o0, (IVector2f)i_o1);
            }
            if (i_o0 instanceof TreeSegment && i_o1 instanceof IVector2f) {
                TreeSegment s = (TreeSegment)i_o0;
                IVector2f v = (IVector2f)i_o1;
                IVector2f u = s.getUpper();
                IVector2f l = s.getLower();
                int c = m_pointComparator.compare(u, v);
                if (c == 0) {
                    c = m_pointComparator.compare(l, v);
                }
                return c;
            }
            if (i_o0 instanceof IVector2f && i_o1 instanceof TreeSegment) {
                return -1 * this.compare(i_o1, i_o0);
            }
            throw new AssertionError((Object)"can only compare segments and vectors");
        }
    };
    private static final Comparator<TreeSegment> m_segmentComparator = new Comparator<TreeSegment>(){

        @Override
        public int compare(TreeSegment i_o0, TreeSegment i_o1) {
            IVector2f u0 = i_o0.getUpper();
            IVector2f l0 = i_o0.getLower();
            IVector2f u1 = i_o1.getUpper();
            IVector2f l1 = i_o1.getLower();
            if (u0.getX() < u0.getX()) {
                return -1;
            }
            if (u0.getX() > u0.getX()) {
                return 1;
            }
            if (u0.getY() < u1.getY()) {
                return -1;
            }
            if (u0.getY() > u1.getY()) {
                return 1;
            }
            if (l0.getX() < l0.getX()) {
                return -1;
            }
            if (l0.getX() > l0.getX()) {
                return 1;
            }
            if (l0.getY() < l1.getY()) {
                return -1;
            }
            if (l0.getY() > l1.getY()) {
                return 1;
            }
            return 0;
        }
    };
    private AVLTree<Event> m_events;
    private AVLTree<TreeSegment> m_segments;
    private Collection<Intersection> m_intersections = new HashSet<Intersection>();

    private void buildEventQueue(Polyline i_line) {
        if (this.m_events == null) {
            this.m_events = new AVLTree<Event>(m_eventComparator);
        }
        for (Segment s : i_line.getSegments()) {
            Event l;
            Event u = new Event(s.getStart());
            int c = m_eventComparator.compare(u, l = new Event(s.getEnd()));
            if (c > 0) {
                Event temp = u;
                u = l;
                l = temp;
            } else if (c == 0) {
                throw new AssertionError((Object)"empty segment");
            }
            if (this.m_events.contains(u)) {
                u = this.m_events.get(u);
            } else {
                this.m_events.insert(u);
            }
            if (this.m_events.contains(l)) {
                l = this.m_events.get(l);
            } else {
                this.m_events.insert(l);
            }
            TreeSegment ts = new TreeSegment(i_line, s);
            u.addUpper(ts);
            l.addLower(ts);
        }
    }

    private void handleEvent(Event i_event) {
        TreeSegment r;
        TreeSegment l;
        IVector2f p = i_event.getPoint();
        Set<TreeSegment> upper = i_event.getUpper();
        Set<TreeSegment> inner = i_event.getInner();
        Set<TreeSegment> lower = i_event.getLower();
        TreeSegment ln = null;
        TreeSegment rn = null;
        for (TreeSegment ts : lower) {
            this.m_segments.remove(ts);
            ts.removeOverlaps();
        }
        for (TreeSegment ts : inner) {
            this.m_segments.remove(ts);
        }
        for (TreeSegment ts : inner) {
            ts.setIntersection(p);
            this.m_segments.insert(ts);
            if (ln == null || m_segmentComparator.compare(ts, ln) < 0) {
                ln = ts;
            }
            if (rn != null && m_segmentComparator.compare(ts, rn) <= 0) continue;
            rn = ts;
        }
        for (TreeSegment ts : upper) {
            this.m_segments.insert(ts);
            if (ln == null || m_segmentComparator.compare(ts, ln) < 0) {
                ln = ts;
            }
            if (rn != null && m_segmentComparator.compare(ts, rn) <= 0) continue;
            rn = ts;
        }
        if (upper.isEmpty() && inner.isEmpty()) {
            l = this.m_segments.queryPrevious(p, m_queryComparator);
            r = this.m_segments.queryNext(p, m_queryComparator);
            this.findNextEvent(l, r, i_event);
        } else {
            l = this.m_segments.getPrevious(ln);
            r = this.m_segments.getNext(rn);
            if (l != null) {
                this.findNextEvent(l, ln, i_event);
            }
            if (r != null) {
                this.findNextEvent(rn, r, i_event);
            }
        }
    }

    private void handleIntersection(TreeSegment i_left, TreeSegment i_right, IVector2f i_point) {
        Event e = new Event(i_point);
        if (this.m_events.contains(e)) {
            e = this.m_events.get(e);
        }
        e.addInner(i_left);
        e.addInner(i_right);
    }

    private void handleOverlap(TreeSegment i_left, TreeSegment i_right, IVector2f i_start, IVector2f i_end) {
    }

    private void findNextEvent(TreeSegment i_left, TreeSegment i_right, Event i_event) {
        Vector2f point = Math3DCache.getVector2f();
        Vector2f start = Math3DCache.getVector2f();
        Vector2f end = Math3DCache.getVector2f();
        try {
            if (i_left.overlaps(i_right, start, end) && (m_pointComparator.compare(start, i_event.getPoint()) > 0 || m_pointComparator.compare(end, i_event.getPoint()) > 0)) {
                this.handleOverlap(i_left, i_right, start, end);
            } else if (i_left.intersects(i_right, point) && m_pointComparator.compare(point, i_event.getPoint()) > 0) {
                this.handleIntersection(i_left, i_right, point);
            }
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector2f(point, start, end);
            throw throwable;
        }
        Math3DCache.returnVector2f(point, start, end);
    }

    public boolean intersects(Polyline i_line0, Polyline i_line1) {
        if (i_line0 == null) {
            throw new NullPointerException("i_line0 must not be null");
        }
        if (i_line1 == null) {
            throw new NullPointerException("i_line1 must not be null");
        }
        if (i_line0.getSegments().isEmpty() || i_line1.getSegments().isEmpty()) {
            return false;
        }
        if (this.m_events != null) {
            this.m_events.clear();
        }
        this.buildEventQueue(i_line0);
        this.buildEventQueue(i_line1);
        while (!this.m_events.isEmpty()) {
            Event event = this.m_events.getFirst();
            this.m_events.remove(event);
            this.handleEvent(event);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Event {
        private Set<TreeSegment> m_inner;
        private Set<TreeSegment> m_lower;
        private IVector2f m_point;
        private Set<TreeSegment> m_upper;

        public Event(IVector2f i_point) {
            this.m_point = i_point;
        }

        public void addInner(TreeSegment i_segment) {
            if (this.m_inner == null) {
                this.m_inner = new HashSet<TreeSegment>();
            }
            this.m_inner.add(i_segment);
        }

        public void addLower(TreeSegment i_segment) {
            if (this.m_lower == null) {
                this.m_lower = new HashSet<TreeSegment>();
            }
            this.m_lower.add(i_segment);
        }

        public void addUpper(TreeSegment i_segment) {
            if (this.m_upper == null) {
                this.m_upper = new HashSet<TreeSegment>();
            }
            this.m_upper.add(i_segment);
        }

        public Set<TreeSegment> getInner() {
            if (this.m_inner == null) {
                return Collections.emptySet();
            }
            return this.m_inner;
        }

        public Set<TreeSegment> getLower() {
            if (this.m_lower == null) {
                return Collections.emptySet();
            }
            return this.m_lower;
        }

        public IVector2f getPoint() {
            return this.m_point;
        }

        public Set<TreeSegment> getUpper() {
            if (this.m_upper == null) {
                return Collections.emptySet();
            }
            return this.m_upper;
        }

        public boolean isEmpty() {
            return !(this.m_upper != null && !this.m_upper.isEmpty() || this.m_lower != null && !this.m_lower.isEmpty() || this.m_inner != null && !this.m_inner.isEmpty());
        }

        public void removeInner(TreeSegment i_segment) {
            this.m_inner.remove(i_segment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeSegment {
        private IVector2f m_intersection;
        private Segment m_segment;
        private Polyline m_line;
        private Set<TreeSegment> m_overlaps;

        public void addOverlap(TreeSegment i_segment) {
            if (this.m_overlaps == null) {
                this.m_overlaps = new HashSet<TreeSegment>();
            }
            this.m_overlaps.add(i_segment);
            if (!i_segment.getOverlaps().contains(this)) {
                i_segment.addOverlap(this);
            }
        }

        public Set<TreeSegment> getOverlaps() {
            if (this.m_overlaps == null) {
                return Collections.emptySet();
            }
            return this.m_overlaps;
        }

        public void removeOverlap(TreeSegment i_segment) {
            this.m_overlaps.remove(i_segment);
            if (i_segment.getOverlaps().contains(this)) {
                i_segment.removeOverlap(this);
            }
        }

        public Polyline getPolyline() {
            return this.m_line;
        }

        public TreeSegment(Polyline i_line, Segment i_segment) {
            this.m_line = i_line;
            this.m_segment = i_segment;
        }

        public Segment getSegment() {
            return this.m_segment;
        }

        public boolean overlaps(TreeSegment i_segment, Vector2f i_start, Vector2f i_end) {
            float mg = this.getSegment().getG();
            float tg = i_segment.getSegment().getG();
            float mc = this.getSegment().getC();
            float tc = i_segment.getSegment().getC();
            if (mg == tg && mc == tc) {
                IVector2f mu = this.getUpper();
                IVector2f ml = this.getLower();
                IVector2f tu = i_segment.getUpper();
                IVector2f tl = i_segment.getLower();
                if (Math3D.in(mu.getY(), ml.getY(), tu.getY())) {
                    i_start.set(tu);
                    if (Math3D.in(mu.getY(), ml.getY(), tl.getY())) {
                        i_end.set(tl);
                    } else {
                        i_end.set(ml);
                    }
                    return true;
                }
                if (Math3D.in(tu.getY(), tl.getY(), mu.getY())) {
                    i_start.set(mu);
                    if (Math3D.in(tu.getY(), tl.getY(), ml.getY())) {
                        i_end.set(ml);
                    } else {
                        i_end.set(tl);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean intersects(TreeSegment i_segment, Vector2f i_point) {
            float mg = this.getSegment().getG();
            float tg = i_segment.getSegment().getG();
            float mc = this.getSegment().getC();
            float tc = i_segment.getSegment().getC();
            if (mg != tg) {
                float x = (mc - tc) / (mg - tg);
                float y = mg * x - mc;
                i_point.set(x, y);
                return true;
            }
            return false;
        }

        public IVector2f getLower() {
            IVector2f s = this.m_segment.getStart();
            IVector2f e = this.m_segment.getEnd();
            return m_pointComparator.compare(s, e) < 0 ? s : e;
        }

        public IVector2f getUpper() {
            if (this.m_intersection != null) {
                return this.m_intersection;
            }
            IVector2f s = this.m_segment.getStart();
            IVector2f e = this.m_segment.getEnd();
            return m_pointComparator.compare(s, e) > 0 ? s : e;
        }

        public void setIntersection(IVector2f i_intersection) {
            this.m_intersection = i_intersection;
        }

        public void removeOverlaps() {
        }
    }
}

