/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.rule;

import org.ascape.model.Agent;
import org.ascape.model.rule.Rule;
import org.ascape.util.data.StatCollector;

public class CollectStats
extends Rule {
    private static final long serialVersionUID = 1L;
    private StatCollector[] stats = new StatCollector[0];
    private StatCollector[] autoSeriesStatCollectors = new StatCollector[0];
    private StatCollector[] autoSeriesStatCollectors2 = new StatCollector[0];
    private int phase = 1;

    public CollectStats() {
        super("Collect Statistics");
    }

    public CollectStats(StatCollector[] statCollectors) {
        super("Collect Statistics");
        this.addStatCollectors(statCollectors);
    }

    public StatCollector[] getStatCollectors() {
        return this.stats;
    }

    public void addStatCollectors(StatCollector[] addDataPoints) {
        int newSize = this.autoSeriesStatCollectors.length;
        int newSize2 = this.autoSeriesStatCollectors2.length;
        int i = 0;
        while (i < addDataPoints.length) {
            if (addDataPoints[i].isAutoCollect() && !addDataPoints[i].isPhase2()) {
                ++newSize;
            }
            if (addDataPoints[i].isAutoCollect() && addDataPoints[i].isPhase2()) {
                ++newSize2;
            }
            ++i;
        }
        StatCollector[] newDataPoints = new StatCollector[this.stats.length + addDataPoints.length];
        int i2 = 0;
        while (i2 < this.stats.length) {
            newDataPoints[i2] = this.stats[i2];
            ++i2;
        }
        while (i2 < newDataPoints.length) {
            newDataPoints[i2] = addDataPoints[i2 - this.stats.length];
            ++i2;
        }
        this.stats = newDataPoints;
        StatCollector[] newAutoDataPoints = new StatCollector[newSize];
        StatCollector[] newAutoDataPoints2 = new StatCollector[newSize2];
        i2 = 0;
        while (i2 < this.autoSeriesStatCollectors.length) {
            newAutoDataPoints[i2] = this.autoSeriesStatCollectors[i2];
            ++i2;
        }
        int addIndex = i2;
        i2 = 0;
        while (i2 < addDataPoints.length) {
            if (addDataPoints[i2].isAutoCollect() && !addDataPoints[i2].isPhase2()) {
                newAutoDataPoints[addIndex] = addDataPoints[i2];
                ++addIndex;
            }
            ++i2;
        }
        this.autoSeriesStatCollectors = newAutoDataPoints;
        System.arraycopy(this.autoSeriesStatCollectors2, 0, newAutoDataPoints2, 0, this.autoSeriesStatCollectors2.length);
        addIndex = this.autoSeriesStatCollectors2.length;
        i2 = 0;
        while (i2 < addDataPoints.length) {
            if (addDataPoints[i2].isAutoCollect() && addDataPoints[i2].isPhase2()) {
                newAutoDataPoints2[addIndex] = addDataPoints[i2];
                ++addIndex;
            }
            ++i2;
        }
        this.autoSeriesStatCollectors2 = newAutoDataPoints2;
    }

    public void addStatCollector(StatCollector addDataPoint) {
        StatCollector[] tempStats = new StatCollector[]{addDataPoint};
        this.addStatCollectors(tempStats);
    }

    public void removeAllStatCollectors() {
        this.stats = new StatCollector[0];
        this.autoSeriesStatCollectors = new StatCollector[0];
        this.autoSeriesStatCollectors2 = new StatCollector[0];
    }

    public boolean removeStatCollector(StatCollector toBeRemoved) {
        StatCollector[] temp = new StatCollector[this.stats.length - 1];
        boolean found = false;
        int i = 0;
        int j = 0;
        while (i < this.stats.length) {
            StatCollector statCollector = this.stats[i];
            if (statCollector.equals(toBeRemoved)) {
                found = true;
            } else {
                temp[j++] = this.stats[i];
            }
            ++i;
        }
        this.stats = temp;
        StatCollector[] removeFrom = null;
        boolean foundAuto = true;
        if (toBeRemoved.isAutoCollect()) {
            StatCollector[] tempAuto;
            foundAuto = false;
            if (toBeRemoved.isPhase2()) {
                tempAuto = new StatCollector[this.autoSeriesStatCollectors2.length - 1];
                removeFrom = this.autoSeriesStatCollectors2;
            } else {
                tempAuto = new StatCollector[this.autoSeriesStatCollectors.length - 1];
                removeFrom = this.autoSeriesStatCollectors;
            }
            int i2 = 0;
            int j2 = 0;
            while (i2 < removeFrom.length) {
                StatCollector statCollector = removeFrom[i2];
                if (statCollector.equals(toBeRemoved)) {
                    foundAuto = true;
                } else {
                    tempAuto[j2++] = removeFrom[i2];
                }
                ++i2;
            }
            if (toBeRemoved.isPhase2()) {
                this.autoSeriesStatCollectors2 = tempAuto;
            } else {
                this.autoSeriesStatCollectors = tempAuto;
            }
        }
        if (!found) {
            throw new RuntimeException("Tried to remove a non-existant StatCollector: " + toBeRemoved);
        }
        if (!foundAuto) {
            throw new RuntimeException("Tried to remove a non-existant StatCollector from autoCollect: " + toBeRemoved);
        }
        return found;
    }

    public void clear() {
        int i = 0;
        while (i < this.stats.length) {
            this.stats[i].clear();
            ++i;
        }
    }

    public void calculateValues() {
        int i = 0;
        while (i < this.stats.length) {
            if (this.stats[i].isCalculated()) {
                this.stats[i].addValue(this.stats[i].calculateValue());
            }
            ++i;
        }
    }

    public void execute(Agent agent) {
        block3: {
            block2: {
                if (this.phase != 1) break block2;
                int i = 0;
                while (i < this.autoSeriesStatCollectors.length) {
                    this.autoSeriesStatCollectors[i].addValueFor(agent);
                    ++i;
                }
                break block3;
            }
            if (this.phase != 2) break block3;
            int i = 0;
            while (i < this.autoSeriesStatCollectors2.length) {
                this.autoSeriesStatCollectors2[i].addValueFor(agent);
                ++i;
            }
        }
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isRandomExecution() {
        return false;
    }

    public boolean isIterateAll() {
        return true;
    }

    public boolean isCauseRemoval() {
        return false;
    }
}

