/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Position3DImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.PositionableShape;
import org.eclipse.draw3d.shapes.SphereTriangle;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereShape
extends PositionableShape {
    private static final IVector3f CENTER = new Vector3fImpl(0.5f, 0.5f, 0.5f);
    private static final float RADIUS = 0.5f;
    private static final float RADIUS_SQUARED = 0.25f;
    private static final IPosition3D ROTATE_Z90;
    private static final Map<Integer, SphereTriangle[][]> STRIPE_CACHE;
    private static final float[] TMP_F2;
    private int m_alpha = 255;
    private boolean m_fill = true;
    private Color m_fillColor = Display.getCurrent().getSystemColor(1);
    private SphereKey m_fillKey;
    private boolean m_outline = true;
    private Color m_outlineColor = Display.getCurrent().getSystemColor(2);
    private SphereKey m_outlineKey;
    private int m_precision;
    private SphereTriangle[][] m_stripes;
    private boolean m_superimposed;

    static {
        STRIPE_CACHE = new HashMap<Integer, SphereTriangle[][]>();
        TMP_F2 = new float[2];
        Position3DImpl pos = new Position3DImpl();
        pos.setSize3D((IVector3f)new Vector3fImpl(1.0f, 1.0f, 1.0f));
        pos.setRotation3D((IVector3f)new Vector3fImpl(0.0f, 0.0f, 1.5707964f));
        ROTATE_Z90 = pos;
    }

    public SphereShape(IPosition3D i_position3D, int i_precision) {
        this(i_position3D, i_precision, false);
    }

    public SphereShape(IPosition3D i_position3D, int i_precision, boolean i_superimposed) {
        super(i_position3D);
        this.m_superimposed = i_superimposed;
        this.m_stripes = STRIPE_CACHE.get(i_precision);
        if (this.m_stripes == null) {
            Vector3fImpl a = new Vector3fImpl(CENTER);
            a.setX(a.getX() + 0.5f);
            Vector3fImpl b = new Vector3fImpl(CENTER);
            b.setY(b.getY() + 0.5f);
            Vector3fImpl c = new Vector3fImpl(CENTER);
            c.setZ(c.getZ() + 0.5f);
            Vector3fImpl d = new Vector3fImpl(CENTER);
            d.setZ(d.getZ() - 0.5f);
            this.m_stripes = new SphereTriangle[2][];
            this.m_stripes[0] = new SphereTriangle[]{new SphereTriangle((IVector3f)a, (IVector3f)b, (IVector3f)c)};
            this.m_stripes[1] = new SphereTriangle[]{new SphereTriangle((IVector3f)a, (IVector3f)b, (IVector3f)d)};
            int i = 1;
            while (i <= i_precision) {
                int numStripes = 2 << i;
                SphereTriangle[][] newStripes = new SphereTriangle[numStripes][];
                int j = 0;
                while (j < numStripes / 2) {
                    int numTriangles = j * 2 + 1;
                    newStripes[j] = new SphereTriangle[numTriangles];
                    newStripes[numStripes - j - 1] = new SphereTriangle[numTriangles];
                    ++j;
                }
                j = 0;
                while (j < this.m_stripes.length) {
                    SphereTriangle[] stripe = this.m_stripes[j];
                    SphereTriangle[] newUpper = newStripes[j * 2];
                    SphereTriangle[] newLower = newStripes[j * 2 + 1];
                    int upperIndex = 0;
                    int lowerIndex = 0;
                    int k = 0;
                    while (k < stripe.length) {
                        SphereTriangle triangle = stripe[k];
                        SphereTriangle[] subTriangles = triangle.divide(CENTER, 0.5f);
                        if (triangle.getC().getZ() > triangle.getA().getZ()) {
                            newUpper[upperIndex++] = subTriangles[0];
                            newLower[lowerIndex++] = subTriangles[1];
                            newLower[lowerIndex++] = subTriangles[2];
                            newLower[lowerIndex++] = subTriangles[3];
                        } else {
                            newLower[lowerIndex++] = subTriangles[0];
                            newUpper[upperIndex++] = subTriangles[1];
                            newUpper[upperIndex++] = subTriangles[2];
                            newUpper[upperIndex++] = subTriangles[3];
                        }
                        ++k;
                    }
                    ++j;
                }
                this.m_stripes = newStripes;
                ++i;
            }
            STRIPE_CACHE.put(i_precision, this.m_stripes);
        }
        this.m_outlineKey = new SphereKey(this.m_precision, true);
        this.m_fillKey = new SphereKey(this.m_precision, false);
    }

    @Override
    protected float doGetDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        float dot;
        Vector3f orth;
        Vector3f proj;
        Vector3f roToC;
        block3: {
            roToC = Draw3DCache.getVector3f();
            proj = Draw3DCache.getVector3f();
            orth = Draw3DCache.getVector3f();
            try {
                Math3D.sub((IVector3f)CENTER, (IVector3f)i_rayOrigin, (Vector3f)roToC);
                dot = Math3D.dot((IVector3f)roToC, (IVector3f)i_rayDirection);
                Math3D.scale((float)dot, (IVector3f)i_rayDirection, (Vector3f)proj);
                Math3D.sub((IVector3f)roToC, (IVector3f)proj, (Vector3f)orth);
                if (!(orth.lengthSquared() > 0.25f)) break block3;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{roToC, proj, orth});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{roToC, proj, orth});
            return Float.NaN;
        }
        float B = -2.0f * dot;
        float C = roToC.length() - 0.25f;
        Math3D.solveQuadraticEquation((float)B, (float)C, (float[])TMP_F2);
        float f = Math3D.minDistance((float[])TMP_F2);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{roToC, proj, orth});
        return f;
    }

    @Override
    protected void doRender(RenderContext i_renderContext) {
        Graphics3D g3d = i_renderContext.getGraphics3D();
        DisplayListManager displayListManager = i_renderContext.getGraphics3D().getDisplayListManager();
        this.initDisplayLists(displayListManager, g3d);
        if (this.m_fill) {
            g3d.glColor(this.m_fillColor, this.m_alpha);
            displayListManager.executeDisplayList((Object)this.m_fillKey);
        }
        if (this.m_outline) {
            g3d.glColor(this.m_outlineColor, this.m_alpha);
            displayListManager.executeDisplayList((Object)this.m_outlineKey);
        }
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return RenderFragment.RenderType.getRenderType(this.m_alpha, this.m_superimposed);
    }

    private void initDisplayLists(DisplayListManager i_manager, final Graphics3D i_graphics3D) {
        boolean initOutline;
        boolean initFill = this.m_fill && !i_manager.isDisplayList(new Object[]{this.m_fillKey});
        boolean bl = initOutline = this.m_outline && !i_manager.isDisplayList(new Object[]{this.m_outlineKey});
        if (!initFill && !initOutline) {
            return;
        }
        i_manager.interruptDisplayList();
        try {
            if (initFill) {
                i_manager.createDisplayList((Object)this.m_fillKey, new Runnable(){

                    public void run() {
                        i_graphics3D.glPushMatrix();
                        try {
                            SphereShape.this.renderFill(i_graphics3D);
                            int i = 0;
                            while (i < 3) {
                                i_graphics3D.setPosition(ROTATE_Z90);
                                SphereShape.this.renderFill(i_graphics3D);
                                ++i;
                            }
                        }
                        finally {
                            i_graphics3D.glPopMatrix();
                        }
                    }
                });
            }
            if (initOutline) {
                i_manager.createDisplayList((Object)this.m_outlineKey, new Runnable(){

                    public void run() {
                        i_graphics3D.glPushMatrix();
                        try {
                            SphereShape.this.renderOutline(i_graphics3D);
                            int i = 0;
                            while (i < 3) {
                                i_graphics3D.setPosition(ROTATE_Z90);
                                SphereShape.this.renderOutline(i_graphics3D);
                                ++i;
                            }
                        }
                        finally {
                            i_graphics3D.glPopMatrix();
                        }
                    }
                });
            }
        }
        finally {
            i_manager.resumeDisplayList();
        }
    }

    private void renderFill(Graphics3D i_g3d) {
        i_g3d.glColor4f(0.0f, 0.0f, 1.0f, 0.5f);
        i_g3d.glPolygonMode(1032, 6914);
        int i = 0;
        while (i < this.m_stripes.length) {
            int j;
            SphereTriangle[] stripe = this.m_stripes[i];
            if (i < this.m_stripes.length / 2) {
                i_g3d.glBegin(5);
                j = stripe.length - 1;
                while (j >= 0) {
                    i_g3d.glVertex3f(stripe[j].getB());
                    i_g3d.glVertex3f(stripe[j].getC());
                    j -= 2;
                }
                i_g3d.glVertex3f(stripe[0].getA());
                i_g3d.glEnd();
            } else {
                i_g3d.glBegin(5);
                j = 0;
                while (j < stripe.length) {
                    i_g3d.glVertex3f(stripe[j].getA());
                    i_g3d.glVertex3f(stripe[j].getC());
                    j += 2;
                }
                i_g3d.glVertex3f(stripe[stripe.length - 1].getB());
                i_g3d.glEnd();
            }
            ++i;
        }
    }

    private void renderOutline(Graphics3D i_g3d) {
        i_g3d.glColor4f(1.0f, 0.0f, 0.0f, 0.5f);
        int i = 0;
        while (i < this.m_stripes.length) {
            int j;
            SphereTriangle[] stripe = this.m_stripes[i];
            if (i < this.m_stripes.length / 2) {
                i_g3d.glBegin(3);
                j = 0;
                while (j < stripe.length) {
                    i_g3d.glVertex3f(stripe[j].getA());
                    j += 2;
                }
                i_g3d.glVertex3f(stripe[stripe.length - 1].getB());
                i_g3d.glEnd();
            } else if (i < this.m_stripes.length - 1) {
                i_g3d.glBegin(3);
                j = 1;
                while (j < stripe.length) {
                    i_g3d.glVertex3f(stripe[j].getA());
                    j += 2;
                }
                i_g3d.glVertex3f(stripe[stripe.length - 2].getB());
                i_g3d.glEnd();
            }
            i_g3d.glBegin(3);
            i_g3d.glVertex3f(stripe[0].getA());
            j = 0;
            while (j < stripe.length) {
                i_g3d.glVertex3f(stripe[j].getC());
                ++j;
            }
            i_g3d.glEnd();
            ++i;
        }
    }

    public void setAlpha(int i_alpha) {
        this.m_alpha = i_alpha;
    }

    public void setFill(boolean i_fill) {
        this.m_fill = i_fill;
    }

    public void setFillColor(Color i_color) {
        this.m_fillColor = i_color;
    }

    public void setOutline(boolean i_outline) {
        this.m_outline = i_outline;
    }

    public void setOutlineColor(Color i_color) {
        this.m_outlineColor = i_color;
    }

    private class SphereKey {
        private int m_hashCode = 17;

        public SphereKey(int i_precision, boolean i_outline) {
            this.m_hashCode = 37 * this.m_hashCode + new Integer(i_precision).hashCode();
            this.m_hashCode = 37 * this.m_hashCode + new Boolean(i_outline).hashCode();
        }

        public boolean equals(Object i_obj) {
            if (i_obj == null) {
                return false;
            }
            if (this == i_obj) {
                return true;
            }
            if (!(i_obj instanceof SphereKey)) {
                return false;
            }
            return this.m_hashCode == i_obj.hashCode();
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }
}

