/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.amp.escape.ide.LoaderCreationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLoader
extends URLClassLoader {
    IProject project;
    public ClassLoader mainLoader;
    private Bundle bundle;

    public ProjectLoader(IProject project) throws LoaderCreationException {
        super(new URL[0]);
        this.project = project;
        try {
            project.open(null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ArrayList<URL> outputURL = new ArrayList<URL>();
            outputURL.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
            for (URL url : outputURL) {
                this.addURL(url);
            }
            this.activate();
        }
        catch (Exception e1) {
            throw new LoaderCreationException("Couldn't load class", e1);
        }
    }

    public void activate() throws LoaderCreationException {
        this.bundle = Platform.getBundle((String)"org.eclipse.amp.escape.runtime");
        this.mainLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this);
    }

    public void restore() {
        Thread.currentThread().setContextClassLoader(this.mainLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> loadClass = super.loadClass(name);
            return loadClass;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Class loadClassI = this.bundle.loadClass(name);
            return loadClassI;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Class loadClassI = this.bundle.loadClass(name);
            return loadClassI;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class loadClassI = this.bundle.loadClass(name);
            return loadClassI;
        }
        catch (UnsupportedClassVersionError classNotFoundException) {
            throw new RuntimeException("Bad class: " + name, classNotFoundException);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception for " + name, e);
        }
    }
}

