/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.ide.repast;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.amp.amf.ide.Configurator;
import org.eclipse.amp.amf.ide.RuntimeConfigurator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.statushandlers.StatusManager;
import org.metaabm.SContext;
import org.metaabm.SImplementation;
import org.metaabm.xsd.MetaABMPersist;

public class RepastRuntimeConfigurator
extends RuntimeConfigurator {
    public static final Configurator REPAST_CONFIGURATOR = new RepastRuntimeConfigurator();
    public static final String REPAST_SUPPORT_PATH = "REPAST_SIMPHONY_SUPPORT";
    public static final String JAR_CLASSPATH_DEFAULT = "REPAST_SIMPHONY_LAUNCHER";

    public void configure(ILaunchConfigurationWorkingCopy config, IResource model) {
        super.configure(config, model);
        try {
            ArrayList<String> classpath = new ArrayList<String>();
            Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
            classpath.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1).getMemento());
            Path repastPath = new Path(JAR_CLASSPATH_DEFAULT);
            classpath.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)repastPath, (int)3).getMemento());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.amf.ide.repast", "Couldn't set classpath. Is Simphony installed?.", (Throwable)e));
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "repast.simphony.runtime.RepastMain");
        if (model != null) {
            File file = model.getLocation().toFile();
            try {
                String scoreDir = "";
                if (model.getLocation().getFileExtension().equals("metaabm")) {
                    SContext context = MetaABMPersist.create((File)file).load();
                    SImplementation impl = context.getImplementation();
                    scoreDir = String.valueOf(model.getLocation().removeLastSegments(1).toOSString()) + File.separatorChar + impl.getClassName() + ".rs";
                } else if (model.getLocation().getFileExtension().equals("score")) {
                    scoreDir = model.getLocation().removeLastSegments(1).makeAbsolute().toOSString();
                } else if (model.getLocation().getFileExtension().equals("rs")) {
                    scoreDir = model.getLocation().makeAbsolute().toOSString();
                } else {
                    StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.amf.ide.repast", "Tried to configure runtime for unknown model type: " + file));
                }
                scoreDir = "\"" + scoreDir + "\"";
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, scoreDir);
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.amf.ide.repast", "Couldn't load model.", (Throwable)e));
            }
        }
    }

    public void configureForLaunch(ILaunchConfigurationWorkingCopy config, IResource model) {
        this.configure(config, model);
    }
}

