/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.nio.ByteBuffer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw3d.util.BufferUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;

public class ImageConverter {
    private static final int A = 3;
    private static final int B = 2;
    private static final int G = 1;
    private static final int POS_B;
    private static final int POS_G;
    private static final int POS_R;
    private static final int R = 0;

    static {
        if (Platform.getOS().startsWith("Windows")) {
            POS_B = 0;
            POS_G = 1;
            POS_R = 2;
        } else {
            POS_B = 3;
            POS_G = 2;
            POS_R = 1;
        }
    }

    public static ImageData colorBufferToImage(ByteBuffer i_buffer, int i_pixelFormat, int i_dataType, int i_width, int i_height) {
        if (i_buffer == null) {
            throw new NullPointerException("i_buffer must not be null");
        }
        int bpp = ImageConverter.getColorBpp(i_pixelFormat, i_dataType);
        int[] offsets = ImageConverter.getOffsets(i_pixelFormat, i_dataType);
        int size = i_width * i_height;
        int imageSize = size * 3;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        byte[] data = new byte[imageSize];
        ImageData imageData = new ImageData(i_width, i_height, 24, palette, 1, data);
        byte[] alpha = null;
        if (offsets[3] != -1) {
            alpha = new byte[size];
            imageData.alphaData = alpha;
        }
        int y = 0;
        while (y < i_height) {
            int x = 0;
            while (x < i_width) {
                int sIndex = ((i_height - y - 1) * i_width + x) * bpp;
                int dIndex = (y * i_width + x) * 3;
                int aIndex = y * i_width + x;
                if (offsets[0] != -1) {
                    data[dIndex + 0] = i_buffer.get(sIndex + offsets[0]);
                }
                if (offsets[1] != -1) {
                    data[dIndex + 1] = i_buffer.get(sIndex + offsets[1]);
                }
                if (offsets[2] != -1) {
                    data[dIndex + 2] = i_buffer.get(sIndex + offsets[2]);
                }
                if (offsets[3] != -1 && alpha != null) {
                    alpha[aIndex] = i_buffer.get(sIndex + offsets[3]);
                }
                ++x;
            }
            ++y;
        }
        return imageData;
    }

    public static int getColorBpp(int i_pixelFormat, int i_dataType) {
        int bpp;
        switch (i_pixelFormat) {
            case 6400: 
            case 6401: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: {
                bpp = 1;
                break;
            }
            case 6402: 
            case 6410: {
                bpp = 2;
                break;
            }
            case 6407: 
            case 32992: {
                bpp = 3;
                break;
            }
            case 6408: 
            case 32993: {
                bpp = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unuspported pixel format: " + i_pixelFormat);
            }
        }
        switch (i_dataType) {
            case 32818: 
            case 33634: {
                bpp = 1;
                break;
            }
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                bpp = 2;
                break;
            }
            case 32821: 
            case 32822: 
            case 33639: 
            case 33640: {
                bpp = 4;
                break;
            }
            case 5120: 
            case 5121: {
                bpp *= 1;
                break;
            }
            case 5122: 
            case 5123: {
                bpp *= 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                bpp *= 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unuspported data type: " + i_dataType);
            }
        }
        return bpp;
    }

    public static int[] getOffsets(int i_pixelFormat, int i_dataType) {
        int a;
        int b;
        int g;
        int r;
        switch (i_pixelFormat) {
            case 6407: {
                r = 0;
                g = 1;
                b = 2;
                a = -1;
                break;
            }
            case 32992: {
                r = 2;
                g = 1;
                b = 0;
                a = -1;
                break;
            }
            case 6408: {
                r = 0;
                g = 1;
                b = 2;
                a = 3;
                break;
            }
            case 32993: {
                r = 2;
                g = 1;
                b = 0;
                a = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported pixel format: " + i_pixelFormat);
            }
        }
        switch (i_dataType) {
            case 5121: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported data type: " + i_dataType);
            }
        }
        r = Math.max(r, -1);
        g = Math.max(g, -1);
        b = Math.max(b, -1);
        a = Math.max(a, -1);
        return new int[]{r, g, b, a};
    }

    public static ByteBuffer imageToColorBuffer(Image i_image, ConversionSpecs i_specs, ByteBuffer io_buffer) {
        if (i_image == null) {
            throw new NullPointerException("i_image must not be null");
        }
        if (i_specs == null) {
            throw new NullPointerException("i_specs must not be null");
        }
        Rectangle iBounds = i_image.getBounds();
        int iWidth = iBounds.width;
        int iHeight = iBounds.height;
        Rectangle clip = i_specs.clip;
        if (clip == null) {
            clip = iBounds;
        } else {
            if (clip.x > iWidth || clip.y > iHeight) {
                throw new IllegalArgumentException("clip region is outside of image bounds");
            }
            if (clip.x + clip.width > iWidth) {
                clip.width = iWidth - clip.x;
            }
            if (clip.y + clip.height > iHeight) {
                clip.height = iHeight - clip.y;
            }
        }
        int tWidth = i_specs.textureWidth;
        int tHeight = i_specs.textureHeight;
        if (tWidth < clip.width || tHeight < clip.height) {
            throw new IllegalArgumentException("texture dimensions are too small for clip region");
        }
        Color trColor = i_specs.transparentColor;
        Color bgColor = i_specs.backgroundColor;
        int fgAlpha = i_specs.foregroundAlpha;
        int bgAlpha = i_specs.backgroundAlpha;
        ImageData imageData = i_image.getImageData();
        int srcFormat = imageData.depth / 8;
        int dstFormat = 4;
        int size = tWidth * tHeight * dstFormat;
        ByteBuffer buffer = io_buffer;
        if (buffer == null || size > buffer.capacity()) {
            buffer = BufferUtils.createByteBuffer(size);
        } else if (size < buffer.capacity()) {
            buffer.limit(size);
        }
        byte trR = trColor != null ? (byte)trColor.getRed() : (byte)0;
        byte trG = trColor != null ? (byte)trColor.getGreen() : (byte)0;
        byte trB = trColor != null ? (byte)trColor.getBlue() : (byte)0;
        byte bgR = bgColor != null ? (byte)bgColor.getRed() : (byte)0;
        byte bgG = bgColor != null ? (byte)bgColor.getGreen() : (byte)0;
        byte bgB = bgColor != null ? (byte)bgColor.getBlue() : (byte)0;
        byte bgAlphaByte = (byte)bgAlpha;
        int y = 0;
        while (y < tHeight) {
            int x = 0;
            while (x < tWidth) {
                if (x < clip.width && y < clip.height) {
                    int index = i_specs.flip ? (iHeight - clip.y - y - 1) * iWidth + clip.x + x : (clip.y + y) * iWidth + clip.x + x;
                    byte r = imageData.data[index * srcFormat + POS_R];
                    byte g = imageData.data[index * srcFormat + POS_G];
                    byte b = imageData.data[index * srcFormat + POS_B];
                    byte a = imageData.alphaData[index];
                    if (trColor != null && bgColor != null && r == trR && g == trG && b == trB) {
                        r = bgR;
                        g = bgG;
                        b = bgB;
                        a = bgAlphaByte;
                    }
                    buffer.put(r);
                    buffer.put(g);
                    buffer.put(b);
                    buffer.put(a);
                } else {
                    buffer.put(bgR);
                    buffer.put(bgG);
                    buffer.put(bgB);
                    buffer.put(bgAlphaByte);
                }
                ++x;
            }
            ++y;
        }
        buffer.rewind();
        return buffer;
    }

    public static ByteBuffer imageToLuminanceAlphaBuffer(Image i_image, ConversionSpecs i_specs, ByteBuffer io_buffer) {
        if (i_image == null) {
            throw new NullPointerException("i_image must not be null");
        }
        if (i_specs == null) {
            throw new NullPointerException("i_specs must not be null");
        }
        Rectangle iBounds = i_image.getBounds();
        int iWidth = iBounds.width;
        int iHeight = iBounds.height;
        Rectangle clip = i_specs.clip;
        if (clip == null) {
            clip = iBounds;
        } else {
            if (clip.x > iWidth || clip.y > iHeight) {
                throw new IllegalArgumentException("clip region is outside of image bounds");
            }
            if (clip.x + clip.width > iWidth) {
                clip.width = iWidth - clip.x;
            }
            if (clip.y + clip.height > iHeight) {
                clip.height = iHeight - clip.y;
            }
        }
        int tWidth = i_specs.textureWidth;
        int tHeight = i_specs.textureHeight;
        if (tWidth < clip.width || tHeight < clip.height) {
            throw new IllegalArgumentException("texture dimensions are too small for clip region");
        }
        ImageData imageData = i_image.getImageData();
        int srcFormat = imageData.depth / 8;
        int dstFormat = 2;
        int size = tWidth * tHeight * dstFormat;
        ByteBuffer buffer = io_buffer;
        if (buffer == null || size > buffer.capacity()) {
            buffer = BufferUtils.createByteBuffer(size);
        } else if (size < buffer.capacity()) {
            buffer.limit(size);
        }
        byte bg = 0;
        int y = 0;
        while (y < tHeight) {
            int x = 0;
            while (x < tWidth) {
                if (x < clip.width && y < clip.height) {
                    int index = ((clip.y + y) * iWidth + clip.x + x) * srcFormat;
                    byte r = imageData.data[index + POS_R];
                    byte g = imageData.data[index + POS_G];
                    byte b = imageData.data[index + POS_B];
                    byte l = (byte)Math.round((double)(r + g + b) / 3.0);
                    byte a = (byte)(255 - l);
                    buffer.put(l);
                    buffer.put(a);
                } else {
                    buffer.put(bg);
                    buffer.put(bg);
                }
                ++x;
            }
            ++y;
        }
        buffer.rewind();
        return buffer;
    }

    public static class ConversionSpecs {
        public int backgroundAlpha;
        public Color backgroundColor;
        public Rectangle clip;
        public boolean flip = false;
        public int foregroundAlpha;
        public int textureHeight;
        public int textureWidth;
        public Color transparentColor;
    }
}

