/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw3d.RenderContext;

public interface RenderFragment {
    public float getDistanceMeasure(RenderContext var1);

    public RenderType getRenderType();

    public void render(RenderContext var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderType {
        IGNORE,
        OPAQUE,
        SUPERIMPOSED,
        TRANSPARENT;


        public static RenderType getRenderType(int i_alpha, boolean i_superimposed) {
            if (i_superimposed) {
                return SUPERIMPOSED;
            }
            if (i_alpha < 255) {
                return TRANSPARENT;
            }
            return OPAQUE;
        }

        public void orderFragments(RenderContext i_renderContext, List<RenderFragment> i_fragments) {
            if (i_renderContext == null) {
                throw new NullPointerException("i_renderContext must not be null");
            }
            if (i_fragments == null) {
                throw new NullPointerException("i_fragments must not be null");
            }
            switch (this) {
                case IGNORE: 
                case OPAQUE: {
                    return;
                }
                case SUPERIMPOSED: 
                case TRANSPARENT: {
                    Collections.sort(i_fragments, new FragmentComparator(i_renderContext));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FragmentComparator
        implements Comparator<RenderFragment> {
            private Map<RenderFragment, Float> m_cache = new HashMap<RenderFragment, Float>();
            private RenderContext m_renderContext;

            public FragmentComparator(RenderContext i_renderContext) {
                this.m_renderContext = i_renderContext;
            }

            @Override
            public int compare(RenderFragment i_f1, RenderFragment i_f2) {
                float d1 = this.getDistanceMeasure(i_f1);
                float d2 = this.getDistanceMeasure(i_f2);
                return Float.compare(d2, d1);
            }

            private float getDistanceMeasure(RenderFragment i_f) {
                if (this.m_cache.containsKey(i_f)) {
                    return this.m_cache.get(i_f).floatValue();
                }
                float d = i_f.getDistanceMeasure(this.m_renderContext);
                this.m_cache.put(i_f, Float.valueOf(d));
                return d;
            }
        }
    }
}

