/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.ICompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class BeginWhileRule
extends Rule {
    private RegExpSource _begin;
    public List<CaptureRule> beginCaptures;
    public List<CaptureRule> whileCaptures;
    private RegExpSource _while;
    public boolean whileHasBackReferences;
    public boolean hasMissingPatterns;
    public Integer[] patterns;
    private RegExpSourceList _cachedCompiledPatterns;
    private RegExpSourceList _cachedCompiledWhilePatterns;

    public BeginWhileRule(int id, String name, String contentName, String begin, List<CaptureRule> beginCaptures, String _while, List<CaptureRule> whileCaptures, ICompilePatternsResult patterns) {
        super(id, name, contentName);
        this._begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.whileCaptures = whileCaptures;
        this._while = new RegExpSource(_while, -2);
        this.whileHasBackReferences = this._while.hasBackReferences;
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
        this._cachedCompiledPatterns = null;
        this._cachedCompiledWhilePatterns = null;
    }

    public String getWhileWithResolvedBackReferences(String lineText, IOnigCaptureIndex[] captureIndices) {
        return this._while.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        if (isFirst) {
            int i = 0;
            while (i < this.patterns.length) {
                Rule rule = grammar.getRule(this.patterns[i]);
                rule.collectPatternsRecursive(grammar, out, false);
                ++i;
            }
        } else {
            out.push(this._begin);
        }
    }

    @Override
    public ICompiledRule compile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        this._precompile(grammar);
        return this._cachedCompiledPatterns.compile(grammar, allowA, allowG);
    }

    private void _precompile(IRuleRegistry grammar) {
        if (this._cachedCompiledPatterns == null) {
            this._cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, this._cachedCompiledPatterns, true);
        }
    }

    public ICompiledRule compileWhile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        this._precompileWhile(grammar);
        if (this._while.hasBackReferences) {
            this._cachedCompiledWhilePatterns.setSource(0, endRegexSource);
        }
        return this._cachedCompiledWhilePatterns.compile(grammar, allowA, allowG);
    }

    private void _precompileWhile(IRuleRegistry grammar) {
        if (this._cachedCompiledWhilePatterns == null) {
            this._cachedCompiledWhilePatterns = new RegExpSourceList();
            this._cachedCompiledWhilePatterns.push(this._while.hasBackReferences ? this._while.clone() : this._while);
        }
    }
}

