/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.Platform;

public class DotnetVersionUtil {
    public static final int MINIMUM_MAJOR_VERSION = 2;

    public static boolean isValidVersionFormat(String version) {
        return !version.isEmpty() && version.matches("\\d+\\.\\d+\\.\\d+.*");
    }

    public static boolean isValidVersionNumber(String version) {
        return DotnetVersionUtil.getMajorVersionNumber(version) >= 2;
    }

    public static int getMajorVersionNumber(String version) {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    public static String getVersion(String dotnetPath) {
        try {
            ProcessBuilder builder;
            Process process;
            String[] command = new String[]{"/bin/bash", "-c", String.valueOf(dotnetPath) + " --version"};
            if (Platform.getOS().equals("win32")) {
                command = new String[]{"cmd", "/c", "\"" + dotnetPath + "\" --version"};
            }
            if ((process = (builder = new ProcessBuilder(command)).start()).waitFor() == 0) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    return in.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }
}

