/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.property;

import java.util.List;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class AcceleoPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean res;
        switch (property) {
            case "isMain": {
                if (receiver instanceof IFile) {
                    res = AcceleoPlugin.isAcceleoMain((IResource)((IFile)receiver));
                    break;
                }
                res = false;
                break;
            }
            case "isBlockSelection": {
                if (receiver instanceof ITextSelection) {
                    ITextSelection selection = (ITextSelection)receiver;
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
                        if (activeEditor instanceof TextEditor) {
                            IDocument document = ((TextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                            if (selection.getOffset() - 1 < document.getLength()) {
                                boolean startAtNewLine = selection.getOffset() == 0 || document.get().charAt(selection.getOffset() - 1) == '\n' || document.get().charAt(selection.getOffset() - 1) == '\r';
                                res = startAtNewLine && (!selection.isEmpty() || !selection.getText().endsWith("\n")) && !selection.getText().endsWith("\r");
                                break;
                            }
                            res = false;
                            break;
                        }
                        res = false;
                        break;
                    }
                    res = false;
                    break;
                }
                res = false;
                break;
            }
            case "isAcceleoTextSelection": {
                if (receiver instanceof ITextSelection) {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
                        if (activeEditor instanceof TextEditor) {
                            IDocument document = ((TextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                            List contentTypes = LSPEclipseUtils.getDocumentContentTypes((IDocument)document);
                            boolean foundAcceleoContentType = false;
                            for (IContentType contentType : contentTypes) {
                                if (!"Acceleo".equals(contentType.getName())) continue;
                                foundAcceleoContentType = true;
                                break;
                            }
                            res = foundAcceleoContentType;
                            break;
                        }
                        res = false;
                        break;
                    }
                    res = false;
                    break;
                }
                res = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unkown property" + property);
            }
        }
        return res;
    }
}

