/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;

public final class AcceleoRefactoringUtils {
    private static final String SLASH = "/";

    private AcceleoRefactoringUtils() {
    }

    public static IPath getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder.getFullPath();
            }
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    public static ICompilationUnit getJavaCompilationUnitFromModuleFile(IProject project, IFile moduleFile) {
        ICompilationUnit compilationUnit = null;
        IPath path = moduleFile.getProjectRelativePath().removeLastSegments(1);
        String str = path.toString();
        String moduleName = moduleFile.getName().substring(0, moduleFile.getName().length() - (moduleFile.getFileExtension().length() + 1));
        path = new Path(str = String.valueOf(str) + SLASH + moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1));
        IFile file = project.getFile(path.addFileExtension("java"));
        if (file.exists()) {
            compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        return compilationUnit;
    }

    public static IFile getJavaFileFromModuleFile(IProject project, IFile moduleFile) {
        IFile file = null;
        IPath path = moduleFile.getProjectRelativePath().removeFileExtension();
        path = path.addFileExtension("java");
        file = project.getFile(path);
        return file;
    }

    public static Module getModuleFromFile(IFile moduleFile) {
        Module mod = null;
        AcceleoProject acceleoProject = new AcceleoProject(moduleFile.getProject());
        List<URI> uriList = acceleoProject.getOutputFiles();
        for (URI uri : uriList) {
            IPath path = acceleoProject.getOutputFilePath(moduleFile);
            URI moduleFileURI = null;
            if (path != null) {
                moduleFileURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            }
            if (!uri.equals(moduleFileURI)) continue;
            try {
                EObject eObject = AcceleoUIResourceSet.getResource(moduleFileURI);
                EcoreUtil.resolveAll((Resource)eObject.eResource());
                if (!(eObject instanceof Module)) continue;
                mod = (Module)eObject;
                break;
            }
            catch (IOException e) {
                AcceleoUIActivator.log(e, true);
            }
        }
        return mod;
    }

    public static boolean containsAcceleoError(IFile file) {
        boolean result = false;
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.acceleo.ide.ui.problem", true, 2);
            if (markers.length > 0) {
                result = true;
            }
        }
        catch (CoreException e) {
            result = true;
        }
        return result;
    }

    public static boolean allResourceSaved() {
        ArrayList<AcceleoEditor> dirtyEditorList = new ArrayList<AcceleoEditor>();
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IEditorPart[] editors;
            IEditorPart[] iEditorPartArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart iEditorPart = iEditorPartArray[n2];
                if (iEditorPart instanceof AcceleoEditor) {
                    dirtyEditorList.add((AcceleoEditor)iEditorPart);
                }
                ++n2;
            }
        }
        if (dirtyEditorList.size() > 0) {
            for (AcceleoEditor acceleoEditor : dirtyEditorList) {
                ISaveablesLifecycleListener modelManager = (ISaveablesLifecycleListener)acceleoEditor.getSite().getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
                Saveable[] saveableArray = acceleoEditor.getSaveables();
                SaveablesLifecycleEvent event = new SaveablesLifecycleEvent((Object)acceleoEditor, 2, saveableArray, false);
                modelManager.handleLifecycleEvent(event);
            }
            boolean allSaved = true;
            for (AcceleoEditor acceleoEditor : dirtyEditorList) {
                if (!acceleoEditor.isDirty()) continue;
                allSaved = false;
                break;
            }
            return allSaved;
        }
        return true;
    }
}

