/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportCompleteOCLResourceDialog
extends LoadResourceAction.LoadResourceDialog {
    protected static final String[] FILE_EXTENSIONS = new String[]{"ocl"};
    private TextViewer viewer;

    public ImportCompleteOCLResourceDialog(Shell parent, TextViewer viewer) {
        super(parent);
        this.viewer = viewer;
        int shellStyle = this.getShellStyle();
        int newShellStyle = shellStyle & 0xFFFFFFFD;
        this.setShellStyle(newShellStyle);
    }

    protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
        final String[] extensionsFilter = new String[FILE_EXTENSIONS.length];
        int i = 0;
        while (i < FILE_EXTENSIONS.length) {
            extensionsFilter[i] = "*." + FILE_EXTENSIONS[i];
            ++i;
        }
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(ImportCompleteOCLResourceDialog.this.getShell(), ImportCompleteOCLResourceDialog.this.style);
                fileDialog.setFilterExtensions(extensionsFilter);
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName != null) {
                    ImportCompleteOCLResourceDialog.this.uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                }
            }
        });
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new BrowseWorkspaceSelectionListener());
    }

    protected boolean processResources() {
        List uris = this.getURIs();
        if (!uris.isEmpty()) {
            this.copyContentToViewer((URI)uris.get(0));
        }
        return true;
    }

    private void copyContentToViewer(URI uri) {
        block13: {
            BufferedReader reader = null;
            try {
                try {
                    InputStream fileContent = this.getFileContent(uri);
                    reader = new BufferedReader(new InputStreamReader(fileContent));
                    StringBuffer stringContent = new StringBuffer();
                    String line = reader.readLine();
                    while (line != null) {
                        stringContent.append(line);
                        stringContent.append('\n');
                        line = reader.readLine();
                    }
                    this.viewer.getDocument().set(stringContent.toString());
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", e.getMessage(), (Throwable)e);
                    InterpreterPlugin.getDefault().getLog().log((IStatus)status);
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private InputStream getFileContent(URI uri) throws IOException {
        ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl();
        URIHandler handler = converter.getURIHandler(uri);
        if (handler != null) {
            return handler.createInputStream(uri, new HashMap());
        }
        throw new IOException("Could not load " + uri);
    }

    protected class BrowseWorkspaceSelectionListener
    extends SelectionAdapter {
        protected BrowseWorkspaceSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ViewerFilter extensionFilter = new ViewerFilter(){

                public boolean select(Viewer filteredViewer, Object parentElement, Object element) {
                    if (element instanceof IFile) {
                        return Arrays.asList(FILE_EXTENSIONS).contains(((IFile)element).getFileExtension());
                    }
                    return true;
                }
            };
            IFile file = null;
            if (ImportCompleteOCLResourceDialog.this.isSave()) {
                String path = this.getContextPath();
                file = WorkspaceResourceDialog.openNewFile((Shell)ImportCompleteOCLResourceDialog.this.getShell(), null, null, (IPath)(path != null ? new Path(path) : null), Arrays.asList(extensionFilter));
            } else {
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)ImportCompleteOCLResourceDialog.this.getShell(), null, null, (boolean)false, (Object[])this.getContextSelection(), Arrays.asList(extensionFilter));
                if (files.length != 0) {
                    file = files[0];
                }
            }
            if (file != null) {
                ImportCompleteOCLResourceDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
            }
        }

        private String getContextPath() {
            return ImportCompleteOCLResourceDialog.this.context != null && ImportCompleteOCLResourceDialog.this.context.isPlatformResource() ? URI.createURI((String)".").resolve(ImportCompleteOCLResourceDialog.this.context).path().substring(9) : null;
        }

        private Object[] getContextSelection() {
            IWorkspaceRoot root;
            IResource resource;
            String path = this.getContextPath();
            if (path != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && resource.isAccessible()) {
                return new Object[]{resource};
            }
            return null;
        }
    }
}

