/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.EvaluationResultFactory;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OperationElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.Severity;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.ocl.AbstractOCLEvaluator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;

public class CompleteOCLEvaluator
extends AbstractOCLEvaluator {
    private final EnvironmentFactory environmentFactory;
    private final MetamodelManager metamodelManager;
    private final CompleteModel completeModel;

    public CompleteOCLEvaluator(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.completeModel = environmentFactory.getCompleteModel();
    }

    protected EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EvaluationResult evaluateCompleteOCLElement(Element pivotElement, Notifier evaluationTarget) {
        ExpressionInOCL expression;
        OCLElement oclElement;
        if (pivotElement instanceof Model) {
            oclElement = this.createOCLElement((EObject)pivotElement);
            for (Package pack : ((Model)pivotElement).getOwnedPackages()) {
                this.checkCancelled();
                oclElement.getChildren().add((Object)this.evaluateCompleteOCLExpression(pack, null, evaluationTarget));
            }
            return new EvaluationResult((Object)oclElement);
        }
        if (pivotElement instanceof Package) {
            oclElement = this.evaluateCompleteOCLExpression((Package)pivotElement, null, evaluationTarget);
            return new EvaluationResult((Object)oclElement);
        }
        if (pivotElement instanceof Class) {
            Package packaje = ((Class)pivotElement).getOwningPackage();
            OCLElement packageElement = this.evaluateCompleteOCLExpression(packaje, (Class)pivotElement, evaluationTarget);
            oclElement = (OCLElement)packageElement.getChildren().get(0);
            return new EvaluationResult((Object)oclElement);
        }
        if (pivotElement instanceof Constraint) {
            if (!(evaluationTarget instanceof EObject) || !this.checkType((Constraint)pivotElement, (EObject)evaluationTarget)) return new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + pivotElement + " on the selected Notifier."));
            oclElement = EvaluationResultFactory.eINSTANCE.createConstraintElement();
            oclElement.setElement((EObject)pivotElement);
            ConstraintResult result = this.evaluateExpression((Constraint)pivotElement, (EObject)evaluationTarget);
            ((ConstraintElement)oclElement).getConstraintResults().add((Object)result);
            return new EvaluationResult((Object)oclElement);
        }
        if (!(pivotElement instanceof Operation)) return new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression."));
        if (!(evaluationTarget instanceof EObject) || ((Operation)pivotElement).getParameterTypes().get().length != 0 || !this.checkType((Type)((Operation)pivotElement).getOwningClass(), (EObject)evaluationTarget)) return new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + pivotElement + " on the selected Notifier."));
        LanguageExpression spec = ((Operation)pivotElement).getBodyExpression();
        try {
            expression = this.metamodelManager.parseSpecification(spec);
        }
        catch (ParserException e) {
            return new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression.", (Throwable)e));
        }
        EvaluationResult result = this.evaluateExpression(expression, (EObject)evaluationTarget);
        oclElement = EvaluationResultFactory.eINSTANCE.createOperationElement();
        oclElement.setElement((EObject)pivotElement);
        ((OperationElement)oclElement).getEvaluationResults().add((Object)this.parseOperationResult((EObject)evaluationTarget, result));
        return new EvaluationResult((Object)oclElement);
    }

    private boolean checkType(Constraint constraint, EObject target) {
        Namespace namespace = constraint.getContext();
        return namespace instanceof Type && this.checkType((Type)namespace, target);
    }

    private boolean checkType(Type type, EObject target) {
        Type targetType;
        try {
            targetType = (Type)this.metamodelManager.getASOf(Type.class, (EObject)target.eClass());
        }
        catch (ParserException e) {
            InterpreterPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", e.getMessage(), (Throwable)e));
            return false;
        }
        return this.completeModel.conformsTo(targetType, null, type, null);
    }

    private Map<Class, Set<Class>> getRelatedTypes(Package packaje) {
        LinkedHashMap<Class, Set<Class>> types = new LinkedHashMap<Class, Set<Class>>();
        for (Class type : packaje.getOwnedClasses()) {
            Class key = this.completeModel.getCompleteClass((Type)type).getPrimaryClass();
            LinkedHashSet<Class> relatedTypes = (LinkedHashSet<Class>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Class>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(type);
        }
        return types;
    }

    private Map<Class, Set<Class>> getRelatedTypes(Class type) {
        Package packaje = type.getOwningPackage();
        if (packaje == null) {
            return Collections.singletonMap(type, Collections.singleton(type));
        }
        Class key = this.completeModel.getCompleteClass((Type)type).getPrimaryClass();
        LinkedHashMap<Class, Set<Class>> types = new LinkedHashMap<Class, Set<Class>>();
        for (Class candidate : packaje.getOwnedClasses()) {
            Class candidateKey = this.completeModel.getCompleteClass((Type)candidate).getPrimaryClass();
            if (key != candidateKey) continue;
            LinkedHashSet<Class> relatedTypes = (LinkedHashSet<Class>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Class>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(candidate);
        }
        return types;
    }

    private OCLElement evaluateCompleteOCLExpression(Package compiledExpression, Class type, Notifier evaluationTarget) {
        OCLElement oclElement = this.createOCLElement((EObject)compiledExpression);
        Map<Class, Set<Class>> types = type != null ? this.getRelatedTypes(type) : this.getRelatedTypes(compiledExpression);
        this.checkCancelled();
        Iterable<Object> candidates = evaluationTarget instanceof EObject ? Collections.singleton((EObject)evaluationTarget) : (evaluationTarget instanceof Resource ? new AllContentsIterable((Resource)evaluationTarget) : Collections.emptyList());
        for (Map.Entry<Class, Set<Class>> entry : types.entrySet()) {
            this.checkCancelled();
            oclElement.getChildren().add((Object)this.checkTypeAndEvaluate(entry, candidates));
        }
        return oclElement;
    }

    private OCLElement checkTypeAndEvaluate(Map.Entry<Class, Set<Class>> relatedTypes, Iterable<EObject> targetCandidates) {
        OCLElement typeElement = this.createOCLElement((EObject)relatedTypes.getKey());
        ArrayList<EObject> conformingTargets = new ArrayList<EObject>();
        for (EObject candidate : targetCandidates) {
            this.checkCancelled();
            if (!this.checkType((Type)relatedTypes.getKey(), candidate)) continue;
            conformingTargets.add(candidate);
        }
        typeElement.getChildren().addAll(this.evaluateCompleteOCLExpression(relatedTypes, conformingTargets));
        return typeElement;
    }

    private OCLElement createOCLElement(EObject expression) {
        OCLElement element = EvaluationResultFactory.eINSTANCE.createOCLElement();
        element.setElement(expression);
        return element;
    }

    private List<OCLElement> evaluateCompleteOCLExpression(Map.Entry<Class, Set<Class>> relatedTypes, List<EObject> conformTargets) {
        ArrayList<OCLElement> childrenResult = new ArrayList<OCLElement>();
        for (Class type : relatedTypes.getValue()) {
            ArrayList<OCLResult> results;
            this.checkCancelled();
            for (Constraint constraint : type.getOwnedInvariants()) {
                this.checkCancelled();
                results = new ArrayList<OCLResult>(conformTargets.size());
                for (EObject target : conformTargets) {
                    results.add(this.evaluateExpression(constraint, target));
                }
                if (results.isEmpty()) continue;
                ConstraintElement constraintElement = EvaluationResultFactory.eINSTANCE.createConstraintElement();
                constraintElement.setElement((EObject)constraint);
                constraintElement.getConstraintResults().addAll(results);
                childrenResult.add(constraintElement);
            }
            for (Operation operation : type.getOwnedOperations()) {
                this.checkCancelled();
                if (operation.getParameterTypes().get().length != 0) continue;
                results = new ArrayList(conformTargets.size());
                for (EObject target : conformTargets) {
                    EvaluationResult childResult;
                    LanguageExpression spec = operation.getBodyExpression();
                    try {
                        ExpressionInOCL expression = this.metamodelManager.parseSpecification(spec);
                        childResult = this.evaluateExpression(expression, target);
                    }
                    catch (ParserException e) {
                        childResult = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression.", (Throwable)e));
                    }
                    results.add(this.parseOperationResult(target, childResult));
                }
                if (results.isEmpty()) continue;
                OperationElement operationElement = EvaluationResultFactory.eINSTANCE.createOperationElement();
                operationElement.setElement((EObject)operation);
                operationElement.getEvaluationResults().addAll(results);
                childrenResult.add(operationElement);
            }
        }
        return childrenResult;
    }

    private ConstraintResult evaluateExpression(Constraint constraint, EObject evaluationTarget) {
        EvaluationResult result;
        LanguageExpression spec = constraint.getOwnedSpecification();
        ExpressionInOCL expressionInOCL = null;
        try {
            expressionInOCL = this.metamodelManager.parseSpecification(spec);
            OCLExpression expression = AbstractConstraintEvaluator.getConstraintExpression((ExpressionInOCL)expressionInOCL);
            result = this.internalEvaluateExpression(expression, evaluationTarget);
        }
        catch (ParserException e) {
            result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression.", (Throwable)e));
        }
        return new OCLConstraintParser(expressionInOCL).parse(evaluationTarget, result);
    }

    private OCLResult parseOperationResult(EObject evaluationTarget, EvaluationResult result) {
        OCLResult operationResult = EvaluationResultFactory.eINSTANCE.createOCLResult();
        operationResult.setEvaluationTarget(evaluationTarget);
        operationResult.setInterpreterResult(result);
        return operationResult;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    private static class AllContentsIterable
    implements Iterable<EObject> {
        private Resource resource;

        public AllContentsIterable(Resource resource) {
            this.resource = resource;
        }

        @Override
        public Iterator<EObject> iterator() {
            return this.resource.getAllContents();
        }
    }

    private class OCLConstraintParser
    extends AbstractConstraintEvaluator<ConstraintResult> {
        private EObject currentevaluationTarget;

        public OCLConstraintParser(ExpressionInOCL expression) {
            super(expression);
        }

        public ConstraintResult parse(EObject evaluationTarget, EvaluationResult result) {
            this.currentevaluationTarget = evaluationTarget;
            ConstraintResult constraintResult = EvaluationResultFactory.eINSTANCE.createConstraintResult();
            constraintResult.setEvaluationTarget(evaluationTarget);
            Object evaluationResult = result.getEvaluationResult();
            if (evaluationResult instanceof Value) {
                constraintResult.setInterpreterResult(new EvaluationResult(CompleteOCLEvaluator.this.unwrap((Value)evaluationResult)));
            } else {
                constraintResult.setInterpreterResult(result);
            }
            if (this.getConstraintResultStatus(evaluationResult)) {
                constraintResult.setSeverity(Severity.OK);
            } else {
                switch (this.getConstraintResultSeverity(evaluationResult)) {
                    case 1: {
                        constraintResult.setSeverity(Severity.INFO);
                        break;
                    }
                    case 2: {
                        constraintResult.setSeverity(Severity.WARNING);
                        break;
                    }
                    case 4: {
                        constraintResult.setSeverity(Severity.ERROR);
                        break;
                    }
                    default: {
                        constraintResult.setSeverity(Severity.ERROR);
                    }
                }
                constraintResult.setMessage(this.getConstraintResultMessage(evaluationResult));
            }
            return constraintResult;
        }

        protected String getObjectLabel() {
            ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            IItemLabelProvider provider = (IItemLabelProvider)factory.adapt((Notifier)this.currentevaluationTarget, IItemLabelProvider.class);
            if (provider != null) {
                return provider.getText((Object)this.currentevaluationTarget);
            }
            return null;
        }

        protected ConstraintResult handleExceptionResult(Throwable e) {
            return null;
        }

        protected ConstraintResult handleFailureResult(Object result) {
            return null;
        }

        protected ConstraintResult handleInvalidResult(InvalidValueException e) {
            return null;
        }

        protected ConstraintResult handleSuccessResult() {
            return null;
        }

        protected ConstraintResult handleInvalidExpression(String message) {
            return null;
        }
    }
}

