/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.ocl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.SplitExpression;
import org.eclipse.acceleo.ui.interpreter.language.SubExpression;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLExpressionSplittingTask
implements Callable<SplitExpression> {
    private EvaluationContext context;

    public OCLExpressionSplittingTask(EvaluationContext context) {
        this.context = context;
    }

    @Override
    public SplitExpression call() throws Exception {
        SplitExpression result;
        CompilationResult compilationResult = this.context.getCompilationResult();
        if (compilationResult == null || compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0) {
            return null;
        }
        Object expression = compilationResult.getCompiledExpression();
        if (expression instanceof ExpressionInOCL) {
            SplittingVisitor visitor = new SplittingVisitor((ExpressionInOCL)expression);
            visitor.visitExpressionInOCL((ExpressionInOCL)expression);
            result = new SplitExpression(expression, visitor.getSubExpressions());
        } else {
            result = null;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SplittingVisitor
    extends AbstractExtendingVisitor<SubExpression, ExpressionInOCL> {
        private LinkedList<SubExpression> expressionStack = new LinkedList();

        public SplittingVisitor(ExpressionInOCL expressionInOCL) {
            super((Object)expressionInOCL);
        }

        public SubExpression visitExpressionInOCL(ExpressionInOCL object) {
            this.expressionStack.addFirst(new SubExpression((Object)object.getBodyExpression()));
            return (SubExpression)object.getBodyExpression().accept((Visitor)this);
        }

        public SubExpression visiting(Visitable visitable) {
            return null;
        }

        public SubExpression visitOperationCallExp(OperationCallExp object) {
            for (OCLExpression expression : object.getArgument()) {
                this.addAndVisitSubStep(expression);
            }
            SubExpression result = (SubExpression)super.visitOperationCallExp(object);
            return result;
        }

        public SubExpression visitLetExp(LetExp object) {
            this.addChild(new SubExpression((Object)object));
            object.getVariable().accept((Visitor)this);
            return this.addAndVisitSubStep(object.getIn());
        }

        public SubExpression visitVariable(Variable object) {
            return this.addAndVisitSubStep(object.getInitExpression());
        }

        public SubExpression visitIfExp(IfExp object) {
            this.addChild(new SubExpression((Object)object));
            SubExpression result = (SubExpression)super.visitIfExp(object);
            this.addAndVisitSubStep(object.getCondition());
            this.addAndVisitSubStep(object.getThenExpression());
            this.addAndVisitSubStep(object.getElseExpression());
            return result;
        }

        public SubExpression visitVariableExp(VariableExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitVariableExp(object);
        }

        public SubExpression visitLiteralExp(LiteralExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitLiteralExp(object);
        }

        public SubExpression visitCallExp(CallExp object) {
            this.addChild(new SubExpression((Object)object));
            return this.addAndVisitSubStep(object.getSource());
        }

        public List<SubExpression> getSubExpressions() {
            return this.expressionStack.pop().getSubSteps();
        }

        private SubExpression addAndVisitSubStep(OCLExpression subStep) {
            SubExpression subExpression = new SubExpression((Object)subStep);
            this.addChild(subExpression);
            this.expressionStack.addFirst(subExpression);
            subStep.accept((Visitor)this);
            this.expressionStack.pop();
            return subExpression;
        }

        private void addChild(SubExpression subExpression) {
            SubExpression parent = this.expressionStack.peek();
            if (!parent.getExpression().equals(subExpression.getExpression())) {
                parent.addSubStep(subExpression);
            }
        }
    }
}

