/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.IDSLDebugEvent;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.event.debugger.IDSLDebuggerReply;
import org.eclipse.acceleo.debug.event.model.IDSLModelRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DSLDebugEventDispatcher
extends Job
implements IDSLDebugEventProcessor {
    public static final String NAME = "DSL debugger event dispatcher";
    private final List<IDSLDebugEvent> events = new ArrayList<IDSLDebugEvent>();
    private boolean terminated;
    private IDSLDebugger debugger;
    private IDSLDebugEventProcessor model;

    public DSLDebugEventDispatcher() {
        super(NAME);
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (!this.terminated) {
            if (this.events.isEmpty()) {
                try {
                    DSLDebugEventDispatcher dSLDebugEventDispatcher = this;
                    synchronized (dSLDebugEventDispatcher) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!monitor.isCanceled()) {
                IDSLDebugEvent event = null;
                List<IDSLDebugEvent> list = this.events;
                synchronized (list) {
                    if (!this.events.isEmpty()) {
                        event = this.events.remove(0);
                    }
                }
                if (event == null) continue;
                this.handleEvent(event);
                continue;
            }
            this.terminate();
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object handleEvent(IDSLDebugEvent event) {
        Object res;
        if (event instanceof IDSLDebuggerReply) {
            res = this.model.handleEvent(event);
        } else if (event instanceof IDSLModelRequest) {
            res = this.debugger.handleEvent(event);
        } else {
            throw new RuntimeException("Unknown event detected: " + event);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IDSLDebugEvent event) {
        Object object = this.events;
        synchronized (object) {
            this.events.add(event);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminated = true;
        DSLDebugEventDispatcher dSLDebugEventDispatcher = this;
        synchronized (dSLDebugEventDispatcher) {
            this.notifyAll();
        }
    }

    public void setDebugger(IDSLDebugger debugger) {
        this.debugger = debugger;
    }

    public void setModel(IDSLDebugEventProcessor model) {
        this.model = model;
    }
}

